/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.JoinCondition;
import org.eclipse.birt.data.engine.core.DataException;

public class JointDataSetDesign
extends BaseDataSetDesign
implements IJointDataSetDesign {
    private String left;
    private String right;
    private int joinType = 0;
    private List joinConditions = new ArrayList();
    private String rightDataSetQualifiedName;
    private String leftDataSetQualifiedName;

    public JointDataSetDesign(String dataSetName) {
        super(dataSetName);
    }

    public JointDataSetDesign(String name, String left, String right, int joinType, List joinConditions) throws DataException {
        super(name);
        this.validateJoinType(joinType);
        this.right = right;
        this.left = left;
        this.joinType = joinType;
        this.joinConditions.addAll(joinConditions);
    }

    private void validateJoinType(int joinType) throws DataException {
        if (joinType != 0 && joinType != 1 && joinType != 2 && joinType != 3) {
            throw new DataException("data.engine.InvalidJoinType");
        }
    }

    @Override
    public String getLeftDataSetDesignName() {
        return this.left;
    }

    public void setLeftDataSetDesignName(String dataSetName) {
        this.left = dataSetName;
    }

    @Override
    public String getRightDataSetDesignName() {
        return this.right;
    }

    public void setRightDataSetDesignName(String dataSetName) {
        this.right = dataSetName;
    }

    @Override
    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    @Override
    public List getJoinConditions() {
        return this.joinConditions;
    }

    public void addJoinCondition(JoinCondition jc) {
        this.joinConditions.add(jc);
    }

    @Override
    public String getLeftDataSetDesignQulifiedName() {
        if (this.leftDataSetQualifiedName == null) {
            return this.left;
        }
        return this.leftDataSetQualifiedName;
    }

    public void setLeftDataSetDesignQulifiedName(String leftDataSetQualifiedName) {
        this.leftDataSetQualifiedName = leftDataSetQualifiedName;
    }

    @Override
    public String getRightDataSetDesignQulifiedName() {
        if (this.rightDataSetQualifiedName == null) {
            return this.right;
        }
        return this.rightDataSetQualifiedName;
    }

    public void setRightDataSetDesignQulifiedName(String rightDataSetQualifiedName) {
        this.rightDataSetQualifiedName = rightDataSetQualifiedName;
    }
}

