/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.actions;

import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.internal.ui.actions.ConvertTargetDialog;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ConvertTargetAction
extends ActionDelegate
implements IObjectActionDelegate {
    private IProject selectedProject = null;
    public static final String PREFIX = "ProjectConvert";
    public static final String PROJECT_CONVERTER_DIALOG = "ProjectConvert.title";

    public static void initStartup() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            IProject project = (IProject)obj;
            this.setSelectedProject(project);
            return;
        }
        this.setSelectedProject(null);
    }

    private IProjectType getProjectType(IProject project) {
        IManagedProject managedProject;
        IProjectType projectType = null;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null && (managedProject = info.getManagedProject()) != null) {
            projectType = managedProject.getProjectType();
        }
        return projectType;
    }

    private Vector<IBuildObject> getProjectToolchains(IProject project) {
        Vector<IBuildObject> projectToolchains = new Vector<IBuildObject>();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            IConfiguration[] configs;
            IConfiguration[] iConfigurationArray = configs = info.getManagedProject().getConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                IToolChain tc = config.getToolChain();
                if (tc != null) {
                    projectToolchains.add((IBuildObject)tc);
                }
                ++n2;
            }
        }
        return projectToolchains;
    }

    public void run(IAction action) {
        Shell shell = CUIPlugin.getActiveWorkbenchShell();
        if (ManagedBuildManager.hasTargetConversionElements((IBuildObject)this.getProjectType(this.getSelectedProject())) || ManagedBuildManager.hasAnyTargetConversionElements(this.getProjectToolchains(this.getSelectedProject()))) {
            this.handleConvertTargetAction();
        } else {
            MessageDialog.openError((Shell)shell, (String)Messages.ConvertTargetAction_No_Converter, (String)NLS.bind((String)Messages.ProjectConvert_noConverterErrordialog_message, (Object[])new String[]{this.getSelectedProject().getName()}));
        }
    }

    private void handleConvertTargetAction() {
        Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
        String projectName = this.getSelectedProject().getName();
        String title = NLS.bind((String)Messages.ProjectConvert_title, (Object)new String(projectName));
        ConvertTargetDialog dialog = new ConvertTargetDialog(shell, this.getSelectedProject(), title);
        if (dialog.open() == 0 && !ConvertTargetDialog.isConversionSuccessful()) {
            MessageDialog.openError((Shell)shell, (String)Messages.ProjectConvert_conversionErrordialog_title, (String)NLS.bind((String)Messages.ProjectConvert_conversionErrordialog_message, (Object)projectName));
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private IProject getSelectedProject() {
        return this.selectedProject;
    }

    private void setSelectedProject(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }
}

