/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.IRemoteServicesDescriptor;
import org.eclipse.remote.core.IRemoteServicesFactory;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.messages.Messages;

public class RemoteServicesDescriptor
implements IRemoteServicesDescriptor {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SCHEME = "scheme";
    private static final String ATTR_CLASS = "class";
    private final IConfigurationElement fConfigElement;
    private final String fId;
    private final String fName;
    private final String fScheme;
    private IRemoteServicesFactory fFactory;
    private IRemoteServices fDelegate = null;

    private static String getAttribute(IConfigurationElement configElement, String name, String defaultValue) {
        String value = configElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.RemoteServicesProxy_0, (Object)name));
    }

    public RemoteServicesDescriptor(IConfigurationElement configElement) {
        this.fConfigElement = configElement;
        this.fId = RemoteServicesDescriptor.getAttribute(configElement, ATTR_ID, null);
        this.fName = RemoteServicesDescriptor.getAttribute(configElement, ATTR_NAME, this.fId);
        this.fScheme = RemoteServicesDescriptor.getAttribute(configElement, ATTR_SCHEME, null);
        RemoteServicesDescriptor.getAttribute(configElement, ATTR_CLASS, null);
        this.fFactory = null;
    }

    @Override
    public int compareTo(IRemoteServicesDescriptor arg0) {
        return this.getName().compareTo(arg0.getName());
    }

    public IRemoteServicesFactory getFactory() {
        if (this.fFactory != null) {
            return this.fFactory;
        }
        try {
            this.fFactory = (IRemoteServicesFactory)this.fConfigElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {
            RemoteCorePlugin.log(NLS.bind((String)Messages.RemoteServicesProxy_1, (Object[])new Object[]{this.fConfigElement.getAttribute(ATTR_CLASS), this.fId, this.fConfigElement.getDeclaringExtension().getNamespaceIdentifier()}));
        }
        return this.fFactory;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getScheme() {
        return this.fScheme;
    }

    public IRemoteServices getServices() {
        this.loadServices();
        return this.fDelegate;
    }

    private void loadServices() {
        IRemoteServicesFactory factory;
        if (this.fDelegate == null && (factory = this.getFactory()) != null) {
            this.fDelegate = factory.getServices(this);
        }
    }
}

