/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import java.util.Map;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ResourceIcon
extends LabelAttribute {
    private final String propertyName;

    public ResourceIcon(String propertyName) {
        super(new String[]{propertyName});
        this.propertyName = propertyName;
    }

    public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
        if (properties.containsKey(this.propertyName)) {
            Object object = properties.get(this.propertyName);
            if (object instanceof IStorage) {
                IPath path = ((IStorage)object).getFullPath();
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(path.toFile().toURI());
                if (files.length > 0) {
                    object = files[0];
                }
            }
            if (object instanceof IAdaptable) {
                this.fillImageDescriptor(update, (IAdaptable)object, columnIndex);
            }
        }
        update.done();
    }

    private void fillImageDescriptor(ILabelUpdate update, IAdaptable adaptable, int columnIndex) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (adapter != null) {
            ImageDescriptor imageDescriptor = adapter.getImageDescriptor((Object)adaptable);
            update.setImageDescriptor(imageDescriptor, columnIndex);
        }
    }
}

