/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaThreadColumns;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.IMultiColumnVMNode;
import com.nvidia.cuda.ide.debug.util.LabelUpdateDecorator;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;

public class MultiColumnLabelProvider
implements IElementLabelProvider {
    private final IElementLabelProvider delegate;
    private final IMultiColumnVMNode node;

    public MultiColumnLabelProvider(IMultiColumnVMNode node, IElementLabelProvider delegate) {
        this.node = node;
        this.delegate = delegate;
    }

    public void update(final ILabelUpdate[] updates) {
        ICudaThreadColumns provider = this.getProvider(updates);
        if (provider != null) {
            this.fillValueInOtherThreads(provider, updates, new RequestMonitor(provider.getExecutor(), null){

                protected void handleCompleted() {
                    MultiColumnLabelProvider.this.delegate.update(updates);
                }
            });
        } else {
            this.delegate.update(updates);
        }
    }

    private void fillValueInOtherThreads(ICudaThreadColumns provider, ILabelUpdate[] updates, RequestMonitor rm) {
        CountingRequestMonitor crm = new CountingRequestMonitor(provider.getExecutor(), rm);
        int count = 0;
        if (updates.length > 0) {
            int columnNo = 0;
            while (columnNo < updates[0].getColumnIds().length) {
                IFocusDMContext focus = provider.getColumnFocus(updates[0].getColumnIds()[columnNo]);
                if (focus != null) {
                    ++count;
                    this.fillThreadValues(provider.getExecutor(), focus, updates, columnNo, (RequestMonitor)crm);
                }
                ++columnNo;
            }
        }
        crm.setDoneCount(count);
    }

    private void fillThreadValues(final Executor executor, IFocusDMContext focus, final ILabelUpdate[] updates, final int columnNo, final RequestMonitor rm) {
        final IDMContext[] contexts = new IDMContext[updates.length];
        int i = 0;
        while (i < updates.length) {
            contexts[i] = DebugUtil.adapt(updates[i].getElement(), IDMContext.class);
            ++i;
        }
        focus.getExpressionContexts(contexts, new DataRequestMonitor<IDMContext[]>(executor, rm){

            protected void handleSuccess() {
                if (this.getStatus() != null && !this.getStatus().isOK()) {
                    ILabelUpdate[] iLabelUpdateArray = updates;
                    int n = updates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILabelUpdate update = iLabelUpdateArray[n2];
                        MultiColumnLabelProvider.this.fillErrorColumn(update, columnNo, this.getStatus().getMessage());
                        ++n2;
                    }
                    rm.done();
                } else if (this.getData() != null) {
                    MultiColumnLabelProvider.this.updateValueColumn(executor, contexts, (IDMContext[])this.getData(), updates, columnNo, rm);
                } else {
                    rm.done();
                }
            }
        });
    }

    protected void fillErrorColumn(ILabelUpdate update, int columnNo, String message) {
        update.setBackground(DebugUtil.getRGBColor(34), columnNo);
        update.setLabel(message, columnNo);
        update.setFontData(DebugUtil.getItalicFontData(), columnNo);
    }

    private void updateValueColumn(Executor executor, IDMContext[] contexts, IDMContext[] expressionContext, ILabelUpdate[] updates, int columnNo, RequestMonitor rm) {
        final ArrayList<LabelUpdateDecorator> delegateUpdates = new ArrayList<LabelUpdateDecorator>(expressionContext.length);
        CountingRequestMonitor crm = new CountingRequestMonitor(executor, rm);
        int i = 0;
        while (i < contexts.length) {
            IDMContext expressionDM = expressionContext[i];
            Object expressionDMVM = null;
            if (expressionDM == contexts[i]) {
                expressionDMVM = updates[i].getElement();
            } else if (expressionDM != null) {
                expressionDMVM = this.node.createVMContext(expressionDM);
            } else {
                this.fillNAColumn(updates[i], columnNo);
            }
            if (expressionDMVM != null) {
                delegateUpdates.add(this.createUpdate(expressionDMVM, updates[i], columnNo, (RequestMonitor)crm));
            }
            ++i;
        }
        crm.setDoneCount(delegateUpdates.size());
        this.node.getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                MultiColumnLabelProvider.this.delegate.update(delegateUpdates.toArray(new ILabelUpdate[delegateUpdates.size()]));
            }
        });
    }

    private LabelUpdateDecorator createUpdate(Object element, ILabelUpdate update, int columnNo, RequestMonitor rm) {
        return new LabelUpdateDecorator(element, update, columnNo, "org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE", rm);
    }

    private void fillNAColumn(ILabelUpdate update, int columnNo) {
        update.setLabel("n/a", columnNo);
    }

    private ICudaThreadColumns getProvider(ILabelUpdate[] updates) {
        IVMProvider provider = this.node.getVMProvider();
        if (provider instanceof ICudaThreadColumns) {
            return (ICudaThreadColumns)provider;
        }
        return null;
    }
}

