/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.service.ICudaProcesses;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class NoCudaElementsNode
extends AbstractDMVMNode
implements IElementLabelProvider {
    public NoCudaElementsNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, NoElementsDMContext.class);
    }

    public int getDeltaFlags(Object event) {
        if (event instanceof FullStackRefreshEvent) {
            return 1024;
        }
        if (event instanceof IRunControl.IResumedDMEvent) {
            return 2048;
        }
        return 0;
    }

    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        requestMonitor.done();
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        ICudaApplication application;
        ICudaProcesses processes = (ICudaProcesses)this.getServicesTracker().getService(ICudaProcesses.class);
        if (processes != null && (application = processes.getApplication()) != null) {
            application.getKernels((DataRequestMonitor<? super Kernel[]>)new ViewerDataRequestMonitor<Kernel[]>((Executor)new ImmediateInDsfExecutor(this.getSession().getExecutor()), (IViewerUpdate)update){

                protected void handleSuccess() {
                    IDMContext[] dmcs = new IDMContext[]{};
                    if (this.getData() == null || ((Kernel[])this.getData()).length == 0) {
                        dmcs = new IDMContext[]{new NoElementsDMContext(NoCudaElementsNode.this.getSession())};
                    }
                    NoCudaElementsNode.this.fillUpdateWithVMCs(update, dmcs);
                    update.done();
                }
            });
            return;
        }
        this.fillUpdateWithVMCs(update, new IDMContext[]{new NoElementsDMContext(this.getSession())});
        update.done();
    }

    public void update(ILabelUpdate[] updates) {
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelUpdate update = iLabelUpdateArray[n2];
            int column = -1;
            if (update.getColumnIds() == null) {
                column = 0;
            } else {
                String[] ids = update.getColumnIds();
                int i = 0;
                while (i < ids.length) {
                    String string = ids[i];
                    if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME".equals(string)) {
                        column = i;
                        break;
                    }
                    ++i;
                }
            }
            if (column >= 0) {
                String label = "No CUDA kernels running";
                IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
                if (runControl != null && !runControl.isSuspended(null)) {
                    label = "Suspend application to view kernels";
                }
                update.setLabel(label, column);
                update.setForeground(DebugUtil.getRGBColor(33), column);
            }
            update.done();
            ++n2;
        }
    }

    private final class NoElementsDMContext
    extends AbstractDMContext {
        public NoElementsDMContext(DsfSession session) {
            super(session, new IDMContext[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof NoElementsDMContext && ((Object)((Object)NoCudaElementsNode.this)).equals((Object)((NoElementsDMContext)((Object)obj)).getVMNode());
        }

        private NoCudaElementsNode getVMNode() {
            return NoCudaElementsNode.this;
        }

        public int hashCode() {
            return ((Object)((Object)NoCudaElementsNode.this)).hashCode() * 31;
        }
    }
}

