/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.events.ElementPinnedStatusEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.AbstractCudaDMVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.WarpVMNode;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelFont;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.RIRequestMonitor;
import com.nvidia.cuda.ide.debug.util.ResourceIcon;
import com.nvidia.cuda.ide.debug.util.ThreadImage;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExecutionContextLabelText;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.ui.IMemento;

public final class LaneVMNode
extends AbstractCudaDMVMNode<Lane> {
    public LaneVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, Lane.class);
    }

    @Override
    public void buildDelta(Object event, final VMDelta parent, int nodeOffset, final RequestMonitor requestMonitor) {
        if (event instanceof ElementPinnedStatusEvent) {
            DeviceThread dmc = ((ElementPinnedStatusEvent)event).getDMContext();
            dmc.toHardwareElement(new DataRequestMonitor<ICudaRuntimeObject>(this.getExecutor(), requestMonitor){

                protected void handleSuccess() {
                    if (this.getData() != null) {
                        parent.addNode((Object)LaneVMNode.this.createVMContext((IDMContext)this.getData()), 2048);
                    }
                    requestMonitor.done();
                }
            });
            return;
        }
        super.buildDelta(event, parent, nodeOffset, requestMonitor);
    }

    @Override
    protected boolean compareElement(Lane object, IMemento memento) {
        return object != null && WarpVMNode.compareWarps((Warp)DMContexts.getAncestorOfType((IDMContext)object, Warp.class), memento) && Integer.valueOf(object.getId()).equals(memento.getInteger("lane_id"));
    }

    private LabelColumnInfo createLabelColumnInfo() {
        return new LabelColumnInfo(new LabelAttribute[]{new ExecutionContextLabelText("Lane {0}", new String[]{"id"}){}, new ThreadImage(CudaDebugImages.LANE, CudaDebugImages.LANE_DIVERGENT, CudaDebugImages.LANE_INACTIVE), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false), new ConditionalLabelFont(true, false, "cuda_object_pinned")});
    }

    @Override
    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createLabelColumnInfo());
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__HARDWARE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#Thread {1}}", new String[]{"is_active_i", "thread_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#{1}:{2} ({3})}", new String[]{"is_active_i", "source_file", "source_line", "phys_pc_formatted"}), new ResourceIcon("source_resource")}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#{1}:{2} ({3})}", new String[]{"is_active_i", "source_file", "source_line", "pc_formatted"}), new ResourceIcon("source_resource")}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createLabelColumnInfo());
        return provider;
    }

    @Override
    protected void encodeElement(Lane object, IMemento memento) {
        if (object != null) {
            WarpVMNode.encodeWarp((Warp)DMContexts.getParentOfType((IDMContext)object, Warp.class), memento);
            memento.putInteger("lane_id", (int)object.getId());
        }
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object event, final DataRequestMonitor<IVMContext[]> rm) {
        if (event instanceof ElementPinnedStatusEvent) {
            DeviceThread dmc = ((ElementPinnedStatusEvent)event).getDMContext();
            dmc.toHardwareElement(new DataRequestMonitor<ICudaRuntimeObject>(this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (this.getData() != null) {
                        rm.setData((Object)LaneVMNode.this.dmcs2vmcs(new IDMContext[]{(IDMContext)this.getData()}));
                    }
                    rm.done();
                }
            });
            return;
        }
        super.getContextsForEvent(parentDelta, event, rm);
    }

    @Override
    public int getDeltaFlags(Object event) {
        if (event instanceof ElementPinnedStatusEvent) {
            return 2048;
        }
        if (event instanceof DoubleClickEvent) {
            DebugUtil.togglePinOnDoubleclick(((DoubleClickEvent)event).getSelection(), (IVMNode)this, this.getServicesTracker());
        }
        return super.getDeltaFlags(event);
    }

    @Override
    protected String getInactiveElementRangeLabel(RangeContext rangeContext, boolean singleColumn) {
        return MessageFormat.format((String)"{0,choice,0#Lane {1}|1<Lanes {1} - {2}}", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart() + 1L, rangeContext.getStart(), rangeContext.getEnd()});
    }

    @Override
    protected String getInactiveElementRangeStateLabel(RangeContext rangeContext) {
        long count = rangeContext.getEnd() - rangeContext.getStart() + 1L;
        return MessageFormat.format((String)"{0,choice,1#Inactive|1<{0} Inactive Lanes}", (Object[])new Object[]{count});
    }

    @Override
    protected boolean isLogicalNode() {
        return false;
    }

    @Override
    protected void updatePropertiesInSessionThread(Lane element, IPropertiesUpdate update) {
        update.setProperty("id", (Object)element.getId());
        RIRequestMonitor.fill(update, this.getExecutor(), element, (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class));
    }

    @Override
    protected CudaDebugImages getInactiveImageDescriptor() {
        return CudaDebugImages.LANE_INACTIVE;
    }
}

