/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.IFilterCondition;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public class HardwareVerticalCondition
implements IFilterCondition {
    private final short deviceId;
    private final short sm;
    private final short warp;
    private final short lane;

    public HardwareVerticalCondition(short deviceId, short sm, short warpId, short lane) {
        this.deviceId = deviceId;
        this.sm = sm;
        this.warp = warpId;
        this.lane = lane;
    }

    public HardwareVerticalCondition(short deviceId, short sm, short warpId) {
        this(deviceId, sm, warpId, -1);
    }

    @Override
    public boolean isAllElements() {
        return this.deviceId < 0 && this.sm < 0 && this.warp < 0 && this.lane < 0;
    }

    @Override
    public boolean matches(ICudaRuntimeObject o) {
        if (o instanceof Lane) {
            return (this.lane < 0 || ((Lane)o).getId() == this.lane) && this.matches((ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)o, Warp.class));
        }
        if (o instanceof Warp) {
            return (this.warp < 0 || ((Warp)o).getId() == this.warp) && this.matches((ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)o, StreamingMultiprocessor.class));
        }
        if (o instanceof StreamingMultiprocessor) {
            return (this.sm < 0 || ((StreamingMultiprocessor)o).getId() == this.sm) && this.matches((ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)o, Device.class));
        }
        if (o instanceof Device) {
            return this.matchDevice((Device)o);
        }
        return false;
    }

    private boolean matchDevice(Device device) {
        return (this.deviceId < 0 || device.getId() == this.deviceId) && device.getSmCount() > this.sm && device.getWarpCount() > this.warp && device.getLaneCount() > 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.deviceId >= 0) {
            buffer.append("device ").append(this.deviceId);
        }
        if (this.sm >= 0) {
            buffer.append(" sm ").append(this.sm);
        }
        if (this.warp >= 0) {
            buffer.append(" warp ").append(this.warp);
        }
        if (this.lane >= 0) {
            buffer.append(" lane ").append(this.lane);
        }
        return "(" + buffer.toString().trim() + ")";
    }

    public int hashCode() {
        int result = this.deviceId;
        result = 31 * result + this.lane;
        result = 31 * result + this.sm;
        result = 31 * result + this.warp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HardwareVerticalCondition other = (HardwareVerticalCondition)obj;
        if (this.deviceId != other.deviceId) {
            return false;
        }
        if (this.lane != other.lane) {
            return false;
        }
        if (this.sm != other.sm) {
            return false;
        }
        return this.warp == other.warp;
    }

    @Override
    public boolean isHardware() {
        return true;
    }

    @Override
    public CudaCoord[] filterBlocks(Kernel kernel) {
        return null;
    }

    @Override
    public CudaCoord[] filterThreads(Block block) {
        return null;
    }

    @Override
    public long getEnabledLanes(Warp warp) {
        if (this.matches(warp)) {
            if (this.lane < 0) {
                return Long.MIN_VALUE;
            }
            short count = ((Device)DMContexts.getAncestorOfType((IDMContext)warp, Device.class)).getLaneCount();
            return this.lane < count ? 1L << this.lane : 0L;
        }
        return 0L;
    }

    @Override
    public long getEnabledSMs(Device device) {
        if (this.matches(device)) {
            if (this.sm < 0) {
                return Long.MIN_VALUE;
            }
            return this.sm < device.getSmCount() ? 1L << this.sm : 0L;
        }
        return 0L;
    }

    @Override
    public long getEnabledWarps(StreamingMultiprocessor sm) {
        if (this.matches(sm)) {
            if (this.warp < 0) {
                return Long.MIN_VALUE;
            }
            short count = ((Device)DMContexts.getAncestorOfType((IDMContext)sm, Device.class)).getWarpCount();
            return this.warp < count ? 1L << this.warp : 0L;
        }
        return 0L;
    }

    @Override
    public ElementType getElementType() {
        if (this.lane >= 0) {
            return ElementType.lane;
        }
        if (this.warp >= 0) {
            return ElementType.warp;
        }
        if (this.sm >= 0) {
            return ElementType.sm;
        }
        if (this.deviceId >= 0) {
            return ElementType.device;
        }
        return ElementType.application;
    }
}

