/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaObjectsFactory;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Warp;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;

public class StreamingMultiprocessor
extends AbstractDMContext
implements ICudaRuntimeObject {
    private final short id;
    private final Device device;

    public StreamingMultiprocessor(Device device, short id) {
        super(device.getSessionId(), new IDMContext[]{device});
        this.device = device;
        if (DsfSession.getSession((String)device.getSessionId()) == null) {
            throw new IllegalStateException();
        }
        this.id = id;
    }

    public short getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamingMultiprocessor) {
            return ((StreamingMultiprocessor)obj).getId() == this.getId() && ((StreamingMultiprocessor)obj).device.equals(this.device);
        }
        return false;
    }

    public int hashCode() {
        return (this.getDeviceId() << 10) + this.id + 7;
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)this, ICudaApplication.class)).getSMState(this, rm);
    }

    public short getDeviceId() {
        return ((Device)DMContexts.getParentOfType((IDMContext)this, Device.class)).getId();
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitSM(this);
    }

    @Override
    public ElementType getType() {
        return ElementType.sm;
    }

    public String toString() {
        return String.format("%s SM %d", this.getParents()[0], this.getId());
    }

    @Override
    public void toHardwareElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }

    @Override
    public void toLogicalElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.done();
    }

    public Warp getWarp(short id) throws CudaException {
        return CudaObjectsFactory.getInstance().newWarp(this, id);
    }
}

