/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.TempFile;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.taskdefs.optional.junit.XMLResultAggregator;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.w3c.dom.Document;

public class AggregateTransformer {
    public static final String FRAMES = "frames";
    public static final String NOFRAMES = "noframes";
    protected Task task;
    protected Document document;
    protected File styleDir;
    protected File toDir;
    private List params;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static int counter = 0;
    protected String format = "frames";
    private static DocumentBuilderFactory privateDBFactory;
    protected static DocumentBuilderFactory dbfactory;

    public AggregateTransformer(Task task) {
        this.task = task;
        this.params = new Vector();
    }

    protected static DocumentBuilderFactory getDocumentBuilderFactory() {
        return privateDBFactory;
    }

    public void setFormat(Format format) {
        this.format = format.getValue();
    }

    public void setXmlDocument(Document doc) {
        this.document = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXmlfile(File xmlfile) throws BuildException {
        try {
            DocumentBuilder builder = privateDBFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(xmlfile);
            try {
                Document doc = builder.parse(in);
                this.setXmlDocument(doc);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
        catch (Exception e) {
            throw new BuildException("Error while parsing document: " + xmlfile, (Throwable)e);
        }
    }

    public void setStyledir(File styledir) {
        this.styleDir = styledir;
    }

    public void setTodir(File todir) {
        this.toDir = todir;
    }

    public void setExtension(String ext) {
        this.task.log("extension is not used anymore", 1);
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param p = new XSLTProcess.Param();
        this.params.add(p);
        return p;
    }

    public void transform() throws BuildException {
        this.checkOptions();
        Project project = this.task.getProject();
        TempFile tempFileTask = new TempFile();
        tempFileTask.bindToOwner(this.task);
        XSLTProcess xsltTask = new XSLTProcess();
        xsltTask.bindToOwner(this.task);
        xsltTask.setXslResource(this.getStylesheet());
        xsltTask.setIn(((XMLResultAggregator)this.task).getDestinationFile());
        File outputFile = null;
        if (this.format.equals(FRAMES)) {
            String tempFileProperty = this.getClass().getName() + String.valueOf(counter++);
            File tmp = FILE_UTILS.resolveFile(project.getBaseDir(), project.getProperty("java.io.tmpdir"));
            tempFileTask.setDestDir(tmp);
            tempFileTask.setProperty(tempFileProperty);
            tempFileTask.execute();
            outputFile = new File(project.getProperty(tempFileProperty));
        } else {
            outputFile = new File(this.toDir, "junit-noframes.html");
        }
        xsltTask.setOut(outputFile);
        for (XSLTProcess.Param param : this.params) {
            XSLTProcess.Param newParam = xsltTask.createParam();
            newParam.setProject(this.task.getProject());
            newParam.setName(param.getName());
            newParam.setExpression(param.getExpression());
        }
        XSLTProcess.Param paramx = xsltTask.createParam();
        paramx.setProject(this.task.getProject());
        paramx.setName("output.dir");
        paramx.setExpression(this.toDir.getAbsolutePath());
        long t0 = System.currentTimeMillis();
        try {
            xsltTask.execute();
        }
        catch (Exception e) {
            throw new BuildException("Errors while applying transformations: " + e.getMessage(), (Throwable)e);
        }
        long dt = System.currentTimeMillis() - t0;
        this.task.log("Transform time: " + dt + "ms");
        if (this.format.equals(FRAMES)) {
            Delete delete = new Delete();
            delete.bindToOwner(this.task);
            delete.setFile(outputFile);
            delete.execute();
        }
    }

    protected Resource getStylesheet() {
        String xslname = "junit-frames.xsl";
        if (NOFRAMES.equals(this.format)) {
            xslname = "junit-noframes.xsl";
        }
        if (this.styleDir == null) {
            URL stylesheetURL = this.getClass().getClassLoader().getResource("org/apache/tools/ant/taskdefs/optional/junit/xsl/" + xslname);
            return new URLResource(stylesheetURL);
        }
        return new FileResource(new File(this.styleDir, xslname));
    }

    protected void checkOptions() throws BuildException {
        if (this.toDir == null) {
            this.toDir = this.task.getProject().resolveFile(".");
        } else if (!this.toDir.isAbsolute()) {
            this.toDir = this.task.getProject().resolveFile(this.toDir.getPath());
        }
    }

    protected String getStylesheetSystemId() throws IOException {
        String xslname = "junit-frames.xsl";
        if (NOFRAMES.equals(this.format)) {
            xslname = "junit-noframes.xsl";
        }
        if (this.styleDir == null) {
            URL url = this.getClass().getResource("xsl/" + xslname);
            if (url == null) {
                throw new FileNotFoundException("Could not find jar resource " + xslname);
            }
            return url.toExternalForm();
        }
        File file = new File(this.styleDir, xslname);
        if (!file.exists()) {
            throw new FileNotFoundException("Could not find file '" + file + "'");
        }
        return JAXPUtils.getSystemId((File)file);
    }

    static {
        dbfactory = privateDBFactory = DocumentBuilderFactory.newInstance();
    }

    public static class Format
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{AggregateTransformer.FRAMES, AggregateTransformer.NOFRAMES};
        }
    }
}

