/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class FindBinding {
    public static PDOMBinding findBinding(BTree btree, PDOMLinkage linkage, char[] name, int[] constants, long localToFileRec) throws CoreException {
        DefaultFindBindingVisitor visitor = new DefaultFindBindingVisitor(linkage, name, constants, localToFileRec);
        btree.accept(visitor);
        return visitor.getResult();
    }

    public static PDOMBinding findBinding(IPDOMNode node, PDOMLinkage linkage, char[] name, int[] constants, long localToFileRec) throws CoreException {
        DefaultFindBindingVisitor visitor = new DefaultFindBindingVisitor(linkage, name, constants, localToFileRec);
        try {
            node.accept(visitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
        return visitor.getResult();
    }

    public static class DefaultBindingBTreeComparator
    implements IBTreeComparator {
        protected final PDOMLinkage linkage;
        protected final Database database;

        public DefaultBindingBTreeComparator(PDOMLinkage linkage) {
            this.linkage = linkage;
            this.database = linkage.getDB();
        }

        @Override
        public int compare(long record1, long record2) throws CoreException {
            IString nm2;
            IString nm1 = PDOMNamedNode.getDBName(this.database, record1);
            int cmp = nm1.compareCompatibleWithIgnoreCase(nm2 = PDOMNamedNode.getDBName(this.database, record2));
            if (cmp == 0) {
                long t2;
                long t1 = PDOMBinding.getLocalToFileRec(this.database, record1);
                if (t1 == (t2 = PDOMBinding.getLocalToFileRec(this.database, record2)) && (t1 = (long)PDOMNode.getNodeType(this.database, record1)) == (t2 = (long)PDOMNode.getNodeType(this.database, record2)) && t1 == 3L) {
                    t1 = record1;
                    t2 = record2;
                }
                cmp = t1 < t2 ? -1 : (t1 > t2 ? 1 : 0);
            }
            return cmp;
        }
    }

    public static class DefaultFindBindingVisitor
    implements IBTreeVisitor,
    IPDOMVisitor {
        protected final PDOMLinkage fLinkage;
        private final char[] fName;
        private final int[] fConstants;
        private final long fLocalToFile;
        protected PDOMBinding fResult;

        protected DefaultFindBindingVisitor(PDOMLinkage linkage, char[] name, int[] constants, long localToFile) {
            this.fLinkage = linkage;
            this.fName = name;
            this.fConstants = constants;
            this.fLocalToFile = localToFile;
        }

        @Override
        public int compare(long record) throws CoreException {
            Database db = this.fLinkage.getDB();
            IString nm1 = PDOMNamedNode.getDBName(db, record);
            int cmp = nm1.compareCompatibleWithIgnoreCase(this.fName);
            if (cmp == 0) {
                long t2;
                long t1 = PDOMBinding.getLocalToFileRec(db, record);
                cmp = t1 < (t2 = this.fLocalToFile) ? -1 : (t1 > t2 ? 1 : 0);
            }
            return cmp;
        }

        @Override
        public boolean visit(long record) throws CoreException {
            PDOMBinding binding;
            PDOMNamedNode nnode = (PDOMNamedNode)PDOMNode.load(this.fLinkage.getPDOM(), record);
            if (nnode instanceof PDOMBinding && this.matches(binding = (PDOMBinding)nnode)) {
                this.fResult = binding;
                return false;
            }
            return true;
        }

        protected boolean matches(PDOMBinding nnode) throws CoreException {
            if (nnode.hasName(this.fName)) {
                int constant = nnode.getNodeType();
                int[] nArray = this.fConstants;
                int n = this.fConstants.length;
                int n2 = 0;
                while (n2 < n) {
                    int c = nArray[n2];
                    if (constant == c) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public PDOMBinding getResult() {
            return this.fResult;
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            PDOMBinding nnode;
            if (node instanceof PDOMBinding && this.matches(nnode = (PDOMBinding)node)) {
                this.fResult = nnode;
                throw new OperationCanceledException();
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
        }
    }

    public static class MacroBTreeComparator
    implements IBTreeComparator {
        private final Database db;

        public MacroBTreeComparator(Database database) {
            this.db = database;
        }

        @Override
        public int compare(long record1, long record2) throws CoreException {
            return this.compare(PDOMNamedNode.getDBName(this.db, record1), PDOMNamedNode.getDBName(this.db, record2));
        }

        private int compare(IString nameInDB, IString nameInDB2) throws CoreException {
            return nameInDB.compareCompatibleWithIgnoreCase(nameInDB2);
        }
    }

    public static class NestedBindingsBTreeComparator
    extends DefaultBindingBTreeComparator {
        public NestedBindingsBTreeComparator(PDOMLinkage linkage) {
            super(linkage);
        }

        @Override
        public int compare(long record1, long record2) throws CoreException {
            int cmp = super.compare(record1, record2);
            if (cmp == 0) {
                if (record1 < record2) {
                    return -1;
                }
                if (record1 > record2) {
                    return 1;
                }
            }
            return cmp;
        }
    }
}

