/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.model.DefaultPathEntryStore;
import org.eclipse.cdt.internal.core.settings.model.AbstractCExtensionProxy;
import org.eclipse.cdt.internal.core.settings.model.ConfigBasedPathEntryStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class PathEntryStoreProxy
extends AbstractCExtensionProxy
implements IPathEntryStore,
IPathEntryStoreListener {
    private List<IPathEntryStoreListener> fListeners = Collections.synchronizedList(new ArrayList());
    private IPathEntryStore fStore;

    public PathEntryStoreProxy(IProject project) {
        super(project, "org.eclipse.cdt.core.PathEntryStore");
    }

    public IPathEntryStore getStore() {
        this.providerRequested();
        return this.fStore;
    }

    @Override
    public void addPathEntryStoreListener(IPathEntryStoreListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void removePathEntryStoreListener(IPathEntryStoreListener listener) {
        this.fListeners.remove(listener);
    }

    private void fireContentChangedEvent(IProject project) {
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, project, 1);
        this.notifyListeners(evt);
    }

    private void notifyListeners(PathEntryStoreChangedEvent evt) {
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.fListeners.size()];
        this.fListeners.toArray(observers);
        int i = 0;
        while (i < observers.length) {
            observers[i].pathEntryStoreChanged(evt);
            ++i;
        }
    }

    @Override
    public void close() {
        super.close();
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, this.getProject(), 2);
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.fListeners.size()];
        this.fListeners.toArray(observers);
        int i = 0;
        while (i < observers.length) {
            observers[i].pathEntryStoreChanged(evt);
            ++i;
        }
    }

    @Override
    public IProject getProject() {
        return super.getProject();
    }

    @Override
    public ICExtensionReference getExtensionReference() {
        return null;
    }

    @Override
    public ICConfigExtensionReference getConfigExtensionReference() {
        return null;
    }

    @Override
    public IPathEntry[] getRawPathEntries() throws CoreException {
        this.providerRequested();
        return this.fStore.getRawPathEntries();
    }

    @Override
    public void setRawPathEntries(IPathEntry[] entries) throws CoreException {
        this.providerRequested();
        this.fStore.setRawPathEntries(entries);
    }

    @Override
    public void pathEntryStoreChanged(PathEntryStoreChangedEvent event) {
        this.notifyListeners(event);
    }

    @Override
    protected Object createDefaultProvider(ICConfigurationDescription cfgDes, boolean newStile) {
        if (newStile) {
            return new ConfigBasedPathEntryStore(this.getProject());
        }
        return new DefaultPathEntryStore(this.getProject());
    }

    @Override
    protected void deinitializeProvider(Object o) {
        IPathEntryStore store = (IPathEntryStore)o;
        store.removePathEntryStoreListener(this);
        store.close();
    }

    @Override
    protected void initializeProvider(Object o) {
        IPathEntryStore store;
        this.fStore = store = (IPathEntryStore)o;
        store.addPathEntryStoreListener(this);
    }

    @Override
    protected boolean isValidProvider(Object o) {
        return o instanceof IPathEntryStore;
    }

    @Override
    protected void postProcessProviderChange(Object newProvider, Object oldProvider) {
        this.fireContentChangedEvent(this.getProject());
    }

    @Override
    protected boolean doHandleEvent(CProjectDescriptionEvent event) {
        IPathEntryStore oldStore = this.fStore;
        boolean result = super.doHandleEvent(event);
        if (!result) {
            this.postProcessProviderChange(this.fStore, oldStore);
        }
        return result;
    }
}

