/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPEnumerationSpecialization
extends CPPSpecialization
implements ICPPEnumerationSpecialization {
    private IEnumerator[] fEnumerators;
    private final IType fFixedType;

    public CPPEnumerationSpecialization(ICPPEnumeration specialized, IBinding owner, ICPPTemplateParameterMap argumentMap, IType fixedType) {
        super(specialized, owner, argumentMap);
        this.fFixedType = fixedType;
    }

    public void setEnumerators(IEnumerator[] enumerators) {
        this.fEnumerators = enumerators;
    }

    @Override
    public ICPPEnumeration getSpecializedBinding() {
        return (ICPPEnumeration)super.getSpecializedBinding();
    }

    @Override
    public IEnumerator[] getEnumerators() {
        return this.fEnumerators;
    }

    @Override
    public long getMinValue() {
        return SemanticUtil.computeMinValue(this);
    }

    @Override
    public long getMaxValue() {
        return SemanticUtil.computeMaxValue(this);
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPEnumerationSpecialization)) {
            return false;
        }
        ICPPEnumerationSpecialization otherEnumSpec = (ICPPEnumerationSpecialization)type;
        return this.getSpecializedBinding().isSameType(otherEnumSpec.getSpecializedBinding()) && ((IType)((Object)this.getOwner())).isSameType((IType)((Object)otherEnumSpec.getOwner()));
    }

    @Override
    public boolean isScoped() {
        return this.getSpecializedBinding().isScoped();
    }

    @Override
    public IType getFixedType() {
        return this.fFixedType;
    }

    @Override
    public ICPPScope asScope() {
        return this.getSpecializedBinding().asScope();
    }

    @Override
    public Object clone() {
        throw new IllegalArgumentException("Enums must not be cloned");
    }

    @Override
    public IEnumerator specializeEnumerator(IEnumerator enumerator) {
        if (enumerator instanceof ICPPSpecialization && ((ICPPSpecialization)((Object)enumerator)).getOwner() == this) {
            return enumerator;
        }
        IEnumerator[] unspecializedEnumerators = this.getSpecializedBinding().getEnumerators();
        int i = 0;
        while (i < this.fEnumerators.length) {
            if (enumerator.equals(unspecializedEnumerators[i])) {
                return this.fEnumerators[i];
            }
            ++i;
        }
        return null;
    }
}

