/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;

public class StructureContextUtil {
    public static void setStructureContext(ElementPropertyDefn propDefn, Object tmpValue, DesignElement element) {
        assert (propDefn != null);
        assert (element != null);
        if (tmpValue == null) {
            return;
        }
        if (propDefn.getTypeCode() != 16) {
            return;
        }
        if (propDefn.isList()) {
            List values = (List)tmpValue;
            int i = 0;
            while (i < values.size()) {
                Structure item = (Structure)values.get(i);
                item.setContext(new StructureContext(element, propDefn, item));
                ++i;
            }
        } else if (tmpValue instanceof Structure) {
            ((Structure)tmpValue).setContext(new StructureContext(element, propDefn, (Structure)tmpValue));
        }
    }

    public static void setupStructureContext(Structure struct) {
        if (struct == null) {
            return;
        }
        Iterator<IPropertyDefn> members = struct.getDefn().propertiesIterator();
        while (members.hasNext()) {
            Object tmpValue;
            PropertyDefn member = (PropertyDefn)members.next();
            if (member.getTypeCode() != 16 || (tmpValue = struct.getLocalProperty(null, member)) == null) continue;
            if (tmpValue instanceof List) {
                List tmpList = (List)tmpValue;
                int i = 0;
                while (i < tmpList.size()) {
                    Structure child = (Structure)tmpList.get(i);
                    child.setContext(new StructureContext(struct, member, child));
                    StructureContextUtil.setupStructureContext(child);
                    ++i;
                }
                continue;
            }
            Structure child = (Structure)tmpValue;
            child.setContext(new StructureContext(struct, member, child));
            StructureContextUtil.setupStructureContext(child);
        }
    }

    public static StructureContext createStructureContext(StructureHandle structHandle, String memberName) {
        if (structHandle == null) {
            return null;
        }
        Structure struct = (Structure)structHandle.getStructure();
        if (struct == null) {
            return null;
        }
        PropertyDefn propDefn = (PropertyDefn)struct.getMemberDefn(memberName);
        if (propDefn == null) {
            return null;
        }
        StructureContext context = new StructureContext(struct, propDefn, null);
        return context;
    }

    public static StructureContext getLocalStructureContext(Module targetModule, DesignElement target, StructureContext context) {
        if (target == null || context == null) {
            return null;
        }
        if (target == context.getElement()) {
            return context;
        }
        ElementPropertyDefn propDefn = context.getElementProp();
        if (target.getLocalProperty(targetModule, propDefn = target.getPropertyDefn(propDefn.getName())) == null) {
            return context;
        }
        ArrayList<StructureContext> contextList = new ArrayList<StructureContext>();
        StructureContext tmpContext = context;
        while (tmpContext != null) {
            contextList.add(0, tmpContext);
            tmpContext = tmpContext.getParentContext();
        }
        assert (contextList.size() > 0);
        Structure targetStruct = null;
        int i = 0;
        while (i < contextList.size()) {
            tmpContext = (StructureContext)contextList.get(i);
            StructureContext targetContext = null;
            if (i == 0) {
                targetContext = new StructureContext(target, propDefn, null);
            } else {
                assert (targetStruct != null);
                targetContext = new StructureContext(targetStruct, tmpContext.getPropDefn(), null);
            }
            targetStruct = StructureContextUtil.getTargetStructure(targetModule, targetContext, tmpContext);
            if (targetStruct != null) {
                targetContext = targetContext.cacheStructure(targetStruct);
            }
            if (tmpContext == context) {
                return targetContext;
            }
            ++i;
        }
        assert (false);
        return null;
    }

    private static Structure getTargetStructure(Module module, StructureContext targetContext, StructureContext sourceContext) {
        assert (targetContext != null);
        assert (sourceContext != null);
        assert (targetContext.getPropDefn() == sourceContext.getPropDefn());
        if (sourceContext.getStructure() == null) {
            return null;
        }
        int index = sourceContext.getIndex(null);
        return targetContext.getStructureAt(module, index);
    }

    public static StructureContext getMemberContext(StructureHandle structHandle, StructPropertyDefn member) {
        if (structHandle == null || member == null) {
            return null;
        }
        StructureContext context = structHandle.getContext();
        DesignElement target = structHandle.getElement();
        ElementPropertyDefn propDefn = context.getElementProp();
        Module module = structHandle.getModule();
        Object localValue = target.getLocalProperty(module, propDefn);
        if (localValue == null) {
            Structure struct = (Structure)structHandle.getStructure();
            assert (struct != null);
            return new StructureContext(struct, member, null);
        }
        StructureContext targetContext = StructureContextUtil.getLocalStructureContext(module, target, context);
        assert (targetContext != null);
        Structure struct = targetContext.getStructure();
        assert (struct != null);
        return new StructureContext(struct, member, null);
    }

    public static boolean isValidStructureHandle(StructureHandle structHandle) {
        if (structHandle == null) {
            return true;
        }
        Structure struct = (Structure)structHandle.getStructure();
        if (struct == null) {
            return false;
        }
        StructureContext context = struct.getContext();
        if (context == null) {
            return false;
        }
        DesignElement hostElement = context.getElement();
        DesignElement content = struct.getElement();
        if (content == hostElement) {
            return true;
        }
        if (hostElement == null) {
            return false;
        }
        Object localValue = content.getLocalProperty(structHandle.getModule(), context.getElementProp());
        return localValue == null;
    }
}

