/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.core.DataException;

abstract class PercentileAccumulator
extends SummaryAccumulator {
    private double pct;
    private List cachedValues;

    PercentileAccumulator() {
    }

    @Override
    public void start() {
        super.start();
        this.pct = -1.0;
        this.cachedValues = new ArrayList();
    }

    public void onRow(Object[] args) throws DataException {
        assert (args.length == 2);
        if (args[0] != null) {
            Number d;
            if (this.calculator == null) {
                this.calculator = CalculatorFactory.getCalculator(args[0].getClass());
            }
            if ((d = this.calculator.add(0, args[0])) != null) {
                this.cachedValues.add(d);
            }
        }
        if (this.pct == -1.0) {
            Double pctValue = RankAggregationUtil.getNumericValue(args[1]);
            this.pct = this.getPctValue(pctValue);
        }
    }

    protected abstract double getPctValue(Double var1) throws DataException;

    @Override
    public Object getSummaryValue() throws DataException {
        Object[] sortedObjs = this.cachedValues.toArray();
        if (sortedObjs.length == 0) {
            return null;
        }
        RankAggregationUtil.sortArray(sortedObjs);
        double n = this.pct * (double)(sortedObjs.length - 1) + 1.0;
        int k = (int)Math.floor(n);
        double fraction = n - (double)k;
        Number adjustment = 0;
        if (fraction != 0.0) {
            adjustment = this.calculator.multiply(fraction, this.calculator.subtract(sortedObjs[k], sortedObjs[k - 1]));
        }
        return this.calculator.add(sortedObjs[k - 1], adjustment);
    }
}

