/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.BaseCompareAction;
import org.eclipse.compare.internal.ResourceCompareInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CompareAction
extends BaseCompareAction
implements IObjectActionDelegate {
    protected ResourceCompareInput fInput;
    protected IWorkbenchPage fWorkbenchPage;
    protected boolean showSelectAncestorDialog = true;

    public void run(ISelection selection) {
        if (this.fInput != null) {
            boolean ok = this.fInput.setSelection(selection, this.fWorkbenchPage.getWorkbenchWindow().getShell(), this.showSelectAncestorDialog);
            if (!ok) {
                return;
            }
            this.fInput.initializeCompareConfiguration();
            CompareUI.openCompareEditorOnPage(this.fInput, this.fWorkbenchPage);
            this.fInput = null;
        }
    }

    protected boolean isEnabled(ISelection selection) {
        if (this.fInput == null) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", new Boolean(false));
            this.fInput = new ResourceCompareInput(cc);
        }
        return this.fInput.isEnabled(selection);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPage = targetPart.getSite().getPage();
    }
}

