/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ui.analysis.AnalysisViewModeDelegate;
import com.nvidia.viper.ui.analysis.GuidedModeDelegate;
import com.nvidia.viper.ui.analysis.RebelReportModeDelegate;
import com.nvidia.viper.ui.analysis.UnguidedModeDelegate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public enum AnalysisViewMode {
    guided,
    unguided,
    rebelreport;


    public Image getIcon() {
        switch (this) {
            case guided: {
                return ViperImages.get("icons/en/mode_guided.png");
            }
            case unguided: {
                return ViperImages.get("icons/en/mode_stages.png");
            }
            case rebelreport: {
                return ViperImages.get("icons/en/mode_stages.png");
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public String getTitle() {
        switch (this) {
            case guided: {
                return ViperMessages.Analysis_Guided_Title;
            }
            case unguided: {
                return ViperMessages.Analysis_Unguided_Title;
            }
            case rebelreport: {
                return "Rebel Report";
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public AnalysisViewModeDelegate create(Composite buttonsParent, Composite outlineParent, Composite detailsParent) {
        switch (this) {
            case guided: {
                return new GuidedModeDelegate(buttonsParent, outlineParent, detailsParent);
            }
            case unguided: {
                return new UnguidedModeDelegate(buttonsParent, outlineParent, detailsParent);
            }
            case rebelreport: {
                return new RebelReportModeDelegate(detailsParent);
            }
        }
        throw new IllegalArgumentException(this.name());
    }
}

