/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.UIUtils;
import com.nvidia.viper.ui.UVMSegmentComposite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExecutableOptionsPropertyControl
extends Composite {
    private Button profileOnStartButton;
    private Text timeOutText;
    private Button concurrentKernelButton;
    private Button environmentProfilingButton;
    private Button uvmProfilingButton;
    private Button apiTraceButton;
    private Button appReplayButton;
    private Button cpuProfilingButton;
    private Button openaccProfilingButton;
    private Button threadTrackingButton;
    private Executable executable;
    private UVMSegmentComposite uvmSegment;
    private Button uvmAllocationsTrackingButton;
    private IRunnableContext runnableContext;
    private Text pgFileText;
    private Button pgFileBrowseButton;

    public ExecutableOptionsPropertyControl(Composite parent, int style, IRunnableContext context) {
        super(parent, style);
        this.runnableContext = context;
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.setLayout((Layout)mainLayout);
        this.addTimeoutControl();
        this.addProfileOnStartButton();
        this.addConcurrentKernelButton();
        this.addApiTraceButton();
        this.addEnvironmentProfileButton();
        this.addUvmButton();
        this.addApplicationReplayButton();
        this.addCpuProfilingButton();
        this.addOpenAccProfilingButton();
        this.addThreadTrackingButton();
    }

    public void disableOptionsThatOnlyWorkWithSingleProcessProfiling() {
        if (this.appReplayButton != null) {
            this.appReplayButton.setEnabled(false);
        }
        if (this.cpuProfilingButton != null) {
            this.cpuProfilingButton.setEnabled(false);
        }
    }

    private void addApplicationReplayButton() {
        this.appReplayButton = new Button((Composite)this, 32);
        this.appReplayButton.setText(ViperMessages.NewSession_Wizard_AppReplay_Label);
        this.appReplayButton.setToolTipText(ViperMessages.NewSession_Wizard_AppReplay_Tooltip);
        this.appReplayButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.appReplayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setApplicationReplay(ExecutableOptionsPropertyControl.this.appReplayButton.getSelection());
            }
        });
        this.appReplayButton.setSelection(false);
    }

    private void addUvmButton() {
        this.uvmProfilingButton = new Button((Composite)this, 32);
        this.uvmProfilingButton.setText(ViperMessages.NewSession_Wizard_UvmProfiling_Label);
        this.uvmProfilingButton.setToolTipText(ViperMessages.NewSession_Wizard_UvmProfiling_Tooltip);
        this.uvmProfilingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.uvmSegment = new UVMSegmentComposite(this, 0);
        GridData ldata = new GridData(1, 0x1000000, false, false, 3, 1);
        ldata.horizontalIndent = 15;
        this.uvmSegment.setLayoutData(ldata);
        this.uvmAllocationsTrackingButton = new Button((Composite)this, 32);
        this.uvmAllocationsTrackingButton.setText("Track memory allocations");
        this.uvmAllocationsTrackingButton.setToolTipText("Track device memory allocations");
        GridData trackingData = new GridData(1, 0x1000000, false, false, 3, 1);
        trackingData.horizontalIndent = 15;
        this.uvmAllocationsTrackingButton.setLayoutData((Object)trackingData);
        this.uvmProfilingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setUvmProfiling(ExecutableOptionsPropertyControl.this.uvmProfilingButton.getSelection());
                ExecutableOptionsPropertyControl.this.uvmSegment.enable(ExecutableOptionsPropertyControl.this.uvmProfilingButton.getSelection());
                ExecutableOptionsPropertyControl.this.uvmAllocationsTrackingButton.setEnabled(ExecutableOptionsPropertyControl.this.uvmProfilingButton.getSelection());
                if (!ExecutableOptionsPropertyControl.this.uvmProfilingButton.getSelection()) {
                    ExecutableOptionsPropertyControl.this.uvmAllocationsTrackingButton.setSelection(false);
                    ExecutableOptionsPropertyControl.this.executable.setAllocationsTracking(false);
                }
            }
        });
        this.uvmAllocationsTrackingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setAllocationsTracking(ExecutableOptionsPropertyControl.this.uvmAllocationsTrackingButton.getSelection());
            }
        });
        this.uvmProfilingButton.setSelection(true);
        this.uvmAllocationsTrackingButton.setSelection(false);
    }

    private void addEnvironmentProfileButton() {
        this.environmentProfilingButton = new Button((Composite)this, 32);
        this.environmentProfilingButton.setToolTipText(ViperMessages.NewSession_Wizard_EnvironmentProfiling_Tooltip);
        this.environmentProfilingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.environmentProfilingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setEnvironmentProfiling(ExecutableOptionsPropertyControl.this.environmentProfilingButton.getSelection());
            }
        });
        this.environmentProfilingButton.setSelection(false);
    }

    private void addApiTraceButton() {
        this.apiTraceButton = new Button((Composite)this, 32);
        this.apiTraceButton.setText(ViperMessages.NewSession_Wizard_APITrace_Label);
        this.apiTraceButton.setToolTipText(ViperMessages.NewSession_Wizard_APITrace_Tooltip);
        this.apiTraceButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.apiTraceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutableOptionsPropertyControl.this.executable.setApiTrace(ExecutableOptionsPropertyControl.this.apiTraceButton.getSelection());
            }
        });
        this.apiTraceButton.setSelection(true);
    }

    private void addConcurrentKernelButton() {
        this.concurrentKernelButton = new Button((Composite)this, 32);
        this.concurrentKernelButton.setText(ViperMessages.NewSession_Wizard_ConcurrentKernels_Label);
        this.concurrentKernelButton.setToolTipText(ViperMessages.NewSession_Wizard_ConcurrentKernels_Tooltip);
        this.concurrentKernelButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.concurrentKernelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutableOptionsPropertyControl.this.executable.setConcurrentKernel(ExecutableOptionsPropertyControl.this.concurrentKernelButton.getSelection());
            }
        });
        this.concurrentKernelButton.setSelection(true);
    }

    private void addProfileOnStartButton() {
        this.profileOnStartButton = new Button((Composite)this, 32);
        this.profileOnStartButton.setText(ViperMessages.NewSession_Wizard_ProfilingEnabledOnStart_Label);
        this.profileOnStartButton.setToolTipText(ViperMessages.NewSession_Wizard_ProfilingEnabledOnStart_Tooltip);
        this.profileOnStartButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.profileOnStartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutableOptionsPropertyControl.this.executable.setProfileOnStart(ExecutableOptionsPropertyControl.this.profileOnStartButton.getSelection());
            }
        });
        this.profileOnStartButton.setSelection(true);
    }

    private void updateCpuProfilingSelection() {
        boolean selected = this.cpuProfilingButton.getSelection();
        this.executable.setCpuProfiling(selected);
        this.pgFileText.setEnabled(this.cpuProfilingButton.getSelection());
        this.pgFileBrowseButton.setEnabled(this.cpuProfilingButton.getSelection());
        this.updateThreadTrackingLabel();
    }

    private void addCpuProfilingButton() {
        this.cpuProfilingButton = new Button((Composite)this, 32);
        this.cpuProfilingButton.setText(ViperMessages.NewSession_Wizard_cpuProfiling_Label);
        this.cpuProfilingButton.setToolTipText(ViperMessages.NewSession_Wizard_cpuProfiling_Tooltip);
        this.cpuProfilingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.cpuProfilingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutableOptionsPropertyControl.this.updateCpuProfilingSelection();
            }
        });
        this.cpuProfilingButton.setSelection(Viper.isPgiProduct());
        CLabel pathLabel = new CLabel((Composite)this, 1);
        pathLabel.setText(ViperMessages.NewSession_PG_Explain_File_label);
        this.pgFileText = new Text((Composite)this, 2052);
        this.pgFileText.setMessage(ViperMessages.NewSession_PG_Explain_File_Message);
        this.pgFileBrowseButton = new Button((Composite)this, 8);
        this.pgFileBrowseButton.setText("Browse...");
        this.pgFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExecutableOptionsPropertyControl.this.executable.getFileSystem() != null) {
                    UIUtils.browseForFile(ExecutableOptionsPropertyControl.this.pgFileText, ExecutableOptionsPropertyControl.this.pgFileText.getText(), ExecutableOptionsPropertyControl.this.pgFileBrowseButton, ExecutableOptionsPropertyControl.this.executable.getFileSystem(), ExecutableOptionsPropertyControl.this.runnableContext);
                }
            }
        });
        this.pgFileText.setEnabled(Viper.isPgiProduct());
        this.pgFileBrowseButton.setEnabled(Viper.isPgiProduct());
        GridData pldata = new GridData(1, 0x1000000, false, false, 2, 1);
        pldata.horizontalIndent = 15;
        pathLabel.setLayoutData((Object)pldata);
        GridData ftdata = new GridData(1, 0x1000000, true, false, 2, 1);
        ftdata.horizontalIndent = 15;
        this.pgFileText.setLayoutData((Object)ftdata);
        GridData bbdata = new GridData(1, 0x1000000, false, false, 2, 1);
        bbdata.horizontalIndent = 15;
        this.pgFileBrowseButton.setLayoutData((Object)bbdata);
    }

    private void addOpenAccProfilingButton() {
        this.openaccProfilingButton = new Button((Composite)this, 32);
        this.openaccProfilingButton.setText(ViperMessages.NewSession_Wizard_OpenAccProfiling_Label);
        this.openaccProfilingButton.setToolTipText(ViperMessages.NewSession_Wizard_OpenAccProfiling_Tooltip);
        this.openaccProfilingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.openaccProfilingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setOpenAccProfiling(ExecutableOptionsPropertyControl.this.openaccProfilingButton.getSelection());
            }
        });
        this.openaccProfilingButton.setSelection(true);
    }

    private void addThreadTrackingButton() {
        this.threadTrackingButton = new Button((Composite)this, 32);
        this.threadTrackingButton.setText(ViperMessages.NewSession_Wizard_ThreadTracking_Label);
        this.threadTrackingButton.setToolTipText(ViperMessages.NewSession_Wizard_ThreadTracking_Tooltip);
        this.threadTrackingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.threadTrackingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean selected = ExecutableOptionsPropertyControl.this.threadTrackingButton.getSelection();
                ExecutableOptionsPropertyControl.this.executable.setThreadTracking(selected);
                ExecutableOptionsPropertyControl.this.cpuProfilingButton.setEnabled(!selected && !ExecutableOptionsPropertyControl.this.executable.isMultiProcess());
            }
        });
        this.threadTrackingButton.setSelection(false);
    }

    private void addTimeoutControl() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(ViperMessages.NewSession_Wizard_TimeOut_Label);
        this.timeOutText = new Text((Composite)this, 2052);
        this.timeOutText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timeOutText.setMessage(ViperMessages.Execution_TimeOut_Message);
        this.timeOutText.addVerifyListener((VerifyListener)new NumberVerifyListener());
        this.timeOutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String timeOut = ExecutableOptionsPropertyControl.this.timeOutText.getText();
                if (timeOut.isEmpty()) {
                    ExecutableOptionsPropertyControl.this.executable.setTimeOut(-1);
                } else {
                    ExecutableOptionsPropertyControl.this.executable.setTimeOut(Integer.parseInt(timeOut));
                }
            }
        });
        Label labelUnit = new Label((Composite)this, 0);
        labelUnit.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelUnit.setText(ViperMessages.NewSession_Wizard_TimeOut_Unit_Label);
    }

    private void disableForMacOS(Executable exe, Button button, String label) {
        button.setEnabled(true);
        try {
            FileSystem filesystem = FileSystem.getFilesystem(exe.getConnectionName());
            if (filesystem.isLocal() && "macosx".equals(Platform.getOS())) {
                button.setEnabled(false);
                button.setSelection(false);
                label = String.valueOf(label) + ViperMessages.NewSession_notSuppOSX;
            }
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {}
        button.setText(label);
    }

    private boolean isCompatibleForOSArch(Executable exe, String[] os, String[] arch) {
        String s;
        try {
            FileSystem filesystem = FileSystem.getFilesystem(exe.getConnectionName());
            if (!filesystem.isLocal()) {
                return true;
            }
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {}
        boolean supportOS = false;
        boolean supportArch = false;
        String[] stringArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(Platform.getOS())) {
                supportOS = true;
                break;
            }
            ++n2;
        }
        stringArray = arch;
        n = arch.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(Platform.getOSArch())) {
                supportArch = true;
                break;
            }
            ++n2;
        }
        return supportOS && supportArch;
    }

    private void updateUvmProfilingLabel(Executable exe) {
        if (!this.uvmProfilingButton.getEnabled()) {
            exe.setUvmProfiling(false);
        }
    }

    private void updateEnvProfilingLabel(Executable exe) {
        this.disableForMacOS(exe, this.environmentProfilingButton, ViperMessages.NewSession_Wizard_EnvironmentProfiling_Label);
    }

    private void updateCpuProfilingLabel(Executable exe) {
        boolean state = exe.isProfileCPU();
        this.cpuProfilingButton.setSelection(state);
        this.updateCpuProfilingSelection();
    }

    private void updateOpenAccProfilingLabel(Executable exe) {
        String[] os = new String[]{"linux"};
        String[] arch = new String[]{"x86_64", "ppc"};
        boolean enable = this.isCompatibleForOSArch(exe, os, arch);
        this.openaccProfilingButton.setEnabled(enable);
        if (enable) {
            this.openaccProfilingButton.setText(ViperMessages.NewSession_Wizard_OpenAccProfiling_Label);
        } else {
            this.openaccProfilingButton.setSelection(false);
            this.openaccProfilingButton.setText(String.valueOf(ViperMessages.NewSession_Wizard_OpenAccProfiling_Label) + ViperMessages.NewSession_supportLinux64Only);
        }
    }

    private void updateThreadTrackingLabel() {
        String[] os = new String[]{"linux", "macosx"};
        String[] arch = new String[]{"x86_64"};
        boolean enable = this.isCompatibleForOSArch(this.executable, os, arch);
        if (enable) {
            if (!this.cpuProfilingButton.getSelection()) {
                this.threadTrackingButton.setEnabled(true);
            } else {
                this.threadTrackingButton.setEnabled(false);
                this.threadTrackingButton.setSelection(false);
            }
            this.threadTrackingButton.setText(ViperMessages.NewSession_Wizard_ThreadTracking_Label);
        } else {
            this.threadTrackingButton.setEnabled(false);
            this.threadTrackingButton.setSelection(false);
            this.threadTrackingButton.setText(String.valueOf(ViperMessages.NewSession_Wizard_ThreadTracking_Label) + ViperMessages.NewSession_supportPosix64Only);
        }
    }

    public void setInput(Session session) {
        this.executable = session == null ? null : session.getExecutable();
        this.uvmSegment.setInput(session);
        if (this.executable != null) {
            this.updateEnvProfilingLabel(this.executable);
            this.updateUvmProfilingLabel(this.executable);
            this.updateOptionsThatOnlyWorkWithSingleProcessProfiling(this.executable);
            this.updateCpuProfilingLabel(this.executable);
            this.updateOpenAccProfilingLabel(this.executable);
            this.updateThreadTrackingLabel();
        }
    }

    private void updateOptionsThatOnlyWorkWithSingleProcessProfiling(Executable executable) {
        boolean isMP = executable.isMultiProcess();
        boolean enable = !isMP && (this.threadTrackingButton == null || !this.threadTrackingButton.getSelection());
        this.cpuProfilingButton.setEnabled(enable);
        if (!enable) {
            this.cpuProfilingButton.setSelection(false);
            this.updateCpuProfilingSelection();
        } else {
            this.cpuProfilingButton.setSelection(Viper.isPgiProduct());
            this.updateCpuProfilingSelection();
        }
        String suppMsg = isMP ? ViperMessages.NewSession_notSuppMultiProc : "";
        String label = String.valueOf(ViperMessages.NewSession_Wizard_cpuProfiling_Label) + suppMsg;
        this.cpuProfilingButton.setText(label);
        this.appReplayButton.setEnabled(!isMP);
        String suppMsg2 = isMP ? ViperMessages.NewSession_notSuppMultiProc : "";
        String label2 = String.valueOf(ViperMessages.NewSession_Wizard_AppReplay_Label) + suppMsg2;
        this.appReplayButton.setText(label2);
    }

    public Text getTimeOutText() {
        return this.timeOutText;
    }

    public void refresh() {
        if (this.executable == null) {
            this.timeOutText.setText(null);
            this.profileOnStartButton.setSelection(false);
            this.concurrentKernelButton.setSelection(false);
            this.apiTraceButton.setSelection(false);
            this.environmentProfilingButton.setSelection(false);
            this.uvmProfilingButton.setSelection(false);
            this.uvmAllocationsTrackingButton.setSelection(false);
            this.appReplayButton.setSelection(false);
            this.openaccProfilingButton.setSelection(false);
            this.threadTrackingButton.setSelection(false);
        } else {
            this.profileOnStartButton.setSelection(this.executable.isProfileOnStart());
            this.concurrentKernelButton.setSelection(this.executable.isConcurrentKernel());
            this.apiTraceButton.setSelection(this.executable.isApiTrace());
            this.environmentProfilingButton.setSelection(this.executable.isEnvironmentProfiling());
            this.uvmProfilingButton.setSelection(this.executable.isUvmProfiling());
            this.uvmAllocationsTrackingButton.setSelection(this.executable.isAllocationsTracking());
            this.uvmSegment.updateSelection();
            this.appReplayButton.setSelection(this.executable.isApplicationReplay());
            if (this.executable.getTimeOut() < 1) {
                this.timeOutText.setText("");
            } else {
                this.timeOutText.setText(Integer.toString(this.executable.getTimeOut()));
            }
            this.openaccProfilingButton.setSelection(this.executable.isOpenAccProfiling());
            this.threadTrackingButton.setSelection(this.executable.isThreadTracking());
            if (this.executable.isThreadTracking()) {
                this.cpuProfilingButton.setEnabled(false);
            }
        }
    }

    public void updateOptions() {
        if (this.executable != null) {
            this.updateOptionsThatOnlyWorkWithSingleProcessProfiling(this.executable);
            this.updateCpuProfilingLabel(this.executable);
        }
    }

    static class NumberVerifyListener
    implements VerifyListener {
        NumberVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            e.doit = e.text.isEmpty() ? true : e.text.matches("[0-9]+");
        }
    }
}

