/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.FlopsFormatter;
import com.nvidia.viper.FrequencyFormatter;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.ViperComputeDictionary;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiDeviceAttribute;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.birt.ViperBirtReportException;
import com.nvidia.viper.birt.ViperReportCancelledException;
import com.nvidia.viper.birt.report.IViperReportCellData;
import com.nvidia.viper.birt.report.IViperReportStageData;
import com.nvidia.viper.birt.report.ReportGeneration;
import com.nvidia.viper.birt.report.ReportTableData;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.jni.CuCacheConfig;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.ui.PreciseTimeFormatter;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import com.nvidia.viper.ui.analysis.IAnalysisResultSVG;
import com.nvidia.viper.value.ValueByteSize;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class ReportGenerationAction {
    private static final int REPORT_WIDTH_PIXELS = 800;
    private final IPath reportGenTmpDir;
    private final String pdfOutputFile;
    private static final String _diagName = "diag";
    private static int _diagPostFix = 0;
    private static final String _diagExtension = ".svg";
    private final IProgressMonitor progressMonitor;
    private final Session session;
    private final GC gc;
    private final String kernelName;
    private final ReportTableData timeLineKernelProp;
    private final ReportTableData timeLineDeviceProp;

    public ReportGenerationAction(Session session, GC gc, String pdfFileName, IProgressMonitor monitor) throws ViperException {
        this.session = session;
        this.gc = gc;
        this.reportGenTmpDir = TemporaryDirs.reports.newSubfolder();
        this.pdfOutputFile = pdfFileName;
        this.progressMonitor = monitor;
        TimelineIntervalPair primarySelected = session.getPrimarySelected();
        ITimelineInterval interval = primarySelected.getInterval(session);
        if (interval instanceof TimelineIntervalKernel) {
            this.kernelName = interval.getDisplayName();
            this.timeLineKernelProp = this.createTimeLineKernelPropTbl(primarySelected);
            this.timeLineDeviceProp = this.createDevicePropTbl(primarySelected);
        } else {
            this.kernelName = "";
            this.timeLineKernelProp = null;
            this.timeLineDeviceProp = null;
        }
    }

    private ReportTableData createDevicePropTbl(TimelineIntervalPair primarySelected) {
        Number pciWidth;
        Number pciRate;
        Number pciGen;
        Number flopDp;
        Number flopSp;
        Integer[] block;
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        Timeline kernelTimeLine = primarySelected.getTimeline();
        TimelineDevice timeline = (TimelineDevice)kernelTimeLine.getAncestor(TimelineKind.DEVICE);
        String caption = timeline.getDisplayName(false);
        ArrayList<String[]> rowsLst = new ArrayList<String[]>();
        StringBuilder uuidLabel = timeline.getUuidSHA_1Format();
        if (uuidLabel != null) {
            String[] stringArray = new String[3];
            stringArray[0] = "GPU UUID";
            stringArray[1] = uuidLabel.toString();
            rowsLst.add(stringArray);
        }
        if (timeline.getComputeCapabilityMajor() > 0) {
            String[] stringArray = new String[3];
            stringArray[0] = "Compute Capability";
            stringArray[1] = String.valueOf(timeline.getComputeCapabilityMajor()) + "." + timeline.getComputeCapabilityMinor();
            rowsLst.add(stringArray);
        }
        if (timeline.getMaxThreadsPerBlock() > 0) {
            String[] stringArray = new String[3];
            stringArray[0] = "Max. " + ViperComputeDictionary.THREAD.getLabel(computeKind) + "s per " + ViperComputeDictionary.BLOCK.getLabel(computeKind);
            stringArray[1] = String.valueOf(timeline.getMaxThreadsPerBlock());
            rowsLst.add(stringArray);
        }
        String[] stringArray = new String[3];
        stringArray[0] = "Max. " + ViperComputeDictionary.THREAD.getLabel(computeKind) + "s per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind);
        stringArray[1] = String.valueOf(OccupancyCalculator.getMaxThreadsPerMultiprocessor(timeline));
        rowsLst.add(stringArray);
        if (timeline.getMaxSharedMemoryPerBlock() > 0) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Max. " + ViperComputeDictionary.SHARED.getLabel(computeKind) + " Memory per " + ViperComputeDictionary.BLOCK.getLabel(computeKind);
            stringArray2[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getMaxSharedMemoryPerBlock());
            rowsLst.add(stringArray2);
        }
        String[] stringArray3 = new String[3];
        stringArray3[0] = "Max. " + ViperComputeDictionary.SHARED.getLabel(computeKind) + " Memory per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind);
        stringArray3[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(OccupancyCalculator.getMaxSharedMemoryPerMultiprocessor(timeline));
        rowsLst.add(stringArray3);
        if (timeline.getMaxRegistersPerBlock() > 0) {
            String[] stringArray4 = new String[3];
            stringArray4[0] = "Max. Registers per " + ViperComputeDictionary.BLOCK.getLabel(computeKind);
            stringArray4[1] = String.valueOf(timeline.getMaxRegistersPerBlock());
            rowsLst.add(stringArray4);
        }
        String[] stringArray5 = new String[3];
        stringArray5[0] = "Max. Registers per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind);
        stringArray5[1] = String.valueOf(OccupancyCalculator.getMaxRegistersPerMultiprocessor(timeline));
        rowsLst.add(stringArray5);
        Integer[] grid = timeline.getMaxGridDims();
        if (grid != null && grid.length == 3 && grid[0] > 0 && grid[1] > 0 && grid[2] > 0) {
            String[] stringArray6 = new String[3];
            stringArray6[0] = "Max. " + ViperComputeDictionary.GRID.getLabel(computeKind) + " Dimensions";
            stringArray6[1] = "[ " + grid[0] + ", " + grid[1] + ", " + grid[2] + " ]";
            rowsLst.add(stringArray6);
        }
        if ((block = timeline.getMaxBlockDims()) != null && block.length == 3 && block[0] > 0 && block[1] > 0 && block[2] > 0) {
            String[] stringArray7 = new String[3];
            stringArray7[0] = "Max. " + ViperComputeDictionary.BLOCK.getLabel(computeKind) + " Dimensions";
            stringArray7[1] = "[ " + block[0] + ", " + block[1] + ", " + block[2] + " ]";
            rowsLst.add(stringArray7);
        }
        if (timeline.getMaxWarpsPerMultiprocessor() > 0) {
            String[] stringArray8 = new String[3];
            stringArray8[0] = "Max. Warps per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind);
            stringArray8[1] = String.valueOf(timeline.getMaxWarpsPerMultiprocessor());
            rowsLst.add(stringArray8);
        }
        if (timeline.getMaxBlocksPerMultiprocessor() > 0) {
            String[] stringArray9 = new String[3];
            stringArray9[0] = "Max. Blocks per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind);
            stringArray9[1] = String.valueOf(timeline.getMaxBlocksPerMultiprocessor());
            rowsLst.add(stringArray9);
        }
        long tepidClockRate = timeline.getComputeCapabilityMajor() == 2 ? timeline.getCoreClockRate() / 2L : timeline.getCoreClockRate();
        Number flopHp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_HP);
        if (flopHp != null && flopHp instanceof Long) {
            long flopsHp = flopHp.longValue() * tepidClockRate;
            String[] stringArray10 = new String[3];
            stringArray10[0] = "Half Precision FLOP/s";
            stringArray10[1] = new FlopsFormatter().format(flopsHp);
            rowsLst.add(stringArray10);
        }
        if ((flopSp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_SP)) != null && flopSp instanceof Long) {
            long flopsSp = flopSp.longValue() * tepidClockRate;
            String[] stringArray11 = new String[3];
            stringArray11[0] = "Single Precision FLOP/s";
            stringArray11[1] = new FlopsFormatter().format(flopsSp);
            rowsLst.add(stringArray11);
        }
        if ((flopDp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_DP)) != null && flopDp instanceof Long) {
            long flopsDp = flopDp.longValue() * tepidClockRate;
            String[] stringArray12 = new String[3];
            stringArray12[0] = "Double Precision FLOP/s";
            stringArray12[1] = new FlopsFormatter().format(flopsDp);
            rowsLst.add(stringArray12);
        }
        if (timeline.getNumMultiprocessors() > 0) {
            String[] stringArray13 = new String[3];
            stringArray13[0] = "Number of " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind) + "s";
            stringArray13[1] = String.valueOf(timeline.getNumMultiprocessors());
            rowsLst.add(stringArray13);
        }
        if (timeline.getCoreClockRate() > 0L) {
            String[] stringArray14 = new String[3];
            stringArray14[0] = "Multiprocessor Clock Rate";
            stringArray14[1] = new FrequencyFormatter().format(timeline.getCoreClockRate());
            rowsLst.add(stringArray14);
        }
        if (timeline.getComputeCapabilityMajor() > 0) {
            String[] stringArray15 = new String[3];
            stringArray15[0] = "Concurrent " + ViperComputeDictionary.KERNEL.getLabel(computeKind);
            stringArray15[1] = String.valueOf(timeline.supportsConcurrentKernels());
            rowsLst.add(stringArray15);
        }
        if (timeline.getMaxIPC() > 0) {
            String[] stringArray16 = new String[3];
            stringArray16[0] = "Max IPC";
            stringArray16[1] = String.valueOf(timeline.getMaxIPC());
            rowsLst.add(stringArray16);
        }
        if (timeline.getNumThreadsPerWarp() > 0) {
            String[] stringArray17 = new String[3];
            stringArray17[0] = String.valueOf(ViperComputeDictionary.THREAD.getLabel(computeKind)) + "s per Warp";
            stringArray17[1] = String.valueOf(timeline.getNumThreadsPerWarp());
            rowsLst.add(stringArray17);
        }
        if (timeline.getGlobalMemoryBandwidth() > 0L) {
            String[] stringArray18 = new String[3];
            stringArray18[0] = "Global Memory Bandwidth";
            stringArray18[1] = new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getGlobalMemoryBandwidth());
            rowsLst.add(stringArray18);
        }
        if (timeline.getGlobalMemorySize() > 0L) {
            String[] stringArray19 = new String[3];
            stringArray19[0] = "Global Memory Size";
            stringArray19[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getGlobalMemorySize());
            rowsLst.add(stringArray19);
        }
        if (timeline.getConstantMemorySize() > 0) {
            String[] stringArray20 = new String[3];
            stringArray20[0] = "Constant Memory Size";
            stringArray20[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getConstantMemorySize());
            rowsLst.add(stringArray20);
        }
        if (timeline.getL2CacheSize() > 0) {
            String[] stringArray21 = new String[3];
            stringArray21[0] = "L2 Cache Size";
            stringArray21[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getL2CacheSize());
            rowsLst.add(stringArray21);
        }
        if (timeline.getNumMemcpyEngines() > 0) {
            String[] stringArray22 = new String[3];
            stringArray22[0] = "Memcpy Engines";
            stringArray22[1] = String.valueOf(timeline.getNumMemcpyEngines());
            rowsLst.add(stringArray22);
        }
        if ((pciGen = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_GEN)) instanceof Long) {
            String[] stringArray23 = new String[3];
            stringArray23[0] = "PCIe Generation";
            stringArray23[1] = String.valueOf(pciGen.longValue());
            rowsLst.add(stringArray23);
        }
        if ((pciRate = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_RATE)) instanceof Long) {
            String[] stringArray24 = new String[3];
            stringArray24[0] = "PCIe Link Rate";
            stringArray24[1] = new BandwidthFormatter(ByteSizeFormatter.Base.KILOBIT).format(pciRate.longValue() * 1000L * 1000L);
            rowsLst.add(stringArray24);
        }
        if ((pciWidth = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH)) instanceof Long) {
            String[] stringArray25 = new String[3];
            stringArray25[0] = "PCIe Link Width";
            stringArray25[1] = String.valueOf(pciWidth.longValue());
            rowsLst.add(stringArray25);
        }
        String[][] rowStrArr = (String[][])rowsLst.toArray((T[])new String[0][0]);
        ReportTableData reportTblData = new ReportTableData(rowStrArr, caption, new double[]{50.0, 50.0}, 0, rowStrArr.length, 0, 2);
        return reportTblData;
    }

    private ReportTableData createTimeLineKernelPropTbl(TimelineIntervalPair primarySelected) {
        Integer[] block;
        Timeline tl = primarySelected.getTimeline();
        TimelineIntervalKernel krnl = (TimelineIntervalKernel)primarySelected.getInterval(this.session);
        CuptiActivityComputeApiKind ckind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        TimelineContext ctxTimeline = (TimelineContext)tl.getAncestor(TimelineKind.CONTEXT);
        if (ctxTimeline != null) {
            ckind = ctxTimeline.getComputeKind();
        }
        TimelineDevice deviceTimeline = (TimelineDevice)tl.getAncestor(TimelineKind.DEVICE);
        String caption = null;
        ArrayList<String[]> rowsLst = new ArrayList<String[]>();
        rowsLst.add(new String[]{"Duration", new PreciseTimeFormatter(krnl.getDuration()).toString(), "The duration of the kernel execution (end time - start time)"});
        Integer[] grid = krnl.getGrid();
        if (grid != null && grid[0] != null && grid[1] != null && grid[2] != null) {
            rowsLst.add(new String[]{String.valueOf(ViperComputeDictionary.GRID.getLabel(ckind)) + " Size", "[ " + grid[0] + "," + grid[1] + "," + grid[2] + " ]", "The grid dimensions for the kernel launch"});
        }
        if ((block = krnl.getBlock()) != null && block[0] != null && block[1] != null && block[2] != null) {
            rowsLst.add(new String[]{String.valueOf(ViperComputeDictionary.BLOCK.getLabel(ckind)) + " Size", "[ " + block[0] + "," + block[1] + "," + block[2] + " ]", "The block dimensions for the kernel launch"});
        }
        if (krnl.getRegistersPerThread() != null) {
            rowsLst.add(new String[]{"Registers/" + ViperComputeDictionary.THREAD.getLabel(ckind), krnl.getRegistersPerThread().toString(), "The number of registers required for each thread executing the kernel"});
        }
        if (krnl.getStaticSharedMemory() != null && krnl.getDynamicSharedMemory() != null) {
            ValueByteSize sharedMemPerBlock = new ValueByteSize(ByteSizeFormatter.Base.KIBIBYTE, krnl.getStaticSharedMemory() + krnl.getDynamicSharedMemory());
            rowsLst.add(new String[]{String.valueOf(ViperComputeDictionary.SHARED.getLabel(ckind)) + "  Memory/" + ViperComputeDictionary.BLOCK.getLabel(ckind), sharedMemPerBlock.toString(), "The amount of shared memory required for each block executing the kernel"});
        }
        if (deviceTimeline != null) {
            Long smemRequested;
            Long smemExecuted = krnl.getSharedMemoryExecuted();
            Integer smemConfig = krnl.getSharedMemoryBankSize();
            if (deviceTimeline.getComputeCapabilityMajor() >= 7 && krnl.getIsSharedMemoryCarveoutRequested() != 0) {
                long maxSharedMemory = deviceTimeline.getMaxSharedMemory(CuCacheConfig.CU_FUNC_CACHE_PREFER_NONE);
                smemRequested = krnl.getSharedMemoryCarveoutSizeRequested(maxSharedMemory);
            } else {
                CuCacheConfig ccRequested = krnl.getCacheConfigRequested();
                smemRequested = ccRequested == null || ccRequested == CuCacheConfig.CU_FUNC_CACHE_PREFER_NONE ? null : deviceTimeline.getMaxSharedMemory(ccRequested);
            }
            if (smemExecuted != null) {
                String[] stringArray = new String[3];
                stringArray[0] = String.valueOf(ViperComputeDictionary.SHARED.getLabel(ckind)) + " Memory Executed";
                stringArray[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemExecuted);
                rowsLst.add(stringArray);
            }
            if (smemConfig != null) {
                String[] stringArray = new String[3];
                stringArray[0] = String.valueOf(ViperComputeDictionary.SHARED.getLabel(ckind)) + " Memory Bank Size";
                stringArray[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemConfig.intValue());
                rowsLst.add(stringArray);
            }
            if (smemRequested != null) {
                String[] stringArray = new String[3];
                stringArray[0] = String.valueOf(ViperComputeDictionary.SHARED.getLabel(ckind)) + " Memory Requested";
                stringArray[1] = new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemRequested);
                rowsLst.add(stringArray);
            }
        }
        String[][] rowStrArr = (String[][])rowsLst.toArray((T[])new String[0][0]);
        ReportTableData reportTblData = new ReportTableData(rowStrArr, caption, new double[]{50.0, 50.0}, 0, rowStrArr.length, 0, 2);
        return reportTblData;
    }

    private void checkMonitorCancellation() throws ViperReportCancelledException {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new ViperReportCancelledException("Report Generation Cancelled");
        }
    }

    private List<IViperReportCellData> collectStageResults(List<AnalysisResult> aResults) throws ViperReportCancelledException {
        ArrayList<IViperReportCellData> viperCellDataList = new ArrayList<IViperReportCellData>();
        for (final AnalysisResult aResult : aResults) {
            this.checkMonitorCancellation();
            if (aResult.getSeverity().equals((Object)AnalysisDescriptor.Severity.OK) || aResult.getSeverity().equals((Object)AnalysisDescriptor.Severity.NODATA)) continue;
            IViperReportCellData viperCellData = new IViperReportCellData(){

                public String getDescription() {
                    return aResult.getDescription(ResultOutput.REPORT);
                }

                public String getDetails() {
                    return aResult.getDetails(ResultOutput.REPORT);
                }

                public String getLabel() {
                    return aResult.getLabel(ResultOutput.REPORT);
                }

                public IViperReportCellData.EmbeddableGraphic[] getSVG() {
                    ArrayList<Object> embdGraphicList = new ArrayList<Object>();
                    try {
                        int prefHeight = -1;
                        IAnalysisResultGraphicFactory aicFactory = aResult.getAnalysisResultFactory();
                        IAnalysisResultSVG[] aicArr = aicFactory.construct(aResult, ReportGenerationAction.this.session);
                        boolean drewImg = false;
                        if (aicArr != null) {
                            IAnalysisResultSVG[] iAnalysisResultSVGArray = aicArr;
                            int n = aicArr.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IAnalysisResultSVG aic = iAnalysisResultSVGArray[n2];
                                prefHeight = aic.getPreferredSVGHieght(ReportGenerationAction.this.gc);
                                String diagName = ReportGenerationAction.this.getUniqDiagPath();
                                ReportTableData[] tableData = aic.getTableElements();
                                if (tableData != null) {
                                    IViperReportCellData.ReportTableDataGraphic birtReportTableData = new IViperReportCellData.ReportTableDataGraphic(tableData);
                                    embdGraphicList.add(birtReportTableData);
                                }
                                if (drewImg = aic.createSVG(diagName, 800, prefHeight, ReportGenerationAction.this.gc)) {
                                    IViperReportCellData.ImageProperties ip = new IViperReportCellData.ImageProperties(diagName, 800, prefHeight);
                                    embdGraphicList.add(ip);
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (ViperException e) {
                        e.printStackTrace();
                    }
                    return embdGraphicList.toArray(new IViperReportCellData.EmbeddableGraphic[0]);
                }

                public String getActionDesc() {
                    return aResult.getActionDescription(ResultOutput.REPORT);
                }
            };
            viperCellDataList.add(viperCellData);
        }
        return viperCellDataList;
    }

    private IViperReportStageData constructStageItem(ExpertSystemStageKind kind, final List<IViperReportCellData> viperCellDataList) {
        IExpertSystemStage stage = this.session.getExpertSystem().getStageForKind(kind);
        IViperReportStageData viperStageData = new IViperReportStageData(stage){
            final String stageTitle;
            final String stageDescription;
            {
                this.stageTitle = iExpertSystemStage.getTitle(ResultOutput.REPORT);
                this.stageDescription = iExpertSystemStage.getDescription(ResultOutput.REPORT);
            }

            public List<IViperReportCellData> getCellDataList() {
                return viperCellDataList;
            }

            public String getStageDescription() {
                return this.stageDescription;
            }

            public String getStageTitle() {
                return this.stageTitle;
            }
        };
        return viperStageData;
    }

    private boolean doStageAction(String stepTitle) throws ViperReportCancelledException {
        assert (stepTitle != null);
        this.checkMonitorCancellation();
        IExpertSystemStage stage = this.session.getExpertSystem().getCurrentStage();
        int step = 0;
        while (step < stage.getNumSteps()) {
            if (stepTitle.equals(stage.getStepTitle(step))) {
                final ExpertSystemStepAction action = stage.getStepAction(step);
                if (stage.isStepCompleted(step) || !stage.canPerformStep(step)) {
                    return false;
                }
                final boolean[] ret = new boolean[]{true};
                this.checkMonitorCancellation();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus status = action.perform(ReportGenerationAction.this.session);
                        if (!Status.OK_STATUS.equals(status)) {
                            ret[0] = false;
                        }
                    }
                });
                return ret[0];
            }
            ++step;
        }
        return false;
    }

    private String getUniqDiagPath() {
        return this.reportGenTmpDir.append(_diagName + ++_diagPostFix).addFileExtension(_diagExtension).toOSString();
    }

    public int run() throws InvocationTargetException {
        ExpertSystem expert = this.session.getExpertSystem();
        ExpertSystemStageKind[] stageKinds = new ExpertSystemStageKind[]{ExpertSystemStageKind.BOUNDS, ExpertSystemStageKind.LATENCY, ExpertSystemStageKind.MEMORY, ExpertSystemStageKind.COMPUTE};
        HashMap<ExpertSystemStageKind, String[]> stageActions = new HashMap<ExpertSystemStageKind, String[]>();
        stageActions.put(ExpertSystemStageKind.BOUNDS, new String[0]);
        stageActions.put(ExpertSystemStageKind.LATENCY, new String[]{ViperMessages.ExpertSystem_Bounds_StepLatency_Title, ViperMessages.ExpertSystem_Latency_ShowOccupancy_Title});
        stageActions.put(ExpertSystemStageKind.MEMORY, new String[]{ViperMessages.ExpertSystem_Bounds_StepMemory_Title});
        stageActions.put(ExpertSystemStageKind.COMPUTE, new String[]{ViperMessages.ExpertSystem_Bounds_StepCompute_Title});
        int numMonitorSteps = stageKinds.length + 30 * stageKinds.length;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)this.progressMonitor, (String)"Report Generation", (int)numMonitorSteps);
        monitor.beginTask("Generating Report", numMonitorSteps);
        if (expert == null) {
            throw new RuntimeException("Session Object is null!");
        }
        try {
            int status;
            ArrayList<IViperReportStageData> stagesList = new ArrayList<IViperReportStageData>();
            stagesList.add(this.collectStageData(expert, ExpertSystemStageKind.BOUNDS, (String[])stageActions.get((Object)ExpertSystemStageKind.BOUNDS)));
            monitor.worked(1);
            AnalysisResultKernelBounds.Bound bound = AnalysisResultKernelBounds.Bound.UNKNOWN;
            for (AnalysisResult result : expert.getAnalysisResults()) {
                if (!(result instanceof AnalysisResultKernelBounds)) continue;
                bound = ((AnalysisResultKernelBounds)result).getBound();
                break;
            }
            ExpertSystemStageKind[] stageOrder = null;
            switch (bound) {
                case BALANCED_COMPUTE_MEMORY: 
                case COMPUTE: {
                    stageOrder = new ExpertSystemStageKind[]{ExpertSystemStageKind.COMPUTE, ExpertSystemStageKind.MEMORY, ExpertSystemStageKind.LATENCY};
                    break;
                }
                case MEMORY: {
                    stageOrder = new ExpertSystemStageKind[]{ExpertSystemStageKind.MEMORY, ExpertSystemStageKind.LATENCY, ExpertSystemStageKind.COMPUTE};
                    break;
                }
                default: {
                    stageOrder = new ExpertSystemStageKind[]{ExpertSystemStageKind.LATENCY, ExpertSystemStageKind.COMPUTE, ExpertSystemStageKind.MEMORY};
                }
            }
            int i = 0;
            while (i < stageOrder.length) {
                stagesList.add(this.collectStageData(expert, stageOrder[i], (String[])stageActions.get((Object)stageOrder[i])));
                monitor.worked(1);
                ++i;
            }
            this.setCurrentStage(expert, ExpertSystemStageKind.BOUNDS);
            int n = status = this.writeToReport(stagesList, monitor.newChild(stagesList.size() * 10));
            return n;
        }
        catch (ViperReportCancelledException viperReportCancelledException) {
            return 8;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
        }
    }

    private IViperReportStageData collectStageData(ExpertSystem expert, ExpertSystemStageKind stage, String ... actionList) throws ViperReportCancelledException {
        String[] stringArray = actionList;
        int n = actionList.length;
        int n2 = 0;
        while (n2 < n) {
            String action = stringArray[n2];
            this.setCurrentStage(expert, stage);
            this.doStageAction(action);
            ++n2;
        }
        this.setCurrentStage(expert, stage);
        ArrayList<IViperReportCellData> stageCells = new ArrayList<IViperReportCellData>();
        stageCells.addAll(this.collectStageResults(expert.getAnalysisResults()));
        IViperReportStageData stageData = this.constructStageItem(stage, stageCells);
        return stageData;
    }

    private void setCurrentStage(ExpertSystem expert, final ExpertSystemStageKind kind) throws ViperReportCancelledException {
        this.checkMonitorCancellation();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new ExpertSystemStepAction(kind).perform(ReportGenerationAction.this.session);
            }
        });
    }

    private int writeToReport(List<IViperReportStageData> stageData, SubMonitor submonitor) throws IOException, ViperBirtReportException, ViperReportCancelledException {
        ReportGeneration reportGenerator = new ReportGeneration(stageData, this.reportGenTmpDir.toOSString(), this.pdfOutputFile, this.kernelName, this.timeLineKernelProp, this.timeLineDeviceProp, (IProgressMonitor)submonitor);
        this.checkMonitorCancellation();
        int status = reportGenerator.generateReport();
        return status;
    }
}

