/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MITargetDownloadInfo
extends MIInfo {
    private String fAddress = "";
    private long fLoadSize = 0L;
    private long fTransferRate = 0L;
    private long fWriteRate = 0L;

    public MITargetDownloadInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    public String getAddress() {
        return this.fAddress;
    }

    public long getLoadSize() {
        return this.fLoadSize;
    }

    public long getTransferRate() {
        return this.fTransferRate;
    }

    public long getWriteRate() {
        return this.fWriteRate;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value != null && value instanceof MIConst) {
                    str = ((MIConst)value).getCString().trim();
                }
                if (var.equals("address")) {
                    this.fAddress = str;
                } else if (var.equals("load-size")) {
                    try {
                        this.fLoadSize = Long.parseLong(str);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("transfer-rate")) {
                    try {
                        this.fTransferRate = Long.parseLong(str);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (var.equals("write-rate")) {
                    try {
                        this.fWriteRate = Long.parseLong(str);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
    }
}

