/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIBreakListInfo
extends MIInfo {
    MIBreakpoint[] breakpoints;

    public MIBreakListInfo(MIOutput rr) {
        super(rr);
    }

    public MIBreakpoint[] getMIBreakpoints() {
        if (this.breakpoints == null) {
            this.parse();
        }
        return this.breakpoints;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList<MIBreakpoint> aList = new ArrayList<MIBreakpoint>(1);
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("BreakpointTable")) {
                    this.parseTable(results[i].getMIValue(), aList);
                }
                ++i;
            }
        }
        this.breakpoints = aList.toArray(new MIBreakpoint[aList.size()]);
    }

    void parseTable(MIValue val, List<MIBreakpoint> aList) {
        if (val instanceof MITuple) {
            MIResult[] table = ((MITuple)val).getMIResults();
            int j = 0;
            while (j < table.length) {
                String variable = table[j].getVariable();
                if (variable.equals("body")) {
                    this.parseBody(table[j].getMIValue(), aList);
                }
                ++j;
            }
        }
    }

    void parseBody(MIValue body, List<MIBreakpoint> aList) {
        if (body instanceof MIList) {
            MIResult[] bkpts = ((MIList)body).getMIResults();
            int i = 0;
            while (i < bkpts.length) {
                MIValue value;
                String b = bkpts[i].getVariable();
                if (b.equals("bkpt") && (value = bkpts[i].getMIValue()) instanceof MITuple) {
                    aList.add(new MIBreakpoint((MITuple)value));
                }
                ++i;
            }
        }
    }
}

