/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIExpressions;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryBytesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.MemoryByte;
import org.osgi.framework.BundleContext;

public class MIMemory
extends AbstractDsfService
implements IMemory,
ICachingService {
    private static final String READ_MEMORY_BYTES_FEATURE = "data-read-memory-bytes";
    private static final String DATA_WRITE_MEMORY_16_NOT_SUPPORTED = "data-write-memory with word-size != 1 not supported";
    private CommandCache fCommandCache;
    private CommandFactory fCommandFactory;
    private Map<IMemory.IMemoryDMContext, MIMemoryCache> fMemoryCaches;
    private boolean fDataReadMemoryBytes;

    protected MIMemoryCache getMemoryCache(IMemory.IMemoryDMContext memoryDMC) {
        MIMemoryCache cache = this.fMemoryCaches.get(memoryDMC);
        if (cache == null) {
            cache = new MIMemoryCache();
            this.fMemoryCaches.put(memoryDMC, cache);
        }
        return cache;
    }

    public MIMemory(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                MIMemory.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        IGDBControl commandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)commandControl, this.getExecutor(), 2);
        this.fDataReadMemoryBytes = commandControl.getFeatures().contains(READ_MEMORY_BYTES_FEATURE);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fCommandCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.register(new String[]{MIMemory.class.getName(), IMemory.class.getName()}, new Hashtable());
        this.fMemoryCaches = new HashMap<IMemory.IMemoryDMContext, MIMemoryCache>();
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void getMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int word_count, DataRequestMonitor<MemoryByte[]> drm) {
        if (memoryDMC == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown context type", null));
            drm.done();
            return;
        }
        if (word_size < 1) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Word size not supported (< 1)", null));
            drm.done();
            return;
        }
        if (word_count < 0) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid word count (< 0)", null));
            drm.done();
            return;
        }
        this.getMemoryCache(memoryDMC).getMemory(memoryDMC, address.add(offset), word_size, word_count, drm);
    }

    public void setMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int word_count, byte[] buffer, RequestMonitor rm) {
        if (memoryDMC == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        if (word_size < 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Word size not supported (< 1)", null));
            rm.done();
            return;
        }
        if (word_count < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid word count (< 0)", null));
            rm.done();
            return;
        }
        if (buffer.length < word_count * word_size) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Buffer too short", null));
            rm.done();
            return;
        }
        this.getMemoryCache(memoryDMC).setMemory(memoryDMC, address, offset, word_size, word_count, buffer, rm);
    }

    public void fillMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, long offset, int word_size, int count, byte[] pattern, RequestMonitor rm) {
        if (memoryDMC == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        if (word_size < 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Word size not supported (< 1)", null));
            rm.done();
            return;
        }
        if (count < 0) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid repeat count (< 0)", null));
            rm.done();
            return;
        }
        if (pattern.length < 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Empty pattern", null));
            rm.done();
            return;
        }
        int length = pattern.length;
        byte[] buffer = new byte[count * length];
        int i = 0;
        while (i < count) {
            System.arraycopy(pattern, 0, buffer, i * length, length);
            ++i;
        }
        int word_count = buffer.length / word_size;
        if (buffer.length % word_size != 0) {
            ++word_count;
        }
        this.getMemoryCache(memoryDMC).setMemory(memoryDMC, address, offset, word_size, word_count, buffer, rm);
    }

    protected void readMemoryBlock(IDMContext dmc, IAddress address, long offset, final int word_size, final int word_count, final DataRequestMonitor<MemoryByte[]> drm) {
        if (this.fDataReadMemoryBytes) {
            this.fCommandCache.execute(this.fCommandFactory.createMIDataReadMemoryBytes(dmc, address.toString(), offset, word_count, word_size), (DataRequestMonitor)new DataRequestMonitor<MIDataReadMemoryBytesInfo>((Executor)this.getExecutor(), drm){

                protected void handleSuccess() {
                    drm.setData((Object)((MIDataReadMemoryBytesInfo)this.getData()).getMIMemoryBlock());
                    drm.done();
                }

                protected void handleFailure() {
                    drm.setData((Object)MIMemory.this.createInvalidBlock(word_size * word_count));
                    drm.done();
                }
            });
        } else {
            if (word_size != 1) {
                drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, DATA_WRITE_MEMORY_16_NOT_SUPPORTED, null));
                drm.done();
                return;
            }
            int mode = 0;
            int nb_rows = 1;
            int nb_cols = word_count;
            Character asChar = null;
            this.fCommandCache.execute(this.fCommandFactory.createMIDataReadMemory(dmc, offset, address.toString(), mode, word_size, nb_rows, nb_cols, asChar), (DataRequestMonitor)new DataRequestMonitor<MIDataReadMemoryInfo>((Executor)this.getExecutor(), drm){

                protected void handleSuccess() {
                    drm.setData((Object)((MIDataReadMemoryInfo)this.getData()).getMIMemoryBlock());
                    drm.done();
                }

                protected void handleFailure() {
                    drm.setData((Object)MIMemory.this.createInvalidBlock(word_size * word_count));
                    drm.done();
                }
            });
        }
    }

    private MemoryByte[] createInvalidBlock(int size) {
        MemoryByte[] block = new MemoryByte[size];
        int i = 0;
        while (i < block.length) {
            block[i] = new MemoryByte(0, 0);
            ++i;
        }
        return block;
    }

    protected void writeMemoryBlock(IDMContext dmc, IAddress address, long offset, int word_size, int word_count, byte[] buffer, RequestMonitor rm) {
        if (this.fDataReadMemoryBytes) {
            this.fCommandCache.execute(this.fCommandFactory.createMIDataWriteMemoryBytes(dmc, address.add(offset).toString(), buffer.length == word_count * word_size ? buffer : Arrays.copyOf(buffer, word_count * word_size)), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            if (word_size != 1) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, DATA_WRITE_MEMORY_16_NOT_SUPPORTED, null));
                rm.done();
                return;
            }
            CountingRequestMonitor countingRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
            countingRM.setDoneCount(word_count);
            int format = 3;
            String baseAddress = address.toString();
            int i = 0;
            while (i < word_count) {
                String value = new Byte(buffer[i]).toString();
                this.fCommandCache.execute(this.fCommandFactory.createMIDataWriteMemory(dmc, offset + (long)i, baseAddress, format, word_size, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRM));
                ++i;
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        IMemory.IMemoryDMContext memoryDMC;
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fCommandCache.setContextAvailable(e.getDMContext(), false);
        }
        if (e.getReason() != IRunControl.StateChangeReason.STEP && (memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IMemory.IMemoryDMContext.class)) != null) {
            this.fCommandCache.reset((IDMContext)memoryDMC);
            this.memoryCacheReset(memoryDMC);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        IMemory.IMemoryDMContext memoryDMC;
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fCommandCache.setContextAvailable(e.getDMContext(), true);
        }
        if ((memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IMemory.IMemoryDMContext.class)) != null) {
            this.fCommandCache.reset((IDMContext)memoryDMC);
            this.memoryCacheReset(memoryDMC);
        }
    }

    @Deprecated
    public void eventDispatched(MIExpressions.ExpressionChangedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IExpressions.IExpressionChangedDMEvent e) {
        final IExpressions.IExpressionDMContext context = (IExpressions.IExpressionDMContext)e.getDMContext();
        IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        if (expressionService != null) {
            expressionService.getExpressionAddressData(context, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)this.getExecutor(), null){

                protected void handleSuccess() {
                    IExpressions.IExpressionDMAddress expression = (IExpressions.IExpressionDMAddress)this.getData();
                    IAddress expAddress = expression.getAddress();
                    if (expAddress != IExpressions.IExpressionDMLocation.INVALID_ADDRESS) {
                        int count = expression.getSize();
                        Addr64 address = expAddress instanceof Addr64 ? (Addr64)expAddress : new Addr64(expAddress.getValue());
                        IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
                        MIMemory.this.getMemoryCache(memoryDMC).refreshMemory(memoryDMC, (IAddress)address, 0L, MIMemory.this.getAddressableSize(memoryDMC), count, true, new RequestMonitor((Executor)MIMemory.this.getExecutor(), null));
                    }
                }
            });
        }
    }

    protected int getAddressableSize(IMemory.IMemoryDMContext context) {
        return 1;
    }

    public void flushCache(IDMContext context) {
        this.fCommandCache.reset(context);
        IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
        if (memoryDMC != null) {
            this.memoryCacheReset(memoryDMC);
        }
    }

    private void memoryCacheReset(IMemory.IMemoryDMContext memoryDMC) {
        for (IMemory.IMemoryDMContext ctx : this.fMemoryCaches.keySet()) {
            if ((ctx == null || !ctx.equals(memoryDMC)) && !DMContexts.isAncestorOf((IDMContext)ctx, (IDMContext)memoryDMC)) continue;
            this.fMemoryCaches.get(ctx).reset();
        }
    }

    protected class MIMemoryCache {
        private SortedMemoryBlockList fMemoryBlockList;

        public MIMemoryCache() {
            this.fMemoryBlockList = new SortedMemoryBlockList();
        }

        public void reset() {
            this.fMemoryBlockList.clear();
        }

        private LinkedList<MemoryBlock> getListOfMissingBlocks(IAddress reqBlockStart, int word_count, int word_size) {
            int octetCount = word_count * word_size;
            LinkedList<MemoryBlock> list = new LinkedList<MemoryBlock>();
            ListIterator it = this.fMemoryBlockList.listIterator();
            while (it.hasNext() && octetCount > 0) {
                MemoryBlock cachedBlock = (MemoryBlock)it.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLengthInAddressableUnits);
                if (reqBlockStart.distanceTo(cachedBlockStart).longValue() >= 0L) {
                    int lengthInOctets = (int)Math.min(reqBlockStart.distanceTo(cachedBlockStart).longValue() * (long)word_size, (long)octetCount);
                    if (lengthInOctets > 0) {
                        int lengthInAddressableUnits = lengthInOctets / word_size;
                        MemoryBlock newBlock = new MemoryBlock(reqBlockStart, lengthInOctets, lengthInAddressableUnits, new MemoryByte[0]);
                        list.add(newBlock);
                    }
                    reqBlockStart = cachedBlockEnd;
                    octetCount = (int)((long)octetCount - ((long)lengthInOctets + cachedBlock.fLengthInOctets));
                    continue;
                }
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() <= 0L || reqBlockStart.distanceTo(cachedBlockEnd).longValue() < 0L) continue;
                octetCount = (int)((long)octetCount - reqBlockStart.distanceTo(cachedBlockEnd).longValue() * (long)word_size);
                reqBlockStart = cachedBlockEnd;
            }
            if (octetCount > 0) {
                int addressesLength = octetCount / word_size;
                MemoryBlock newBlock = new MemoryBlock(reqBlockStart, octetCount, addressesLength, new MemoryByte[0]);
                list.add(newBlock);
            }
            return list;
        }

        private MemoryByte[] getMemoryBlockFromCache(IAddress reqBlockStart, int word_count, int word_size) {
            int count = word_count * word_size;
            IAddress reqBlockEnd = reqBlockStart.add((long)word_count);
            MemoryByte[] resultBlock = new MemoryByte[count];
            ListIterator iter = this.fMemoryBlockList.listIterator();
            while (iter.hasNext()) {
                int length;
                int pos;
                MemoryBlock cachedBlock = (MemoryBlock)iter.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLengthInAddressableUnits);
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() >= 0L && reqBlockEnd.distanceTo(cachedBlockEnd).longValue() >= 0L) {
                    pos = (int)cachedBlockStart.distanceTo(reqBlockStart).longValue() * word_size;
                    System.arraycopy(cachedBlock.fBlock, pos, resultBlock, 0, count);
                    continue;
                }
                if (reqBlockStart.distanceTo(cachedBlockStart).longValue() >= 0L && cachedBlockStart.distanceTo(reqBlockEnd).longValue() > 0L) {
                    pos = (int)reqBlockStart.distanceTo(cachedBlockStart).longValue() * word_size;
                    length = (int)Math.min(cachedBlock.fLengthInOctets, (long)(count - pos));
                    System.arraycopy(cachedBlock.fBlock, 0, resultBlock, pos, length);
                    continue;
                }
                if (cachedBlockStart.distanceTo(reqBlockStart).longValue() < 0L || reqBlockStart.distanceTo(cachedBlockEnd).longValue() <= 0L) continue;
                pos = (int)cachedBlockStart.distanceTo(reqBlockStart).longValue() * word_size;
                length = (int)Math.min(cachedBlock.fLengthInOctets - (long)pos, (long)count);
                System.arraycopy(cachedBlock.fBlock, pos, resultBlock, 0, length);
            }
            return resultBlock;
        }

        private void updateMemoryCache(IAddress modBlockStart, int word_count, MemoryByte[] modBlock, int word_size) {
            IAddress modBlockEnd = modBlockStart.add((long)word_count);
            ListIterator iter = this.fMemoryBlockList.listIterator();
            int count = word_count * word_size;
            while (iter.hasNext()) {
                int length;
                int pos;
                MemoryBlock cachedBlock = (MemoryBlock)iter.next();
                IAddress cachedBlockStart = cachedBlock.fAddress;
                IAddress cachedBlockEnd = cachedBlock.fAddress.add(cachedBlock.fLengthInAddressableUnits);
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockEnd.distanceTo(cachedBlockEnd).longValue() >= 0L) {
                    pos = (int)cachedBlockStart.distanceTo(modBlockStart).longValue() * word_size;
                    System.arraycopy(modBlock, 0, cachedBlock.fBlock, pos, count);
                    continue;
                }
                if (modBlockStart.distanceTo(cachedBlockStart).longValue() >= 0L && cachedBlockEnd.distanceTo(modBlockEnd).longValue() >= 0L) {
                    pos = (int)modBlockStart.distanceTo(cachedBlockStart).longValue() * word_size;
                    System.arraycopy(modBlock, pos, cachedBlock.fBlock, 0, (int)cachedBlock.fLengthInOctets);
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockStart).longValue() >= 0L && modBlockStart.distanceTo(cachedBlockEnd).longValue() > 0L) {
                    pos = (int)cachedBlockStart.distanceTo(modBlockStart).longValue() * word_size;
                    length = (int)modBlockStart.distanceTo(cachedBlockEnd).longValue() * word_size;
                    System.arraycopy(modBlock, 0, cachedBlock.fBlock, pos, length);
                    continue;
                }
                if (cachedBlockStart.distanceTo(modBlockEnd).longValue() <= 0L || modBlockEnd.distanceTo(cachedBlockEnd).longValue() < 0L) continue;
                pos = (int)modBlockStart.distanceTo(cachedBlockStart).longValue() * word_size;
                length = (int)cachedBlockStart.distanceTo(modBlockEnd).longValue() * word_size;
                System.arraycopy(modBlock, pos, cachedBlock.fBlock, 0, length);
            }
        }

        public void getMemory(IMemory.IMemoryDMContext memoryDMC, IAddress address, final int word_size, int word_count, DataRequestMonitor<MemoryByte[]> drm) {
            LinkedList<MemoryBlock> missingBlocks = this.getListOfMissingBlocks(address, word_count, word_size);
            int numberOfRequests = missingBlocks.size();
            final CountingRequestMonitor countingRM = new CountingRequestMonitor((Executor)MIMemory.this.getExecutor(), (RequestMonitor)drm, (DataRequestMonitor)drm, address, word_count, word_size){
                private final /* synthetic */ DataRequestMonitor val$drm;
                private final /* synthetic */ IAddress val$address;
                private final /* synthetic */ int val$word_count;
                private final /* synthetic */ int val$word_size;
                {
                    this.val$drm = dataRequestMonitor;
                    this.val$address = iAddress;
                    this.val$word_count = n;
                    this.val$word_size = n2;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    this.val$drm.setData((Object)MIMemoryCache.this.getMemoryBlockFromCache(this.val$address, this.val$word_count, this.val$word_size));
                    this.val$drm.done();
                }
            };
            countingRM.setDoneCount(numberOfRequests);
            int i = 0;
            while (i < numberOfRequests) {
                MemoryBlock block = missingBlocks.get(i);
                final IAddress startAddress = block.fAddress;
                int length = (int)block.fLengthInAddressableUnits;
                MIMemory.this.readMemoryBlock((IDMContext)memoryDMC, startAddress, 0L, word_size, length, new DataRequestMonitor<MemoryByte[]>((Executor)MIMemory.this.getSession().getExecutor(), drm){

                    protected void handleSuccess() {
                        MemoryByte[] block = (MemoryByte[])this.getData();
                        int lenghtInaddressableUnits = block.length / word_size;
                        MemoryBlock memoryBlock = new MemoryBlock(startAddress, block.length, lenghtInaddressableUnits, block);
                        MIMemoryCache.this.fMemoryBlockList.add(memoryBlock);
                        countingRM.done();
                    }
                });
                ++i;
            }
        }

        public void setMemory(final IMemory.IMemoryDMContext memoryDMC, final IAddress address, final long offset, final int word_size, final int word_count, byte[] buffer, final RequestMonitor rm) {
            MIMemory.this.writeMemoryBlock((IDMContext)memoryDMC, address, offset, word_size, word_count, buffer, new RequestMonitor((Executor)MIMemory.this.getSession().getExecutor(), rm){

                protected void handleSuccess() {
                    MIMemory.this.fCommandCache.reset();
                    MIMemory.this.readMemoryBlock((IDMContext)memoryDMC, address, offset, word_size, word_count, new DataRequestMonitor<MemoryByte[]>((Executor)MIMemory.this.getExecutor(), rm){

                        protected void handleSuccess() {
                            MIMemoryCache.this.updateMemoryCache(address.add(offset), word_count, (MemoryByte[])this.getData(), word_size);
                            IAddress[] addresses = new IAddress[word_count];
                            int i = 0;
                            while (i < word_count) {
                                addresses[i] = address.add(offset + (long)i);
                                ++i;
                            }
                            MIMemory.this.getSession().dispatchEvent((Object)new MemoryChangedEvent(memoryDMC, addresses), MIMemory.this.getProperties());
                            rm.done();
                        }
                    });
                }
            });
        }

        public void refreshMemory(final IMemory.IMemoryDMContext memoryDMC, final IAddress address, final long offset, final int word_size, final int word_count, final boolean sendMemoryEvent, final RequestMonitor rm) {
            LinkedList<MemoryBlock> list = this.getListOfMissingBlocks(address, word_count, word_size);
            int sizeToRead = 0;
            for (MemoryBlock block : list) {
                sizeToRead = (int)((long)sizeToRead + block.fLengthInAddressableUnits);
            }
            if (sizeToRead == word_count) {
                rm.done();
                return;
            }
            MIMemory.this.fCommandCache.reset();
            MIMemory.this.readMemoryBlock((IDMContext)memoryDMC, address, offset, word_size, word_count, new DataRequestMonitor<MemoryByte[]>((Executor)MIMemory.this.getExecutor(), rm){

                protected void handleSuccess() {
                    MemoryByte[] oldBlock = MIMemoryCache.this.getMemoryBlockFromCache(address, word_count, word_size);
                    MemoryByte[] newBlock = (MemoryByte[])this.getData();
                    boolean blocksDiffer = false;
                    int i = 0;
                    while (i < oldBlock.length) {
                        if (oldBlock[i].getValue() != newBlock[i].getValue()) {
                            blocksDiffer = true;
                            break;
                        }
                        ++i;
                    }
                    if (blocksDiffer) {
                        MIMemoryCache.this.updateMemoryCache(address.add(offset), word_count, newBlock, word_size);
                        if (sendMemoryEvent) {
                            IAddress[] addresses = new IAddress[word_count];
                            int i2 = 0;
                            while (i2 < word_count) {
                                addresses[i2] = address.add(offset + (long)i2);
                                ++i2;
                            }
                            MIMemory.this.getSession().dispatchEvent((Object)new MemoryChangedEvent(memoryDMC, addresses), MIMemory.this.getProperties());
                        }
                    }
                    rm.done();
                }
            });
        }
    }

    private class MemoryBlock {
        public IAddress fAddress;
        public long fLengthInAddressableUnits;
        public long fLengthInOctets;
        public MemoryByte[] fBlock;

        public MemoryBlock(IAddress address, long lengthInOctets, long lengthInAddressableUnits, MemoryByte[] block) {
            assert (lengthInOctets % lengthInAddressableUnits == 0L);
            this.fAddress = address;
            this.fLengthInAddressableUnits = lengthInAddressableUnits;
            this.fLengthInOctets = lengthInOctets;
            this.fBlock = block;
        }
    }

    public class MemoryChangedEvent
    extends AbstractDMEvent<IMemory.IMemoryDMContext>
    implements IMemory.IMemoryChangedEvent {
        IAddress[] fAddresses;
        IDMContext fContext;

        public MemoryChangedEvent(IMemory.IMemoryDMContext context, IAddress[] addresses) {
            super((IDMContext)context);
            this.fAddresses = addresses;
        }

        public IAddress[] getAddresses() {
            return this.fAddresses;
        }
    }

    private class SortedMemoryBlockList
    extends LinkedList<MemoryBlock> {
        @Override
        public boolean add(MemoryBlock block) {
            if (this.isEmpty()) {
                this.addFirst(block);
                return true;
            }
            ListIterator it = this.listIterator();
            while (it.hasNext()) {
                int index = it.nextIndex();
                MemoryBlock item = (MemoryBlock)it.next();
                if (block.fAddress.compareTo((Object)item.fAddress) >= 0) continue;
                this.add(index, block);
                this.compact(index);
                return true;
            }
            this.addLast(block);
            this.compact(this.size() - 1);
            return true;
        }

        private void compact(int index) {
            int lastIndex;
            MemoryBlock newBlock = (MemoryBlock)this.get(index);
            if (index > 0) {
                MemoryBlock prevBlock = (MemoryBlock)this.get(index - 1);
                IAddress endOfPreviousBlock = prevBlock.fAddress.add(prevBlock.fLengthInAddressableUnits);
                if (endOfPreviousBlock.distanceTo(newBlock.fAddress).longValue() == 0L) {
                    long newLengthInOctets = prevBlock.fLengthInOctets + newBlock.fLengthInOctets;
                    long newLengthInAddressableUnits = prevBlock.fLengthInAddressableUnits + newBlock.fLengthInAddressableUnits;
                    if (newLengthInOctets <= Integer.MAX_VALUE) {
                        MemoryByte[] block = new MemoryByte[(int)newLengthInOctets];
                        System.arraycopy(prevBlock.fBlock, 0, block, 0, (int)prevBlock.fLengthInOctets);
                        System.arraycopy(newBlock.fBlock, 0, block, (int)prevBlock.fLengthInOctets, (int)newBlock.fLengthInOctets);
                        newBlock = new MemoryBlock(prevBlock.fAddress, newLengthInOctets, newLengthInAddressableUnits, block);
                        this.remove(index);
                        this.set(--index, newBlock);
                    }
                }
            }
            if (index < (lastIndex = this.size() - 1)) {
                MemoryBlock nextBlock = (MemoryBlock)this.get(index + 1);
                IAddress endOfNewBlock = newBlock.fAddress.add(newBlock.fLengthInAddressableUnits);
                if (endOfNewBlock.distanceTo(nextBlock.fAddress).longValue() == 0L) {
                    long newLength = newBlock.fLengthInOctets + nextBlock.fLengthInOctets;
                    long newAddressesLength = newBlock.fLengthInAddressableUnits + nextBlock.fLengthInAddressableUnits;
                    if (newLength <= Integer.MAX_VALUE) {
                        MemoryByte[] block = new MemoryByte[(int)newLength];
                        System.arraycopy(newBlock.fBlock, 0, block, 0, (int)newBlock.fLengthInOctets);
                        System.arraycopy(nextBlock.fBlock, 0, block, (int)newBlock.fLengthInOctets, (int)nextBlock.fLengthInOctets);
                        newBlock = new MemoryBlock(newBlock.fAddress, newLength, newAddressesLength, block);
                        this.set(index, newBlock);
                        this.remove(index + 1);
                    }
                }
            }
        }
    }
}

