/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.remote.connection.ConnectionEditorDelegate;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import com.nvidia.cuda.ide.remote.internal.connection.ManageRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.ui.connection.ConnectionWorkingCopy;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RemoteConnectionCombo {
    public static String PREF_KEY_LAST_CONNECTION = "last.connection";
    private final ComboViewer connectionCombo;
    private ConnectionEditorDelegate delegate;
    protected IRemoteConnection previousSelected;
    private static RemovedConnectionsListener removedConnectionsListener;

    public void setPreviousSelected(IRemoteConnection previousSelected) {
        this.previousSelected = previousSelected;
    }

    public RemoteConnectionCombo(Composite parent) {
        this(parent, null);
    }

    public RemoteConnectionCombo(Composite parent, ConnectionEditorDelegate delegate) {
        this.delegate = delegate == null ? new DefaultDelegate() : delegate;
        this.connectionCombo = new ComboViewer(parent, 2056);
        this.connectionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.connectionCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IRemoteConnection)element).getName();
            }
        });
        this.connectionCombo.setSorter(new ViewerSorter(){

            public int category(Object element) {
                IRemoteConnection connection = (IRemoteConnection)element;
                if (connection.isLocalSystem()) {
                    return 0;
                }
                if (connection instanceof ManageRemoteConnection) {
                    return 2;
                }
                return 1;
            }
        });
        try {
            IRemoteConnection[] connections = (IRemoteConnection[])CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, IRemoteConnection[]>(){

                public IRemoteConnection[] runWithService(IRemoteConnectionsService service) throws CoreException {
                    return service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
                }
            });
            IRemoteConnection[] newConnections = this.addManageRemoteItem(connections);
            this.connectionCombo.setInput((Object)newConnections);
            this.connectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    IRemoteConnection conn = (IRemoteConnection)selection.getFirstElement();
                    if (conn != null) {
                        Activator.getDefault().getPreferenceStore().setValue(PREF_KEY_LAST_CONNECTION, conn.getName());
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public void initConnectionSelection() {
        String name = Activator.getDefault().getPreferenceStore().getString(PREF_KEY_LAST_CONNECTION);
        IRemoteConnection current = RemoteConnectionCombo.getConnection(name.isEmpty() ? null : name);
        if (current != null) {
            this.connectionCombo.setSelection((ISelection)new StructuredSelection((Object)current));
        }
    }

    private IRemoteConnection[] addManageRemoteItem(IRemoteConnection[] connections) {
        IRemoteConnection[] newConnections = Arrays.copyOf(connections, connections.length + 1);
        newConnections[connections.length] = new ManageRemoteConnection();
        return newConnections;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.connectionCombo.addSelectionChangedListener(listener);
    }

    public Control getControl() {
        return this.connectionCombo.getControl();
    }

    public IRemoteConnection getSelection() {
        return (IRemoteConnection)CoreUtil.getSelectedObject((ISelectionProvider)this.connectionCombo, IRemoteConnection.class);
    }

    public IRemoteConnection manage() {
        try {
            IRemoteConnection selection = (IRemoteConnection)CoreUtil.getSelectedObject((ISelectionProvider)this.connectionCombo, IRemoteConnection.class);
            Tuple newConnection = (Tuple)CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new NewConnectionAction(this.getControl().getShell(), this.delegate, selection));
            IRemoteConnection[] newConnections = this.addManageRemoteItem((IRemoteConnection[])newConnection.getObject2());
            this.connectionCombo.setInput((Object)newConnections);
            IRemoteConnection connection = (IRemoteConnection)newConnection.getObject1();
            if (connection != null) {
                this.connectionCombo.setSelection((ISelection)new StructuredSelection((Object)connection));
            }
            return connection;
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public IObservableValue observeSelection() {
        return ViewersObservables.observeSingleSelection((Viewer)this.connectionCombo);
    }

    public void setSelection(IRemoteConnection remoteConnection) {
        this.connectionCombo.setSelection((ISelection)(remoteConnection == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)remoteConnection)));
    }

    public void setFilter(ViewerFilter viewerFilter) {
        this.connectionCombo.setFilters(new ViewerFilter[]{viewerFilter});
    }

    public void addConnection(ConnectionWorkingCopy newCopy) {
        try {
            IRemoteConnection[] connections = this.getAllConnections();
            String name = newCopy.getBaseConnectionLabel();
            IRemoteConnection connection = RemoteConnectionCombo.getConnection(name);
            if (connection != null) {
                this.connectionCombo.setSelection((ISelection)new StructuredSelection((Object)connection));
            } else {
                newCopy.save();
                connections = this.getAllConnections();
                IRemoteConnection[] newConnections = this.addManageRemoteItem(connections);
                this.connectionCombo.setInput((Object)newConnections);
                connection = RemoteConnectionCombo.getConnection(name);
                this.connectionCombo.setSelection((ISelection)new StructuredSelection((Object)connection));
            }
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static IRemoteConnection getConnection(final String connectionName) {
        try {
            return (IRemoteConnection)CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, IRemoteConnection>(){

                public IRemoteConnection runWithService(IRemoteConnectionsService service) {
                    if (connectionName == null) {
                        IRemoteConnection[] connections;
                        IRemoteConnection[] iRemoteConnectionArray = connections = service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
                        int n = connections.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRemoteConnection connection = iRemoteConnectionArray[n2];
                            if (connection.isLocalSystem()) {
                                return connection;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    return service.getConnection(connectionName, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    private IRemoteConnection[] getAllConnections() throws CoreException {
        return (IRemoteConnection[])CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, IRemoteConnection[]>(){

            public IRemoteConnection[] runWithService(IRemoteConnectionsService service) throws CoreException {
                return service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    public static void removedConnections(Collection<ConnectionWorkingCopy> removed) {
        removedConnectionsListener.connectionsRemoved(removed);
    }

    public void setRemovedConnectionsListener(RemovedConnectionsListener listener) {
        removedConnectionsListener = listener;
    }

    private final class DefaultDelegate
    extends ConnectionEditorDelegate {
        private DefaultDelegate() {
        }

        @Override
        public IRemoteConnection getSelectedConnection() {
            return RemoteConnectionCombo.this.getSelection();
        }

        @Override
        public IRemoteConnection getPreviousSelected() {
            return RemoteConnectionCombo.this.previousSelected;
        }
    }

    public static class DelegateDecorator
    extends ConnectionEditorDelegate {
        private final ConnectionEditorDelegate decorated;
        private final String oldName;
        private IRemoteConnection connection;

        public DelegateDecorator(ConnectionEditorDelegate delegate) {
            this.decorated = delegate;
            this.connection = delegate.getSelectedConnection();
            this.oldName = this.connection != null ? this.connection.getName() : null;
        }

        @Override
        public boolean canDelete(IRemoteConnection connection) {
            return this.decorated.canDelete(connection);
        }

        @Override
        public void removed(IRemoteConnection connection) {
            if (this.connection != null && this.connection.equals(connection)) {
                this.connection = null;
            }
            this.decorated.removed(connection);
        }

        @Override
        public void renamed(String name, IRemoteConnection connection) {
            if (CoreUtil.equals((Object)this.oldName, (Object)name)) {
                this.connection = connection;
            }
            this.decorated.renamed(name, connection);
        }

        @Override
        public IRemoteConnection getSelectedConnection() {
            return this.decorated.getSelectedConnection();
        }

        public IRemoteConnection newSelection() {
            return this.connection;
        }

        @Override
        public IRemoteConnection getPreviousSelected() {
            return this.decorated.getPreviousSelected();
        }
    }

    private static final class NewConnectionAction
    implements IOSGIServiceAccess<IRemoteConnectionsService, Tuple<IRemoteConnection, IRemoteConnection[], ?>> {
        private final Shell shell;
        private final ConnectionEditorDelegate delegate;

        public NewConnectionAction(Shell shell, ConnectionEditorDelegate delegate, IRemoteConnection selected) {
            this.shell = shell;
            this.delegate = delegate;
        }

        public Tuple<IRemoteConnection, IRemoteConnection[], ?> runWithService(IRemoteConnectionsService service) {
            DelegateDecorator decorator = new DelegateDecorator(this.delegate);
            IRemoteConnection connection = service.manage(this.shell, decorator);
            IRemoteConnection[] allConnections = service.getAllConnections((IProgressMonitor)new NullProgressMonitor());
            if (connection == null) {
                IRemoteConnection[] iRemoteConnectionArray = allConnections;
                int n = allConnections.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteConnection c = iRemoteConnectionArray[n2];
                    if (c.isLocalSystem()) {
                        connection = c;
                        break;
                    }
                    ++n2;
                }
            }
            return Tuple.pair((Object)connection, (Object)allConnections);
        }
    }

    public static interface RemovedConnectionsListener {
        public void connectionsRemoved(Collection<ConnectionWorkingCopy> var1);
    }
}

