/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewInputProvider;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class SystemTeamViewContentProvider
extends WorkbenchContentProvider {
    private SystemTeamViewInputProvider inputProvider = null;
    private Viewer viewer;

    public Object[] getChildren(Object element) {
        ISystemViewElementAdapter adapter;
        Object[] profiles;
        Object[] children = element instanceof IProject ? (profiles = RSECorePlugin.getTheSystemRegistry().getSystemProfileManager().getSystemProfiles()) : ((adapter = this.getSystemViewAdapter(element)) != null ? adapter.getChildren((IAdaptable)element, (IProgressMonitor)new NullProgressMonitor()) : super.getChildren(element));
        return children;
    }

    public Object getParent(Object element) {
        if (element instanceof ISystemProfile) {
            return null;
        }
        ISystemViewElementAdapter adapter = this.getSystemViewAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return super.getParent(element);
    }

    public boolean hasChildren(Object element) {
        ISystemViewElementAdapter adapter;
        if (element instanceof IContextObject) {
            element = ((IContextObject)element).getModelObject();
        }
        boolean children = false;
        children = element instanceof IProject ? this.getChildren(element).length > 0 : ((adapter = this.getSystemViewAdapter(element)) != null ? adapter.hasChildren((IAdaptable)element) : super.hasChildren(element));
        return children;
    }

    public Object[] getElements(Object element) {
        if (this.inputProvider == null) {
            return new Object[0];
        }
        return this.inputProvider.getRoots();
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput != null && newInput instanceof SystemTeamViewInputProvider) {
            this.inputProvider = (SystemTeamViewInputProvider)newInput;
        }
    }

    protected ISystemViewElementAdapter getSystemViewAdapter(Object o) {
        ISystemViewElementAdapter adapter = null;
        if (o == null) {
            SystemBasePlugin.logWarning("ERROR: null passed to getAdapter in SystemTeamViewContentProvider");
            return null;
        }
        adapter = !(o instanceof IAdaptable) ? (ISystemViewElementAdapter)Platform.getAdapterManager().getAdapter(o, ISystemViewElementAdapter.class) : (ISystemViewElementAdapter)((IAdaptable)o).getAdapter(ISystemViewElementAdapter.class);
        if (adapter != null && this.viewer != null) {
            Shell shell = null;
            if (this.viewer instanceof ISystemShellProvider) {
                shell = ((ISystemShellProvider)this.viewer).getShell();
            } else if (this.viewer != null) {
                shell = this.viewer.getControl().getShell();
            }
            if (shell != null) {
                adapter.setShell(shell);
            }
            adapter.setViewer(this.viewer);
            if (this.viewer.getInput() instanceof ISystemViewInputProvider) {
                ISystemViewInputProvider inputProvider = (ISystemViewInputProvider)this.viewer.getInput();
                adapter.setInput(inputProvider);
            }
        } else if (this.viewer == null) {
            SystemBasePlugin.logWarning("VIEWER IS NULL FOR SystemTeamViewContentProvider");
        }
        return adapter;
    }
}

