/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.analysis.AnalysisResultKernelStall;
import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import java.util.LinkedList;
import java.util.List;

public final class KernelStallReasonChart
implements IViperChart {
    private final AnalysisResultKernelStall result;

    public KernelStallReasonChart(AnalysisResultKernelStall result) {
        this.result = result;
    }

    public ViperChartSeries[] getSeries() {
        List<AnalysisResultKernelStall.StallKind> kinds = this.result.getStallKinds();
        LinkedList<Double> values = new LinkedList<Double>();
        for (AnalysisResultKernelStall.StallKind kind : kinds) {
            double percent = this.result.getStallPercent(kind);
            values.add(percent);
        }
        return new ViperChartSeries[]{new ViperChartSeries(values.toArray(new Double[0]), ViperChartSeries.Type.PIE)};
    }

    public String getTitle() {
        return "Stall Reasons";
    }

    public boolean isHighlighted() {
        return false;
    }

    public boolean showLegend() {
        return false;
    }

    public int getHeight() {
        return 300;
    }

    public int getWidth() {
        return 700;
    }

    public AxesConfiguration getAxesConfiguration() {
        return null;
    }

    public String[] getLabels() {
        List<AnalysisResultKernelStall.StallKind> kinds = this.result.getStallKinds();
        LinkedList<String> labels = new LinkedList<String>();
        for (AnalysisResultKernelStall.StallKind kind : kinds) {
            labels.add(kind.toChartString());
        }
        return labels.toArray(new String[0]);
    }

    public boolean colorBySeries() {
        return false;
    }
}

