/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class UvmFilterAddressFamily
extends Composite {
    UvmFilterAddressState uvmFilterAddressState;
    private Text startAddressText;
    private Text endAddressText;
    private Text addressSizeText;
    private long minAddress;
    private long maxAddress;
    private CLabel startAddressLabel;
    private CLabel endAddressLabel;
    private CLabel addressSizeLabel;
    private Listener addressEnteredListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget.equals(UvmFilterAddressFamily.this.startAddressText)) {
                if (!UvmFilterAddressFamily.this.startAddressText.getText().isEmpty()) {
                    try {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress = Long.decode(UvmFilterAddressFamily.this.startAddressText.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress = Integer.parseInt(UvmFilterAddressFamily.this.startAddressText.getText());
                        }
                        catch (NumberFormatException numberFormatException2) {
                            UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress = UvmFilterAddressFamily.this.minAddress;
                        }
                    }
                    if (UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress > UvmFilterAddressFamily.this.maxAddress || UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress < UvmFilterAddressFamily.this.minAddress) {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress = UvmFilterAddressFamily.this.minAddress;
                    } else if (UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress > UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress) {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress = UvmFilterAddressFamily.this.maxAddress;
                    }
                    UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize = UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress - UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress;
                } else {
                    UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress = UvmFilterAddressFamily.this.minAddress;
                }
            } else if (event.widget.equals(UvmFilterAddressFamily.this.endAddressText)) {
                if (!UvmFilterAddressFamily.this.endAddressText.getText().isEmpty()) {
                    try {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress = Long.decode(UvmFilterAddressFamily.this.endAddressText.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress = Integer.parseInt(UvmFilterAddressFamily.this.endAddressText.getText());
                        }
                        catch (NumberFormatException numberFormatException3) {
                            UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress = UvmFilterAddressFamily.this.maxAddress;
                        }
                    }
                    if (UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress > UvmFilterAddressFamily.this.maxAddress || UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress < UvmFilterAddressFamily.this.minAddress) {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress = UvmFilterAddressFamily.this.maxAddress;
                    } else if (UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress < UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress) {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress = UvmFilterAddressFamily.this.minAddress;
                    }
                    UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize = UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress - UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress;
                } else {
                    UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress = UvmFilterAddressFamily.this.maxAddress;
                }
            } else if (event.widget.equals(UvmFilterAddressFamily.this.addressSizeText)) {
                if (!UvmFilterAddressFamily.this.addressSizeText.getText().isEmpty()) {
                    try {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize = Long.decode(UvmFilterAddressFamily.this.addressSizeText.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize = Integer.parseInt(UvmFilterAddressFamily.this.addressSizeText.getText());
                        }
                        catch (NumberFormatException numberFormatException4) {
                            UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize = UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress - UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress;
                        }
                    }
                    if (UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize > UvmFilterAddressFamily.this.maxAddress - UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress) {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize = UvmFilterAddressFamily.this.maxAddress - UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress;
                    } else if (UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize != UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress - UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress) {
                        UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress = UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress + UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize;
                    }
                } else {
                    UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize = UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress - UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress;
                }
            }
            UvmFilterAddressFamily.this.startAddressText.setText("0x" + Long.toHexString(UvmFilterAddressFamily.this.uvmFilterAddressState.userStartAddress));
            UvmFilterAddressFamily.this.endAddressText.setText("0x" + Long.toHexString(UvmFilterAddressFamily.this.uvmFilterAddressState.userEndAddress));
            UvmFilterAddressFamily.this.addressSizeText.setText("0x" + Long.toHexString(UvmFilterAddressFamily.this.uvmFilterAddressState.userAddressSize));
        }
    };

    public UvmFilterAddressFamily(Composite parent, int style, long minAddress, long maxAddress) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(4, false));
        this.minAddress = minAddress;
        this.maxAddress = maxAddress;
        this.startAddressLabel = new CLabel((Composite)this, 0);
        this.startAddressLabel.setText("Start Address:");
        this.startAddressLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.startAddressText = new Text((Composite)this, 18436);
        this.startAddressText.addListener(14, this.addressEnteredListener);
        this.startAddressText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.startAddressText.addListener(16, this.addressEnteredListener);
        this.endAddressLabel = new CLabel((Composite)this, 0);
        this.endAddressLabel.setText("End Address:");
        this.endAddressLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.endAddressText = new Text((Composite)this, 18436);
        this.endAddressText.addListener(14, this.addressEnteredListener);
        this.endAddressText.addListener(16, this.addressEnteredListener);
        this.endAddressText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addressSizeLabel = new CLabel((Composite)this, 0);
        this.addressSizeLabel.setText("Virtual address range size:");
        this.addressSizeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addressSizeText = new Text((Composite)this, 18436);
        this.addressSizeText.addListener(14, this.addressEnteredListener);
        this.addressSizeText.addListener(16, this.addressEnteredListener);
        this.addressSizeText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
    }

    public void setState(UvmFilterAddressState state) {
        if (state == null) {
            this.uvmFilterAddressState = new UvmFilterAddressState();
            this.uvmFilterAddressState.userStartAddress = this.minAddress;
            this.uvmFilterAddressState.userEndAddress = this.maxAddress;
            this.uvmFilterAddressState.userAddressSize = this.maxAddress - this.minAddress;
            this.startAddressText.setText("0x" + Long.toHexString(this.uvmFilterAddressState.userStartAddress));
            this.endAddressText.setText("0x" + Long.toHexString(this.uvmFilterAddressState.userEndAddress));
            this.addressSizeText.setText("0x" + Long.toHexString(this.uvmFilterAddressState.userAddressSize));
            this.setEnabled(false);
        } else {
            this.uvmFilterAddressState = state;
            this.startAddressText.setText("0x" + Long.toHexString(this.uvmFilterAddressState.userStartAddress));
            this.endAddressText.setText("0x" + Long.toHexString(this.uvmFilterAddressState.userEndAddress));
            this.addressSizeText.setText("0x" + Long.toHexString(this.uvmFilterAddressState.userAddressSize));
            this.setEnabled(true);
        }
    }

    public UvmFilterAddressState getState() {
        return this.uvmFilterAddressState;
    }

    public void setEnabled(boolean enabled) {
        this.startAddressText.setEnabled(enabled);
        this.endAddressText.setEnabled(enabled);
        this.addressSizeText.setEnabled(enabled);
    }

    public static class UvmFilterAddressState {
        private long userStartAddress;
        private long userEndAddress;
        private long userAddressSize;

        public long getUserStartAddress() {
            return this.userStartAddress;
        }

        public long getUserEndAddress() {
            return this.userEndAddress;
        }

        public long getUserAddressSize() {
            return this.userAddressSize;
        }
    }
}

