/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.activity.CuptiActivityMemory;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.activity.CuptiActivityUvmCounterKind;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceLocation;
import com.nvidia.viper.model.TimelineColorMode;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.UvmManager;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValueBandwidth;
import java.util.List;

public class TimelineIntervalUVM
extends TimelineIntervalBase {
    private long value;
    private final int processId;
    private final Long address;
    private final Integer flags;
    private long totalTime;
    private boolean isSegmented;
    private long addressStart = -1L;
    private long addressEnd = -1L;
    private CuptiActivityUvmCounter minValueCounter;
    private CuptiActivityUvmCounter maxValueCounter;
    private long numRecords = 0L;
    private long lastEventStart = -1L;
    private long lastEventEnd = -1L;
    private long totalDurationWithoutOverlap = 0L;
    private SourceLocation sourceLocation;
    private SourceLocation allocLocation;
    private SourceLocation freeLocation;
    public static int MAX_CPU_FAULTS_PER_SECOND = 300000;
    private int srcId;
    private int dstId;
    private List<Integer> deviceIdList;
    private boolean isCpu = false;
    private CuptiActivityMemory memoryActivity = null;
    private boolean computedPC = false;

    public TimelineIntervalUVM(TimelineIntervalKind kind, long id, long start, long end, long value, int processId) {
        super(kind, start, end, id);
        this.value = value;
        this.processId = processId;
        this.address = null;
        this.flags = 0;
    }

    public TimelineIntervalUVM(TimelineIntervalKind kind, long id, long start, long end, long value, int processId, long address, int flags) {
        super(kind, start, end, id);
        this.value = value;
        this.processId = processId;
        this.address = address;
        this.flags = flags;
    }

    public TimelineIntervalUVM(TimelineIntervalKind kind, CuptiActivityUvmCounter counter) {
        super(kind, counter.start, counter.end, counter.getID());
        this.value = counter.value;
        this.processId = counter.processId;
        this.flags = counter.flags;
        this.address = counter.address;
        this.srcId = counter.srcId;
        this.dstId = counter.dstId;
        this.deviceIdList = counter.getDeviceIDList();
        this.isCpu = counter.isCpu();
    }

    public TimelineIntervalUVM(long start, long end, int processId) {
        super(null, start, end, 0L);
        this.value = 0L;
        this.processId = processId;
        this.address = null;
        this.flags = 0;
    }

    @Override
    public String getName() {
        switch (this.kind) {
            case UVM_GPU_PAGE_FAULT: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT.getName();
            }
            case UVM_PAGE_FAULT: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT.getName();
            }
            case UVM_MEMCPY_HTOD: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD.getName();
            }
            case UVM_MEMCPY_DTOH: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH.getName();
            }
            case UVM_MEMCPY_DTOD: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD.getName();
            }
            case UVM_PAGE_THROTTLING: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING.getName();
            }
            case UVM_THRASHING: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING.getName();
            }
            case UVM_REMOTE_MAP: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP.getName();
            }
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public long getCounterValue() {
        return this.value;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getProcessId() {
        return this.processId;
    }

    public Long getAddress() {
        return this.address;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public boolean isSegmented() {
        return this.isSegmented;
    }

    public boolean isNew() {
        return this.address != null;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        ViperColors.GradientColors color;
        if (this.isSegmented && (color = ViperColors.getUVMSegmentColor(this.getHeatMapValue())) != null) {
            return color;
        }
        Session session = this.primaryTimeline.getSession();
        TimelineColorMode colorMode = session.getColorMode();
        if (colorMode.equals((Object)TimelineColorMode.PROCESS)) {
            return session.processIdToColorMap.get(this.getProcessId());
        }
        return colors;
    }

    public void setIsSegmented(boolean isSegmented) {
        this.isSegmented = isSegmented;
    }

    public void setStartAddress(long addressStart) {
        this.addressStart = addressStart;
    }

    public void setEndAddress(long addressEnd) {
        this.addressEnd = addressEnd;
    }

    public long getStartAddress() {
        return this.addressStart;
    }

    public long getEndAddress() {
        return this.addressEnd;
    }

    public void addCounterValue(long v) {
        this.value += v;
    }

    public void addTotalTime(long time) {
        this.totalTime += time;
    }

    public void incrementRecordCount() {
        ++this.numRecords;
    }

    public long getNumRecords() {
        if (this.isSegmented) {
            return this.numRecords;
        }
        return 1L;
    }

    public void setKind(TimelineIntervalKind kind) {
        this.kind = kind;
    }

    public void setMinValueActivity(CuptiActivityUvmCounter uvmCounter) {
        this.minValueCounter = uvmCounter;
    }

    public long getMinValue() {
        return this.minValueCounter == null ? -1L : this.minValueCounter.value;
    }

    public void setMaxValueActivity(CuptiActivityUvmCounter uvmCounter) {
        this.maxValueCounter = uvmCounter;
    }

    public long getMaxValue() {
        return this.maxValueCounter == null ? -1L : this.maxValueCounter.value;
    }

    public IValue getMinThroughput() {
        ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, this.minValueCounter.value, this.minValueCounter.end - this.minValueCounter.start);
        return bwValue;
    }

    public IValue getMaxThroughput() {
        ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, this.maxValueCounter.value, this.maxValueCounter.end - this.maxValueCounter.start);
        return bwValue;
    }

    public void mergeOverlappTime(long uvmStart, long uvmEnd) {
        if (this.lastEventStart == -1L || this.lastEventEnd == -1L) {
            this.lastEventStart = uvmStart;
            this.lastEventEnd = uvmEnd;
            return;
        }
        if (uvmStart <= this.lastEventEnd) {
            this.lastEventEnd = Math.max(uvmEnd, this.lastEventEnd);
        } else {
            this.totalDurationWithoutOverlap += this.lastEventEnd - this.lastEventStart;
            this.lastEventStart = uvmStart;
            this.lastEventEnd = uvmEnd;
        }
    }

    public long getTotalDurationTimeWithoutOverlap() {
        return this.totalDurationWithoutOverlap + (this.lastEventEnd - this.lastEventStart);
    }

    private int getTimePercent() {
        long time = this.getTotalDurationTimeWithoutOverlap();
        int percent = (int)((double)time / (double)this.getDuration() * 100.0);
        return percent;
    }

    private int getCPUFaultsPerSecondPercent() {
        double faultPerSec = (double)(this.getCounterValue() * 1000000000L) / (double)this.getDuration();
        if (faultPerSec >= (double)MAX_CPU_FAULTS_PER_SECOND) {
            return 100;
        }
        return (int)(faultPerSec * 100.0 / (double)MAX_CPU_FAULTS_PER_SECOND);
    }

    private int getHeatMapValue() {
        if (this.kind.equals((Object)TimelineIntervalKind.UVM_PAGE_FAULT)) {
            return this.getCPUFaultsPerSecondPercent();
        }
        return this.getTimePercent();
    }

    public String getLegendTitle() {
        if (this.isSegmented) {
            switch (this.kind) {
                case UVM_GPU_PAGE_FAULT: {
                    return "The time taken to resolve GPU page faults within the segment";
                }
                case UVM_PAGE_FAULT: {
                    return "The number of CPU page faults per second within the segment";
                }
                case UVM_MEMCPY_HTOD: {
                    return "The time taken for data migrations from host to device within the segment";
                }
                case UVM_MEMCPY_DTOH: {
                    return "The time taken for data migrations from device to host within the segment";
                }
                case UVM_MEMCPY_DTOD: {
                    return "The time taken for data migrations from device to device within the segment";
                }
                case UVM_PAGE_THROTTLING: {
                    return "The time taken for throttling within the segment";
                }
                case UVM_REMOTE_MAP: {
                    return "The time taken for remote mapping within the segment";
                }
                case UVM_THRASHING: {
                    return "The time taken for thrashing within the segment";
                }
            }
            return "The time taken for the Unified Memory event within the segment";
        }
        return null;
    }

    public String getTitle() {
        if (this.isSegmented) {
            switch (this.kind) {
                case UVM_GPU_PAGE_FAULT: {
                    return "Duration of GPU page faults";
                }
                case UVM_PAGE_FAULT: {
                    return "The number of CPU page faults";
                }
                case UVM_MEMCPY_HTOD: {
                    return "Duration of HtoD data migrations";
                }
                case UVM_MEMCPY_DTOH: {
                    return "Duration of DtoH data migrations";
                }
                case UVM_MEMCPY_DTOD: {
                    return "Duration of DtoD migrations";
                }
                case UVM_PAGE_THROTTLING: {
                    return "Duration of Page throttles";
                }
                case UVM_REMOTE_MAP: {
                    return "Duration of Remote map";
                }
                case UVM_THRASHING: {
                    return "Duration of Thrashing";
                }
            }
            return "Duration of Unified Memory event";
        }
        return null;
    }

    private SourceLocation getSourceLocation(long pc) {
        Executable exe = this.getPrimaryTimeline().getSession().getExecutable();
        if (exe != null) {
            return SourceLocation.getSourceLocation(exe, pc);
        }
        return null;
    }

    public SourceLocation getSourceLocation() {
        if (this.sourceLocation == null) {
            this.sourceLocation = this.getSourceLocation(this.getCounterValue());
        }
        return this.sourceLocation;
    }

    public SourceLocation getAllocLocation() {
        if (this.allocLocation == null) {
            if (this.memoryActivity == null) {
                return null;
            }
            this.allocLocation = this.getSourceLocation(this.memoryActivity.allocPC);
        }
        return this.allocLocation;
    }

    public SourceLocation getFreeLocation() {
        if (this.freeLocation == null) {
            if (this.memoryActivity == null) {
                return null;
            }
            this.freeLocation = this.getSourceLocation(this.memoryActivity.freePC);
        }
        return this.freeLocation;
    }

    public String getFilePath() {
        SourceLocation loc = this.getSourceLocation();
        return loc == null ? null : loc.getFilePath();
    }

    public String getFileName() {
        SourceLocation loc = this.getSourceLocation();
        return loc == null ? null : loc.getFileName();
    }

    public String getFuncName() {
        SourceLocation loc = this.getSourceLocation();
        return loc == null ? null : loc.getFuncName();
    }

    public int getLineNumber() {
        SourceLocation loc = this.getSourceLocation();
        return loc == null ? null : Integer.valueOf(loc.getLineNumber());
    }

    public String getSourceLocationString() {
        SourceLocation loc = this.getSourceLocation();
        return loc == null ? null : loc.toString();
    }

    public boolean isStartOnly() {
        return this.end == this.start;
    }

    public int getSrcId() {
        return this.srcId;
    }

    public int getDstId() {
        return this.dstId;
    }

    public List<Integer> getDeviceIdList() {
        return this.deviceIdList;
    }

    public boolean isCpu() {
        return this.isCpu;
    }

    public boolean hasAllocPC() {
        if (this.memoryActivity != null) {
            return this.memoryActivity.allocPC != 0L;
        }
        return false;
    }

    public boolean hasFreePC() {
        if (this.memoryActivity != null) {
            return this.memoryActivity.freePC != 0L;
        }
        return false;
    }

    public long getAllocPC() {
        if (this.memoryActivity != null) {
            return this.memoryActivity.allocPC;
        }
        return 0L;
    }

    public long getFreePC() {
        if (this.memoryActivity != null) {
            return this.memoryActivity.freePC;
        }
        return 0L;
    }

    public String getAllocTooltipString() {
        if (this.memoryActivity == null) {
            return "";
        }
        return this.memoryActivity.getAllocString();
    }

    public String getFreeTooltipString() {
        if (this.memoryActivity == null) {
            return "";
        }
        return this.memoryActivity.getFreeString();
    }

    public void computePC(Session session) {
        if (this.computedPC) {
            return;
        }
        UvmManager uvmManager = session.getUvmManager();
        long memorySize = 0L;
        switch (this.kind) {
            case UVM_MEMCPY_HTOD: 
            case UVM_MEMCPY_DTOH: 
            case UVM_MEMCPY_DTOD: 
            case UVM_THRASHING: 
            case UVM_REMOTE_MAP: {
                memorySize = this.value;
                break;
            }
        }
        List<CuptiActivityMemory> memoryActivities = uvmManager.getMemoryActivity(this.start, this.end, this.address, memorySize);
        this.memoryActivity = memoryActivities.get(0);
        this.computedPC = true;
    }

    public void setId(long id) {
        if (this.isSegmented) {
            this.id = id;
        }
    }
}

