/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.RulerColumnBase;
import java.text.DecimalFormat;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class DivergentBranchColumn
extends RulerColumnBase {
    public static final int DEFAULT_WIDTH = 110;
    private static final int BAR_HMARGIN = 5;
    private static final int BAR_VMARGIN = 2;
    public static final String COLUMN_HEADER = "Divergent Branch";
    private static Color DIVERGENT_COLOR = new Color(null, new RGB(255, 128, 128));

    public DivergentBranchColumn() {
        this(110);
    }

    public DivergentBranchColumn(int width) {
        this.setWidth(width);
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
        if (this.viewer != null && this.viewer.getDivergeInstExecuted(widgetLine) > 0L) {
            int barBorderY = linePixel + 2;
            int maxWidth = this.getWidth() - 10;
            int height = lineHeight - 4;
            int barWidth = this.getRelativeWidth(widgetLine, maxWidth);
            if (barWidth > 0) {
                gc.setBackground(DIVERGENT_COLOR);
                gc.fillRectangle(5, barBorderY, barWidth, height);
            }
            gc.setForeground(ViperColors.COLOR_EXEC_COUNT_BACKGROUND);
            gc.drawRectangle(5, barBorderY, maxWidth, height);
            this.drawMarkerAtEnd(widgetLine, gc, this.viewer, this.getWidth() - 1, lineHeight + linePixel, this.getWidth() - 1, barBorderY);
        }
    }

    private int getRelativeWidth(int widgetLine, int maxWidth) {
        return (int)((double)this.viewer.getNumDivergedBranch(widgetLine) * (double)maxWidth / (double)this.viewer.getMaxDivergentBranch());
    }

    @Override
    protected void updateColumn() {
        this.redraw();
    }

    @Override
    public int getColumnIndex() {
        return 2;
    }

    @Override
    protected String getToolTipText(int lineNumber) {
        DecimalFormat oneDecimalPrecision = new DecimalFormat("###.#");
        String tooltipFormat = "Divergence = %s%% [%d divergent executions out of %d total executions\n";
        long instructionExecuted = this.viewer.getDivergeInstExecuted(lineNumber);
        if (instructionExecuted > 0L) {
            long divergentBranch = this.viewer.getNumDivergedBranch(lineNumber);
            double divergence = (double)divergentBranch * 100.0 / (double)instructionExecuted;
            String percent = oneDecimalPrecision.format(divergence);
            return String.format(tooltipFormat, percent, divergentBranch, instructionExecuted);
        }
        return null;
    }

    @Override
    protected boolean isHotspotPresent() {
        return AnalysisResultSourceLevelKind.DIVERGENT_EXECUTION_KIND.equals((Object)this.viewer.getCurrentAnnotationKind());
    }
}

