/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.MetricManager;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultGlobalMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultSharedMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.AnalysisUtils;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import java.util.List;
import java.util.Set;

public class KernelMemoryAnalysis
extends AnalysisBase {
    private static final double BAD_GLD_EFFICIENCY = 75.0;
    private static final double BAD_GST_EFFICIENCY = 75.0;
    private static final double BAD_SHARED_EFFICIENCY = 75.0;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = true;
        if (session.getTimelines().isEmpty()) {
            results.add(new AnalysisResult(AnalysisDescriptor.KERNELMEMORY_NO_TIMELINE));
            ret = false;
        } else {
            List<Timeline> deviceTimelines = session.getTimelines(TimelineKind.DEVICE);
            if (deviceTimelines.isEmpty()) {
                results.add(new AnalysisResult(AnalysisDescriptor.KERNELMEMORY_NO_DEVICE));
            } else {
                if (generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELMEMORY_NO_TIMELINE));
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELMEMORY_NO_DEVICE));
                }
                boolean retGlobal = this.runGlobalMemoryAnalysis(session, results, deviceTimelines, generateAllResults);
                boolean retShared = this.runSharedMemoryAnalysis(session, results, deviceTimelines, generateAllResults);
                ret = ret && retGlobal && retShared;
            }
        }
        return ret;
    }

    protected boolean runGlobalMemoryAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        boolean ret = true;
        AnalysisResultGlobalMemoryEfficiency goodGldEfficiency = new AnalysisResultGlobalMemoryEfficiency(session, AnalysisDescriptor.KERNELMEMORY_GLD_EFFICIENCY_GOOD, true);
        AnalysisResultGlobalMemoryEfficiency badGldEfficiency = new AnalysisResultGlobalMemoryEfficiency(session, AnalysisDescriptor.KERNELMEMORY_GLD_EFFICIENCY_BAD, true);
        AnalysisResultIntervalNoData noDataGldEfficiency = new AnalysisResultIntervalNoData(session, AnalysisDescriptor.KERNELMEMORY_GLD_EFFICIENCY_NO_DATA);
        AnalysisResultGlobalMemoryEfficiency goodGstEfficiency = new AnalysisResultGlobalMemoryEfficiency(session, AnalysisDescriptor.KERNELMEMORY_GST_EFFICIENCY_GOOD, false);
        AnalysisResultGlobalMemoryEfficiency badGstEfficiency = new AnalysisResultGlobalMemoryEfficiency(session, AnalysisDescriptor.KERNELMEMORY_GST_EFFICIENCY_BAD, false);
        AnalysisResultIntervalNoData noDataGstEfficiency = new AnalysisResultIntervalNoData(session, AnalysisDescriptor.KERNELMEMORY_GST_EFFICIENCY_NO_DATA);
        long totalKernelTime = 0L;
        Set<Metric> gldEffMetrics = MetricManager.getMetrics("gld_efficiency");
        Set<Metric> gstEffMetrics = MetricManager.getMetrics("gst_efficiency");
        for (Timeline deviceTimeline : deviceTimelines) {
            Metric gldEfficiencyMetric = null;
            Metric gstEfficiencyMetric = null;
            List<Timeline> kernelTimelines = deviceTimeline.getDescendants(TimelineKind.KERNEL);
            for (Timeline timeline : kernelTimelines) {
                TimelineKernel kernelTimeline = (TimelineKernel)timeline;
                for (ITimelineInterval interval : kernelTimeline.getIntervals(true)) {
                    Number gstEfficiencyNumber;
                    Number gldEfficiencyNumber;
                    TimelineIntervalKernel kernel = AnalysisStage.getHostLaunchedKernel(interval);
                    if (kernel == null) continue;
                    totalKernelTime += kernel.getDuration();
                    if (gldEfficiencyMetric == null) {
                        gldEfficiencyMetric = AnalysisUtils.getSingleIntersect(gldEffMetrics, kernel.getAggregateMetrics());
                    }
                    if (gstEfficiencyMetric == null) {
                        gstEfficiencyMetric = AnalysisUtils.getSingleIntersect(gstEffMetrics, kernel.getAggregateMetrics());
                    }
                    Number number = gldEfficiencyNumber = gldEfficiencyMetric == null ? (Number)null : (Number)kernel.getAggregateMetricValue(gldEfficiencyMetric);
                    if (gldEfficiencyNumber == null) {
                        noDataGldEfficiency.addInterval(kernel, null);
                        ret = false;
                    } else {
                        double gldEfficiency = gldEfficiencyNumber.doubleValue();
                        if (gldEfficiency != 0.0 && gldEfficiency <= 75.0) {
                            badGldEfficiency.addInterval(kernel, gldEfficiency);
                        } else {
                            goodGldEfficiency.addInterval(kernel, gldEfficiency);
                        }
                    }
                    Number number2 = gstEfficiencyNumber = gstEfficiencyMetric == null ? (Number)null : (Number)kernel.getAggregateMetricValue(gstEfficiencyMetric);
                    if (gstEfficiencyNumber == null) {
                        noDataGstEfficiency.addInterval(kernel, null);
                        ret = false;
                        continue;
                    }
                    double gstEfficiency = gstEfficiencyNumber.doubleValue();
                    if (gstEfficiency != 0.0 && gstEfficiency <= 75.0) {
                        badGstEfficiency.addInterval(kernel, gstEfficiency);
                        continue;
                    }
                    goodGstEfficiency.addInterval(kernel, gstEfficiency);
                }
            }
        }
        badGldEfficiency.setTotalKernelTime(totalKernelTime);
        goodGldEfficiency.setTotalKernelTime(totalKernelTime);
        badGstEfficiency.setTotalKernelTime(totalKernelTime);
        goodGstEfficiency.setTotalKernelTime(totalKernelTime);
        if (noDataGldEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(noDataGldEfficiency);
        }
        if (badGldEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(badGldEfficiency);
        }
        if (goodGldEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(goodGldEfficiency);
        }
        if (noDataGstEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(noDataGstEfficiency);
        }
        if (badGstEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(badGstEfficiency);
        }
        if (goodGstEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(goodGstEfficiency);
        }
        return ret;
    }

    protected boolean runSharedMemoryAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        boolean ret = true;
        AnalysisResultSharedMemoryEfficiency goodEfficiency = new AnalysisResultSharedMemoryEfficiency(session, AnalysisDescriptor.KERNELMEMORY_SHARED_EFFICIENCY_GOOD);
        AnalysisResultSharedMemoryEfficiency badEfficiency = new AnalysisResultSharedMemoryEfficiency(session, AnalysisDescriptor.KERNELMEMORY_SHARED_EFFICIENCY_BAD);
        AnalysisResultIntervalNoData noDataEfficiency = new AnalysisResultIntervalNoData(session, AnalysisDescriptor.KERNELMEMORY_SHARED_EFFICIENCY_NO_DATA);
        long totalKernelTime = 0L;
        Set<Metric> sharedEffMetrics = MetricManager.getMetrics("shared_efficiency");
        for (Timeline deviceTimeline : deviceTimelines) {
            Metric sharedEfficiencyMetric = null;
            List<Timeline> kernelTimelines = deviceTimeline.getDescendants(TimelineKind.KERNEL);
            for (Timeline timeline : kernelTimelines) {
                TimelineKernel kernelTimeline = (TimelineKernel)timeline;
                for (ITimelineInterval interval : kernelTimeline.getIntervals(true)) {
                    Number sharedEfficiencyNumber;
                    TimelineIntervalKernel kernel = AnalysisStage.getHostLaunchedKernel(interval);
                    if (kernel == null) continue;
                    totalKernelTime += kernel.getDuration();
                    if (sharedEfficiencyMetric == null) {
                        sharedEfficiencyMetric = AnalysisUtils.getSingleIntersect(sharedEffMetrics, kernel.getAggregateMetrics());
                    }
                    Number number = sharedEfficiencyNumber = sharedEfficiencyMetric == null ? (Number)null : (Number)kernel.getAggregateMetricValue(sharedEfficiencyMetric);
                    if (sharedEfficiencyNumber == null) {
                        noDataEfficiency.addInterval(kernel, null);
                        ret = false;
                        continue;
                    }
                    double sharedEfficiency = sharedEfficiencyNumber.doubleValue();
                    if (sharedEfficiency != 0.0 && sharedEfficiency <= 75.0) {
                        badEfficiency.addInterval(kernel, sharedEfficiency);
                        continue;
                    }
                    goodEfficiency.addInterval(kernel, sharedEfficiency);
                }
            }
        }
        badEfficiency.setTotalKernelTime(totalKernelTime);
        goodEfficiency.setTotalKernelTime(totalKernelTime);
        if (noDataEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(noDataEfficiency);
        }
        if (badEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(badEfficiency);
        }
        if (goodEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(goodEfficiency);
        }
        return ret;
    }
}

