/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivitySharedAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.analysis.SourceLevelResultGraphicFactory;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;

public class AnalysisResultSharedAccess
extends AnalysisResultSourceLevel {
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private static final double BAD_COALESCE = 1.2;
    private Set<ICuptiActivitySourceLevelResult> markerResults = new HashSet<ICuptiActivitySourceLevelResult>();

    static {
        numberFormatter.setMaximumFractionDigits(1);
        numberFormatter.setGroupingUsed(false);
    }

    public AnalysisResultSharedAccess(Session session, TimelineIntervalKernel kernel, AnalysisDescriptor desc) {
        super(session, kernel, desc);
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new SourceLevelResultGraphicFactory();
    }

    @Override
    public String getResultDescription(ICuptiActivitySourceLevelResult result) {
        if (result instanceof CuptiActivitySharedAccess) {
            CuptiActivitySharedAccess sa = (CuptiActivitySharedAccess)result;
            double trans = (double)sa.sharedTransactions / (double)sa.executed;
            double idealTrans = (double)sa.theoreticalSharedTransactions / (double)sa.executed;
            String lsStr = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD.isSet(((CuptiActivitySharedAccess)result).flags) ? "Shared Load" : "Shared Store";
            return String.valueOf(lsStr) + " Transactions/Access = " + numberFormatter.format(trans) + ", Ideal Transactions/Access = " + numberFormatter.format(idealTrans) + " [ " + sa.sharedTransactions + " transactions for " + sa.executed + " total executions ]";
        }
        return super.getResultDescription(result);
    }

    @Override
    public boolean addResult(ICuptiActivitySourceLevelResult slr) {
        if (slr instanceof CuptiActivitySharedAccess) {
            CuptiActivitySharedAccess slrSharedAccess = (CuptiActivitySharedAccess)slr;
            if (this.isBadAccess(slrSharedAccess)) {
                this.addMarkers(slrSharedAccess);
                this.markerResults.add(slrSharedAccess);
            }
            if (super.addResult(slrSharedAccess)) {
                return true;
            }
        }
        return false;
    }

    private boolean isBadAccess(CuptiActivitySharedAccess sa) {
        return !sa.isNullResult() && (double)sa.sharedTransactions / (double)sa.theoreticalSharedTransactions >= 1.2;
    }

    @Override
    public Action getMoreAction() {
        return new MoreAction();
    }

    @Override
    public AnalysisResultSourceLevelKind getAnalysisResultSourceLevelKind() {
        return AnalysisResultSourceLevelKind.SHARED_ACCESS_KIND;
    }

    @Override
    public Set<ICuptiActivitySourceLevelResult> getMarkerSourceLevelResults() {
        return Collections.unmodifiableSet(this.markerResults);
    }

    private class MoreAction
    extends Action {
        private MoreAction() {
        }

        public void run() {
            ViperHelp.displayHelp(ViperHelp.SHARED_BANKS);
        }
    }
}

