/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public class CuptiActivityMarker
extends CuptiActivityBase
implements ICuptiActivity {
    public int flags;
    public int id;
    public long timestamp;
    public int objectKind;
    public int objectProcessId;
    public int objectThreadId;
    public int objectDeviceId;
    public int objectContextId;
    public int objectStreamId;
    public String domain;
    public String name;

    public CuptiActivityMarker() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.timestamp > 0L;
    }

    public CuptiActivityObjectKind getObjectKind() {
        return CuptiActivityObjectKind.valueOf(this.objectKind);
    }

    public String getDomainName() {
        if (this.domain == null) {
            return "Default Domain";
        }
        return "Domain " + this.domain;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }
}

