/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.util.ISourceIntegration;
import com.nvidia.cuda.ide.util.ISourceMarker;
import com.nvidia.viper.Activator;
import com.nvidia.viper.IViperWorkbench;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.analysis.AnalysisSourceMarker;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.FileSystemException;
import com.nvidia.viper.jni.CCFFMessage;
import com.nvidia.viper.model.Session;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.console.ConsoleView;

public class ViewUtils {
    public static void showConsoleInDisplayThread() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage activePage = ViewUtils.getActivePage();
                    if (activePage != null) {
                        activePage.showView(ViewUtils.getConsoleViewID());
                    }
                }
                catch (PartInitException partInitException) {
                    ViperExceptionHandler.logError("unable to show console view");
                }
            }
        });
    }

    public static final ConsoleView findConsoleInDisplayThread() {
        final ArrayList viewPart = new ArrayList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = ViewUtils.getActivePage();
                if (activePage != null) {
                    viewPart.add(activePage.findView(ViewUtils.getConsoleViewID()));
                }
            }
        });
        if (!viewPart.isEmpty()) {
            return (ConsoleView)CoreUtil.safeCast(viewPart.get(0), ConsoleView.class);
        }
        return null;
    }

    public static void showAnalysisView() {
        try {
            IWorkbenchPage activePage = ViewUtils.getActivePage();
            if (activePage != null) {
                activePage.showView("com.nvidia.viper.openmpview");
                activePage.showView("com.nvidia.viper.openaccview");
                activePage.showView("com.nvidia.viper.cpuview");
                activePage.showView("com.nvidia.viper.analysisview");
            }
        }
        catch (PartInitException partInitException) {
            ViperExceptionHandler.logError("unable to show analysis view");
        }
    }

    private static String getConsoleViewID() {
        IViperWorkbench viperWorkbench = Activator.getDefault().getViperWorkbench();
        return viperWorkbench != null ? viperWorkbench.getConsoleViewID() : "org.eclipse.ui.console.ConsoleView";
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench != null ? workbench.getActiveWorkbenchWindow() : null;
        return workbenchWindow != null ? workbenchWindow.getActivePage() : null;
    }

    public static void openSourceView(Session session, Shell shell, String filename, String fullPath, int lineNo) {
        ISourceIntegration sourceIntegration = Activator.getDefault().getSourceIntegration();
        URI sourceUri = URIUtil.toURI((String)fullPath);
        if (ViewUtils.tryPath(session, sourceUri)) {
            try {
                ViewUtils.openEditor(session, filename, lineNo, sourceIntegration, sourceUri);
            }
            catch (CoreException coreException) {
                return;
            }
        }
        try {
            while (true) {
                URI foundPathUri;
                if ((foundPathUri = ViewUtils.findUri(session, filename, fullPath)) != null) {
                    ViewUtils.openEditor(session, filename, lineNo, sourceIntegration, foundPathUri);
                } else {
                    String newBaseDir = ViewUtils.askForSourceFilePath(session, shell, filename);
                    if (newBaseDir != null) {
                        session.setCpuSourceBaseDir(newBaseDir);
                        continue;
                    }
                }
                break;
            }
        }
        catch (CoreException coreException) {}
    }

    public static void addMarker(Session session, String filename, String fullPath, int lineNumber, String desc) {
        ISourceIntegration sourceIntegration = Activator.getDefault().getSourceIntegration();
        try {
            URI sourceURI = ViewUtils.findUri(session, filename, fullPath);
            sourceIntegration.addMarkers(null, new ISourceMarker[]{new AnalysisSourceMarker(session, sourceURI, lineNumber, desc)});
        }
        catch (CoreException coreException) {}
    }

    private static URI findUri(Session session, String filename, String fullPath) {
        URI relativeUri = URIUtil.toURI((IPath)session.getCpuSourceBaseDir().append(filename));
        URI fullUri = URIUtil.toURI((IPath)session.getCpuSourceBaseDir().append(fullPath));
        URI absoluteUri = URIUtil.toURI((String)fullPath);
        if (ViewUtils.tryPath(session, relativeUri)) {
            return relativeUri;
        }
        if (ViewUtils.tryPath(session, fullUri)) {
            return fullUri;
        }
        if (ViewUtils.tryPath(session, absoluteUri)) {
            return absoluteUri;
        }
        return null;
    }

    private static void openEditor(Session session, String filename, int lineNo, ISourceIntegration sourceIntegration, URI sourceUri) throws CoreException {
        CCFFMessage.addMarkers(session, sourceIntegration, sourceUri, filename);
        if (lineNo >= 0) {
            AnalysisSourceMarker currentLine = new AnalysisSourceMarker(session, sourceUri, lineNo, null);
            sourceIntegration.addMarkers(null, new ISourceMarker[]{currentLine});
            sourceIntegration.openEditor((ISourceMarker)currentLine);
            sourceIntegration.removeMarkers(null, new ISourceMarker[]{currentLine});
        } else {
            sourceIntegration.openEditor(sourceUri);
        }
    }

    private static boolean tryPath(Session session, URI sourceUri) {
        boolean fileFound = false;
        try {
            fileFound = FileSystem.getFilesystem(session).isExistingFile(sourceUri.getPath());
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
        return fileFound;
    }

    private static String askForSourceFilePath(Session session, Shell shell, String fileName) {
        String basedir;
        try {
            basedir = FileSystem.getFilesystem(session).browseForDirectory(shell, "Select Source Directory", "Could not find source file '" + fileName + "' in directory '" + session.getCpuSourceBaseDir().toString() + "'. Please select the base directory for the source files.", session.getCpuSourceBaseDir().toString());
        }
        catch (ConnectionNotFoundException | CoreException throwable) {
            return null;
        }
        return basedir;
    }
}

