/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.ccvs.core.mapping.CVSActiveChangeSetCollector;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.PlatformUI;

public class CommitAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final ResourceTraversal[][] traversals = new ResourceTraversal[1][];
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(CVSUIMessages.CommitAction_0, 100);
                        traversals[0] = CommitAction.this.getTraversals(Policy.subMonitorFor(monitor, 80));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    CommitWizard.run(CommitAction.this.getTargetPart(), CommitAction.this.getShell(), traversals[0]);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, false, 2);
    }

    protected String getErrorTitle() {
        return CVSUIMessages.CommitAction_commitFailed;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }

    public String getId() {
        return "org.eclipse.team.cvs.ui.commit";
    }

    protected SynchronizationScopeManager getScopeManager() {
        return new CommitScopeManager(this.getCVSResourceMappings(), this.getResourceMappingContext(), true);
    }

    public static boolean isIncludeChangeSets(final Shell shell, final String message) {
        if (CVSUIPlugin.getPlugin().getChangeSetManager().getSets().length == 0) {
            return false;
        }
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("pref_include_change_sets");
        if (option.equals("always")) {
            return true;
        }
        if (option.equals("never")) {
            return false;
        }
        final int[] result = new int[1];
        Utils.syncExec((Runnable)new Runnable(){

            public void run() {
                MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)CVSUIMessages.CommitAction_1, (String)message, (String)CVSUIMessages.ShowAnnotationOperation_4, (boolean)false, (IPreferenceStore)store, (String)"pref_include_change_sets");
                result[0] = m.getReturnCode();
            }
        }, (Control)shell);
        switch (result[0]) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    private final class CommitScopeManager
    extends SynchronizationScopeManager {
        private boolean includeChangeSets;

        private CommitScopeManager(ResourceMapping[] mappings, ResourceMappingContext context, boolean models) {
            super("", mappings, context, models);
            this.includeChangeSets = CommitAction.isIncludeChangeSets(CommitAction.this.getShell(), CVSUIMessages.CommitAction_2);
        }

        protected ResourceTraversal[] adjustInputTraversals(ResourceTraversal[] traversals) {
            if (this.includeChangeSets) {
                return ((CVSActiveChangeSetCollector)CVSUIPlugin.getPlugin().getChangeSetManager()).adjustInputTraversals(traversals);
            }
            return super.adjustInputTraversals(traversals);
        }
    }
}

