/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools.doxygen;

import java.util.LinkedHashSet;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.ui.text.doctools.DefaultMultilineCommentAutoEditStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class DoxygenMultilineAutoEditStrategy
extends DefaultMultilineCommentAutoEditStrategy {
    private static final String SINGLELINE_COMMENT_PRECEDING = "//!< ";
    private static final String PARAM = "@param ";
    private static final String RETURN = "@return";
    protected boolean documentPureVirtuals = true;
    protected boolean documentDeclarations = true;
    private String fLineDelimiter;

    protected StringBuilder documentFunction(IASTFunctionDeclarator decl, IASTDeclSpecifier ds) {
        IASTSimpleDeclSpecifier sds;
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)this.documentFunctionParameters(this.getParameterDecls(decl)));
        boolean hasReturn = true;
        if (ds instanceof IASTSimpleDeclSpecifier && ((sds = (IASTSimpleDeclSpecifier)ds).getType() == 1 || sds.getType() == 0)) {
            hasReturn = false;
        }
        if (hasReturn) {
            result.append((CharSequence)this.documentFunctionReturn());
        }
        return result;
    }

    protected StringBuilder documentFunctionParameters(IASTParameterDeclaration[] decls) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < decls.length) {
            if (!this.isVoidParameter(decls[i])) {
                result.append(PARAM).append(this.getParameterName(decls[i])).append(this.getLineDelimiter());
            }
            ++i;
        }
        return result;
    }

    private String getLineDelimiter() {
        return this.fLineDelimiter;
    }

    String getParameterName(IASTParameterDeclaration decl) {
        IASTDeclarator dtor = decl.getDeclarator();
        int i = 0;
        while (i < 8 && dtor.getName().getRawSignature().length() == 0 && dtor.getNestedDeclarator() != null) {
            dtor = dtor.getNestedDeclarator();
            ++i;
        }
        return dtor.getName().getRawSignature();
    }

    boolean isVoidParameter(IASTParameterDeclaration decl) {
        IASTDeclarator dtor;
        return decl.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)decl.getDeclSpecifier()).getType() == 1 && (dtor = decl.getDeclarator()).getPointerOperators().length == 0 && !(dtor instanceof IASTFunctionDeclarator) && !(dtor instanceof IASTArrayDeclarator);
    }

    protected StringBuilder documentFunctionReturn() {
        return new StringBuilder(RETURN).append(this.getLineDelimiter());
    }

    protected IASTParameterDeclaration[] getParameterDecls(IASTFunctionDeclarator decl) {
        IASTParameterDeclaration[] result;
        if (decl instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator standardFunctionDecl = (IASTStandardFunctionDeclarator)decl;
            result = standardFunctionDecl.getParameters();
        } else {
            result = new IASTParameterDeclaration[]{};
        }
        return result;
    }

    @Override
    protected StringBuilder customizeAfterNewLineForDeclaration(IDocument doc, IASTDeclaration dec, ITypedRegion partition) {
        ICPPASTLinkageSpecification linkageSpecification;
        IASTDeclaration[] declarations;
        this.fLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        IASTDeclaration declToDocument = dec;
        if (declToDocument instanceof ICPPASTLinkageSpecification && (declarations = (linkageSpecification = (ICPPASTLinkageSpecification)declToDocument).getDeclarations()).length == 1) {
            boolean isCurlyExtern = false;
            IToken token = null;
            try {
                token = declarations[0].getTrailingSyntax();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return new StringBuilder();
            }
            catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
                return new StringBuilder();
            }
            if (token != null && token.getType() == 13) {
                isCurlyExtern = true;
            }
            if (!isCurlyExtern) {
                declToDocument = declarations[0];
            }
        }
        while (declToDocument instanceof ICPPASTTemplateDeclaration) {
            declToDocument = ((ICPPASTTemplateDeclaration)declToDocument).getDeclaration();
        }
        if (declToDocument instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fd = (IASTFunctionDefinition)declToDocument;
            return this.documentFunction(fd.getDeclarator(), fd.getDeclSpecifier());
        }
        if (declToDocument instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdec = (IASTSimpleDeclaration)declToDocument;
            StringBuilder result = new StringBuilder();
            if (sdec.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                return result;
            }
            IASTDeclarator[] dcs = sdec.getDeclarators();
            if (dcs.length == 1 && dcs[0] instanceof IASTFunctionDeclarator) {
                IASTFunctionDeclarator fdecl = (IASTFunctionDeclarator)dcs[0];
                boolean shouldDocument = this.documentDeclarations;
                if (this.documentPureVirtuals && dcs[0] instanceof ICPPASTFunctionDeclarator) {
                    ICPPASTFunctionDeclarator cppfdecl = (ICPPASTFunctionDeclarator)dcs[0];
                    boolean bl = shouldDocument = shouldDocument || cppfdecl.isPureVirtual();
                }
                if (shouldDocument) {
                    return this.documentFunction(fdecl, sdec.getDeclSpecifier());
                }
            }
        }
        try {
            this.alterDoc(doc, declToDocument);
        }
        catch (BadLocationException badLocationException) {}
        return new StringBuilder();
    }

    private void alterDoc(IDocument doc, IASTDeclaration dec) throws BadLocationException {
        if (dec instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)dec).getDeclSpecifier() instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier spc = (IASTEnumerationSpecifier)((IASTSimpleDeclaration)dec).getDeclSpecifier();
            IASTEnumerationSpecifier.IASTEnumerator[] enms = spc.getEnumerators();
            boolean noCollisions = true;
            class Entry {
                final int offset;
                final int length;
                StringBuilder comment;

                Entry(int offset, int length, String comment) {
                    this.offset = offset;
                    this.length = length;
                    this.comment = new StringBuilder(comment);
                }

                public int hashCode() {
                    return this.offset;
                }

                public boolean equals(Object obj) {
                    if (obj instanceof Entry) {
                        Entry other = (Entry)obj;
                        return this.offset == other.offset;
                    }
                    return false;
                }
            }
            LinkedHashSet<Entry> entries = new LinkedHashSet<Entry>();
            IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = enms;
            int n = enms.length;
            int n2 = 0;
            while (n2 < n) {
                IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n2];
                IASTFileLocation loc = enumerator.getName().getFileLocation();
                if (loc != null) {
                    int nodeOffset = loc.getNodeOffset() + loc.getNodeLength();
                    String cmt = SINGLELINE_COMMENT_PRECEDING + enumerator.getName();
                    IRegion line = doc.getLineInformationOfOffset(nodeOffset);
                    if (!doc.get(line.getOffset(), line.getLength()).contains("//")) {
                        noCollisions &= entries.add(new Entry(line.getOffset(), line.getLength(), cmt));
                    }
                }
                ++n2;
            }
            if (noCollisions) {
                int max = Integer.MIN_VALUE;
                for (Entry e : entries) {
                    if (e.length <= max) continue;
                    max = e.length;
                }
                int addedLength = 0;
                for (Entry e : entries) {
                    int toAdd = max - e.length;
                    int j = 0;
                    while (j < toAdd) {
                        e.comment.insert(0, " ");
                        ++j;
                    }
                    doc.replace(e.offset + e.length + addedLength, 0, e.comment.toString());
                    addedLength += e.comment.length();
                }
            }
        }
    }
}

