/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MachOBinaryParserPage
extends AbstractCOptionPage {
    public static final String PREF_CPPFILT_PATH = "org.eclipse.cdt.ui.cppfilt";
    protected Text fCPPFiltCommandText;

    @Override
    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String cppfilt = this.fCPPFiltCommandText.getText().trim();
        monitor.beginTask(CUIMessages.BinaryParserPage_task_savingAttributes, 1);
        IProject proj = this.getContainer().getProject();
        if (proj != null) {
            ICConfigurationDescription cfgDesc;
            String parserID = "";
            ICConfigExtensionReference[] cext = null;
            ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(proj, true);
            if (desc != null && (cfgDesc = desc.getDefaultSettingConfiguration()) != null) {
                cext = cfgDesc.get("org.eclipse.cdt.core.BinaryParser");
            }
            if (cext != null && cext.length > 0) {
                IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "BinaryParserPage");
                IConfigurationElement[] infos = point.getConfigurationElements();
                int i = 0;
                while (i < infos.length) {
                    String id = infos[i].getAttribute("parserID");
                    String clazz = infos[i].getAttribute("class");
                    String ego = this.getRealBinaryParserPage().getClass().getName();
                    if (clazz != null && clazz.equals(ego)) {
                        parserID = id;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < cext.length) {
                    String orig;
                    if (cext[i].getID().equals(parserID) && ((orig = cext[i].getExtensionData("c++filt")) == null || !orig.equals(cppfilt))) {
                        cext[i].setExtensionData("c++filt", cppfilt);
                    }
                    ++i;
                }
                CCorePlugin.getDefault().setProjectDescription(proj, desc);
            }
        } else {
            Preferences store = this.getContainer().getPreferences();
            if (store != null) {
                store.setValue(PREF_CPPFILT_PATH, cppfilt);
            }
        }
    }

    protected Object getRealBinaryParserPage() {
        return this;
    }

    @Override
    public void performDefaults() {
        String cppfilt = null;
        IProject proj = this.getContainer().getProject();
        Preferences store = this.getContainer().getPreferences();
        if (store != null) {
            cppfilt = proj != null ? store.getString(PREF_CPPFILT_PATH) : store.getDefaultString(PREF_CPPFILT_PATH);
            this.fCPPFiltCommandText.setText(cppfilt == null || cppfilt.length() == 0 ? "c++filt" : cppfilt);
        }
    }

    @Override
    public void createControl(Composite parent) {
        Group comp = new Group(parent, 16);
        comp.setText(CUIMessages.BinaryParserBlock_binaryParserOptions);
        comp.setLayout((Layout)new GridLayout(2, true));
        comp.setLayoutData((Object)new GridData(768));
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)comp, CUIMessages.BinaryParserPage_label_cppfiltCommand);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fCPPFiltCommandText = ControlFactory.createTextField((Composite)comp, 2052);
        gd = new GridData(768);
        this.fCPPFiltCommandText.setLayoutData((Object)gd);
        this.fCPPFiltCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        Button button = ControlFactory.createPushButton((Composite)comp, CUIMessages.BinaryParserPage_label_browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleCPPFiltButtonSelected();
            }

            private void handleCPPFiltButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(MachOBinaryParserPage.this.getShell(), 0);
                dialog.setText(CUIMessages.BinaryParserPage_label_cppfiltCommand);
                String command = MachOBinaryParserPage.this.fCPPFiltCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                MachOBinaryParserPage.this.fCPPFiltCommandText.setText(res);
            }
        });
        this.setControl((Control)comp);
        this.initialziedValues();
    }

    private void initialziedValues() {
        String cppfilt = null;
        IProject proj = this.getContainer().getProject();
        if (proj != null) {
            try {
                ICConfigExtensionReference[] cext = CCorePlugin.getDefault().getDefaultBinaryParserExtensions(proj);
                if (cext.length > 0) {
                    cppfilt = cext[0].getExtensionData("c++filt");
                }
            }
            catch (CoreException coreException) {}
        } else {
            Preferences store = this.getContainer().getPreferences();
            if (store != null) {
                cppfilt = store.getString(PREF_CPPFILT_PATH);
            }
        }
        this.fCPPFiltCommandText.setText(cppfilt == null || cppfilt.length() == 0 ? "c++filt" : cppfilt);
    }
}

