/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private ITextEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.OpenTypeHierarchyAction_label);
        this.setToolTipText(Messages.OpenTypeHierarchyAction_tooltip);
    }

    public OpenTypeHierarchyAction(ITextEditor editor) {
        this((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput()) != null);
    }

    @Override
    public void run(ITextSelection sel) {
        TypeHierarchyUI.open(this.fEditor, sel);
    }

    @Override
    public void run(IStructuredSelection selection) {
        Object selectedObject;
        ICElement elem;
        if (!selection.isEmpty() && (elem = (ICElement)this.getAdapter(selectedObject = selection.getFirstElement(), ICElement.class)) != null) {
            TypeHierarchyUI.open(elem, this.getSite().getWorkbenchWindow());
        }
    }

    @Override
    public void selectionChanged(ITextSelection sel) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        Object selectedObject = selection.getFirstElement();
        ICElement elem = (ICElement)this.getAdapter(selectedObject, ICElement.class);
        if (elem != null) {
            this.setEnabled(TypeHierarchyUI.isValidInput(elem));
        } else {
            this.setEnabled(false);
        }
    }

    private Object getAdapter(Object object, Class desiredClass) {
        if (desiredClass.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            return adaptable.getAdapter(desiredClass);
        }
        return null;
    }
}

