/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.internal.ui.text.spelling.CSpellingProblem;
import org.eclipse.cdt.internal.ui.text.spelling.CSpellingService;
import org.eclipse.cdt.internal.ui.text.spelling.CoreSpellingProblem;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class CSpellingReconcileStrategy
extends SpellingReconcileStrategy {
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private static final IContentType CXX_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cxxSource");
    private ITextEditor fEditor;
    private IProblemRequestor fRequestor;

    public CSpellingReconcileStrategy(ISourceViewer viewer, ITextEditor editor) {
        super(viewer, (SpellingService)CSpellingService.getInstance());
        this.fEditor = editor;
    }

    public void reconcile(IRegion region) {
        if (this.fRequestor != null && this.isSpellingEnabled()) {
            super.reconcile(region);
        }
    }

    private boolean isSpellingEnabled() {
        return EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        return new SpellingProblemCollector();
    }

    protected IContentType getContentType() {
        return CXX_CONTENT_TYPE;
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        this.updateProblemRequester();
    }

    private void updateProblemRequester() {
        IAnnotationModel model = this.getAnnotationModel();
        this.fRequestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
    }

    protected IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.fEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            IProblemRequestor requestor = CSpellingReconcileStrategy.this.fRequestor;
            if (requestor != null) {
                try {
                    IEditorInput editorInput;
                    int line = CSpellingReconcileStrategy.this.getDocument().getLineOfOffset(problem.getOffset()) + 1;
                    String word = CSpellingReconcileStrategy.this.getDocument().get(problem.getOffset(), problem.getLength());
                    boolean dictionaryMatch = false;
                    boolean sentenceStart = false;
                    if (problem instanceof CSpellingProblem) {
                        dictionaryMatch = ((CSpellingProblem)problem).isDictionaryMatch();
                        sentenceStart = ((CSpellingProblem)problem).isSentenceStart();
                    }
                    if ((editorInput = CSpellingReconcileStrategy.this.fEditor.getEditorInput()) != null) {
                        CoreSpellingProblem iProblem = new CoreSpellingProblem(problem.getOffset(), problem.getOffset() + problem.getLength() - 1, line, problem.getMessage(), word, dictionaryMatch, sentenceStart, CSpellingReconcileStrategy.this.getDocument(), editorInput.getName());
                        requestor.acceptProblem((IProblem)iProblem);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void beginCollecting() {
            if (CSpellingReconcileStrategy.this.fRequestor != null) {
                CSpellingReconcileStrategy.this.fRequestor.beginReporting();
            }
        }

        public void endCollecting() {
            if (CSpellingReconcileStrategy.this.fRequestor != null) {
                CSpellingReconcileStrategy.this.fRequestor.endReporting();
            }
        }
    }
}

