/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;

public final class BufferedDocumentScanner
implements ICharacterScanner {
    private IDocument fDocument;
    private int fRangeOffset;
    private int fRangeLength;
    private char[][] fDelimiters;
    private final char[] fBuffer;
    private int fBufferOffset;
    private int fBufferLength;
    private int fOffset;

    public BufferedDocumentScanner(int size) {
        Assert.isTrue((size >= 1 ? 1 : 0) != 0);
        this.fBuffer = new char[size];
    }

    private final void updateBuffer(int offset) {
        if (offset < 0) {
            offset = 0;
        }
        this.fBufferOffset = offset;
        this.fBufferLength = this.fBuffer.length;
        if (this.fBufferOffset + this.fBufferLength > this.fRangeOffset + this.fRangeLength) {
            this.fBufferLength = this.fRangeOffset + this.fRangeLength - this.fBufferOffset;
        }
        try {
            String content = this.fDocument.get(this.fBufferOffset, this.fBufferLength);
            content.getChars(0, this.fBufferLength, this.fBuffer, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    public final void setRange(IDocument document, int offset, int length) {
        this.fDocument = document;
        this.fRangeOffset = offset;
        this.fRangeLength = length;
        if (this.fRangeLength + this.fRangeOffset > this.fDocument.getLength()) {
            this.fRangeLength = this.fDocument.getLength() - this.fRangeOffset;
        }
        String[] delimiters = document.getLegalLineDelimiters();
        this.fDelimiters = new char[delimiters.length][];
        int i = 0;
        while (i < delimiters.length) {
            this.fDelimiters[i] = delimiters[i].toCharArray();
            ++i;
        }
        this.updateBuffer(offset);
        this.fOffset = 0;
    }

    public final int read() {
        if (this.fOffset >= this.fBufferLength) {
            if (this.fBufferOffset + this.fBufferLength >= this.fRangeOffset + this.fRangeLength) {
                return -1;
            }
            this.updateBuffer(this.fBufferOffset + this.fBufferLength);
            this.fOffset = 0;
        }
        return this.fBuffer[this.fOffset++];
    }

    public final void unread() {
        if (this.fOffset <= 0) {
            if (this.fBufferOffset > this.fRangeOffset) {
                this.updateBuffer(this.fBufferOffset - this.fBuffer.length);
                this.fOffset = this.fBuffer.length - 1;
            }
        } else {
            --this.fOffset;
        }
    }

    public final int getColumn() {
        try {
            int offset = this.fBufferOffset + this.fOffset;
            int line = this.fDocument.getLineOfOffset(offset);
            int start = this.fDocument.getLineOffset(line);
            return offset - start;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public final char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }
}

