/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.rewrite.DeclarationGenerator;
import org.eclipse.cdt.core.dom.rewrite.TypeHelper;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.core.runtime.Assert;

public class NameInformation {
    public static final int INDEX_FOR_ADDED = -1;
    private final IASTName name;
    private IASTName declarationName;
    private final List<IASTName> referencesInSelection;
    private boolean isOutput;
    private boolean mustBeReturnValue;
    private boolean isWriteAccess;
    private boolean passOutputByPointer;
    private boolean isReturnValue;
    private String newName;
    private int newOrder;
    private boolean isDeleted;
    private String defaultValue;
    private String newTypeName;
    private Indirection indirection;

    public NameInformation(IASTName name) {
        this.name = name;
        this.newName = String.valueOf(name.getSimpleID());
        this.referencesInSelection = new ArrayList<IASTName>();
    }

    public static NameInformation createInfoForAddedParameter(String type, String name, String defaultValue) {
        NameInformation info = new NameInformation(null);
        info.setTypeName(type);
        info.setNewName(name);
        info.setDefaultValue(defaultValue);
        info.setNewOrder(-1);
        return info;
    }

    public String toString() {
        return this.name.toString();
    }

    public int getNewOrder() {
        return this.newOrder;
    }

    public void setNewOrder(int newOrder) {
        this.newOrder = newOrder;
    }

    public boolean isOutput() {
        return this.isOutput;
    }

    void setOutput(boolean isOutput) {
        this.isOutput = isOutput;
        this.indirection = null;
    }

    public boolean isOutputParameter() {
        return this.isOutput() && !this.isReturnValue();
    }

    public boolean mustBeReturnValue() {
        return this.mustBeReturnValue;
    }

    public void setMustBeReturnValue(boolean mustBeReturnValue) {
        this.mustBeReturnValue = mustBeReturnValue;
        this.indirection = null;
    }

    public boolean isReturnValue() {
        return this.mustBeReturnValue || this.isReturnValue;
    }

    public void setReturnValue(boolean isReturnValue) {
        Assert.isTrue((isReturnValue || !this.mustBeReturnValue ? 1 : 0) != 0);
        this.isReturnValue = isReturnValue;
        this.indirection = null;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public boolean isWriteAccess() {
        return this.isWriteAccess;
    }

    void setWriteAccess(boolean isWriteAceess) {
        this.isWriteAccess = isWriteAceess;
        this.indirection = null;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.isDeleted = true;
    }

    public boolean isAdded() {
        return false;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        Assert.isNotNull((Object)value);
        this.defaultValue = value;
    }

    public IASTName getDeclarationName() {
        return this.declarationName;
    }

    public IASTDeclarator getDeclarator() {
        return (IASTDeclarator)this.declarationName.getParent();
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        IASTNode parent = this.getDeclarator().getParent();
        if (parent instanceof IASTSimpleDeclaration) {
            return ((IASTSimpleDeclaration)parent).getDeclSpecifier();
        }
        if (parent instanceof IASTParameterDeclaration) {
            return ((IASTParameterDeclaration)parent).getDeclSpecifier();
        }
        return null;
    }

    void setDeclarationName(IASTName declarationName) {
        Assert.isTrue((declarationName.getPropertyInParent() == IASTDeclarator.DECLARATOR_NAME || declarationName.getPropertyInParent() == IASTLabelStatement.NAME ? 1 : 0) != 0);
        this.declarationName = declarationName;
        this.indirection = null;
    }

    public IASTName getName() {
        return this.name;
    }

    public boolean isRenamed() {
        return this.name == null ? this.newName != null : !String.valueOf(this.name.getSimpleID()).equals(this.newName);
    }

    void addReference(IASTName name, int startOffset, int endOffset) {
        int nodeOffset = name.getFileLocation().getNodeOffset();
        if (nodeOffset >= startOffset && nodeOffset < endOffset) {
            this.referencesInSelection.add(name);
        }
    }

    public String getTypeName() {
        if (this.newTypeName != null) {
            return this.newTypeName;
        }
        INodeFactory nodeFactory = this.name.getTranslationUnit().getASTNodeFactory();
        IASTParameterDeclaration declaration = this.getParameterDeclaration(nodeFactory, null);
        if (declaration == null) {
            return null;
        }
        ASTWriterVisitor writer = new ASTWriterVisitor();
        declaration.accept((ASTVisitor)writer);
        return writer.toString();
    }

    public void setTypeName(String type) {
        Assert.isNotNull((Object)type);
        this.newTypeName = type;
    }

    public String getReturnType() {
        if (!this.isReturnValue()) {
            return null;
        }
        INodeFactory nodeFactory = this.name.getTranslationUnit().getASTNodeFactory();
        IASTDeclarator sourceDeclarator = this.getDeclarator();
        IASTDeclSpecifier declSpec = NameInformation.safeCopy(this.getDeclSpecifier());
        IASTDeclarator declarator = this.createDeclarator(nodeFactory, sourceDeclarator, null);
        IASTParameterDeclaration declaration = nodeFactory.newParameterDeclaration(declSpec, declarator);
        ASTWriterVisitor writer = new ASTWriterVisitor();
        declaration.accept((ASTVisitor)writer);
        return writer.toString();
    }

    public List<IASTName> getReferencesInSelection() {
        return this.referencesInSelection;
    }

    public IASTParameterDeclaration getParameterDeclaration(INodeFactory nodeFactory) {
        return this.getParameterDeclaration(nodeFactory, this.newName);
    }

    private IASTParameterDeclaration getParameterDeclaration(INodeFactory nodeFactory, String paramName) {
        IASTDeclarator declarator;
        IASTDeclSpecifier declSpec;
        IASTDeclSpecifier sourceDeclSpec = this.getDeclSpecifier();
        IASTDeclarator sourceDeclarator = this.getDeclarator();
        if (sourceDeclSpec instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)sourceDeclSpec).getType() == 10) {
            IType type = CPPVisitor.createType((IASTDeclarator)sourceDeclarator);
            DeclarationGenerator generator = DeclarationGenerator.create((INodeFactory)nodeFactory);
            declSpec = generator.createDeclSpecFromType(type);
            declarator = generator.createDeclaratorFromType(type, paramName == null ? null : paramName.toCharArray());
        } else {
            declSpec = NameInformation.safeCopy(sourceDeclSpec);
            declarator = this.createDeclarator(nodeFactory, sourceDeclarator, paramName);
        }
        Indirection indirection = this.getIndirection();
        if (indirection == Indirection.POINTER) {
            declarator.addPointerOperator((IASTPointerOperator)nodeFactory.newPointer());
        } else if (indirection == Indirection.REFERENCE) {
            declarator.addPointerOperator((IASTPointerOperator)((ICPPNodeFactory)nodeFactory).newReferenceOperator(false));
        }
        if (indirection != Indirection.NONE && !this.isWriteAccess && declSpec != null) {
            declSpec.setConst(true);
        }
        declarator.setNestedDeclarator(sourceDeclarator.getNestedDeclarator());
        return nodeFactory.newParameterDeclaration(declSpec, declarator);
    }

    public Indirection getIndirection() {
        if (this.indirection == null) {
            this.indirection = Indirection.NONE;
            boolean isCpp = this.declarationName.getTranslationUnit() instanceof ICPPASTTranslationUnit;
            if (this.isOutputParameter()) {
                this.indirection = isCpp && !this.passOutputByPointer ? Indirection.REFERENCE : Indirection.POINTER;
            } else {
                IType type = TypeHelper.createType((IASTDeclarator)this.getDeclarator());
                if (TypeHelper.shouldBePassedByReference((IType)type, (IASTTranslationUnit)this.declarationName.getTranslationUnit())) {
                    if (isCpp) {
                        if (!this.isWriteAccess) {
                            this.indirection = Indirection.REFERENCE;
                        }
                    } else {
                        this.indirection = Indirection.POINTER;
                    }
                }
            }
        }
        return this.indirection;
    }

    private IASTDeclarator createDeclarator(INodeFactory nodeFactory, IASTDeclarator sourceDeclarator, String name) {
        IASTDeclarator declarator;
        IASTName astName;
        IASTName iASTName = astName = name != null ? nodeFactory.newName(name.toCharArray()) : nodeFactory.newName();
        if (sourceDeclarator instanceof IASTArrayDeclarator) {
            IASTArrayModifier[] arrayModifiers;
            IASTArrayDeclarator arrDeclarator = (IASTArrayDeclarator)sourceDeclarator;
            IASTArrayDeclarator arrayDeclarator = nodeFactory.newArrayDeclarator(astName);
            IASTArrayModifier[] iASTArrayModifierArray = arrayModifiers = arrDeclarator.getArrayModifiers();
            int n = arrayModifiers.length;
            int n2 = 0;
            while (n2 < n) {
                IASTArrayModifier arrayModifier = iASTArrayModifierArray[n2];
                arrayDeclarator.addArrayModifier(arrayModifier.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
            declarator = arrayDeclarator;
        } else {
            declarator = nodeFactory.newDeclarator(astName);
        }
        IASTPointerOperator[] iASTPointerOperatorArray = sourceDeclarator.getPointerOperators();
        int n = iASTPointerOperatorArray.length;
        int n3 = 0;
        while (n3 < n) {
            IASTPointerOperator pointerOp = iASTPointerOperatorArray[n3];
            declarator.addPointerOperator(pointerOp.copy(IASTNode.CopyStyle.withLocations));
            ++n3;
        }
        return declarator;
    }

    private static <T extends IASTNode> T safeCopy(T node) {
        return (T)(node == null ? null : node.copy(IASTNode.CopyStyle.withLocations));
    }

    public ITranslationUnit getTranslationUnit() {
        return this.name != null ? this.name.getTranslationUnit().getOriginatingTranslationUnit() : null;
    }

    public boolean isPassOutputByPointer() {
        return this.passOutputByPointer;
    }

    public void setPassOutputByPointer(boolean passOutputByPointer) {
        this.passOutputByPointer = passOutputByPointer;
        this.indirection = null;
    }

    public static enum Indirection {
        NONE,
        POINTER,
        REFERENCE;

    }
}

