/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICExternalBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.internal.ui.callhierarchy.CHViewPart;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class CallHierarchyUI {
    static final int INDEX_SEARCH_OPTION = 67;
    private static final ICElement[] NO_ELEMENTS = new ICElement[0];
    private static boolean sIsJUnitTest;
    private static List<CHViewPart> fLRUCallHierarchyViews;
    private static int fViewCount;
    private static final int MAX_HISTORY_SIZE = 10;
    private static List<ICElement> fHistoryEntries;

    static {
        fLRUCallHierarchyViews = new ArrayList<CHViewPart>();
        fHistoryEntries = new ArrayList<ICElement>(10);
    }

    public static void setIsJUnitTest(boolean val) {
        sIsJUnitTest = val;
    }

    public static void open(final IWorkbenchWindow window, final ICElement input) {
        if (input != null) {
            final Display display = Display.getCurrent();
            Job job = new Job(CHMessages.CallHierarchyUI_label){

                protected IStatus run(IProgressMonitor monitor) {
                    final ICElement[] elems = CallHierarchyUI.findDefinitions(input);
                    if (elems != null && elems.length > 0) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CallHierarchyUI.internalOpen(window, elems);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private static CHViewPart internalOpen(IWorkbenchWindow window, ICElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            CHViewPart viewPart = CallHierarchyUI.findLRUCallHierarchyViewPart(page);
            String secondaryId = null;
            if (viewPart == null) {
                if (page.findViewReference("org.eclipse.cdt.ui.callHierarchy") != null) {
                    secondaryId = String.valueOf(++fViewCount);
                }
            } else {
                secondaryId = viewPart.getViewSite().getSecondaryId();
            }
            viewPart = (CHViewPart)page.showView("org.eclipse.cdt.ui.callHierarchy", secondaryId, 1);
            viewPart.setInput(input);
            return viewPart;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), CHMessages.OpenCallHierarchyAction_label, null);
            return null;
        }
    }

    private static CHViewPart internalOpen(IWorkbenchWindow window, ICElement[] input) {
        ICElement elem = null;
        switch (input.length) {
            case 0: {
                break;
            }
            case 1: {
                elem = input[0];
                break;
            }
            default: {
                if (sIsJUnitTest) {
                    throw new RuntimeException("ambiguous input");
                }
                elem = OpenActionUtil.selectCElement(input, window.getShell(), CHMessages.CallHierarchyUI_label, CHMessages.CallHierarchyUI_selectMessage, 0x80000001L, 0);
            }
        }
        if (elem != null) {
            return CallHierarchyUI.internalOpen(window, elem);
        }
        return null;
    }

    public static void open(final ITextEditor editor, final ITextSelection sel) {
        IWorkingCopy inputCElement;
        if (editor != null && (inputCElement = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput())) != null) {
            final ICProject project = inputCElement.getCProject();
            final IEditorInput editorInput = editor.getEditorInput();
            final Display display = Display.getCurrent();
            Job job = new Job(CHMessages.CallHierarchyUI_label){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        StatusLineHandler.clearStatusLine((IWorkbenchSite)editor.getSite());
                        final ICElement[] elems = CallHierarchyUI.findDefinitions(project, editorInput, sel);
                        if (elems.length > 0) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CallHierarchyUI.internalOpen(editor.getSite().getWorkbenchWindow(), elems);
                                }
                            });
                        } else {
                            StatusLineHandler.showStatusLineMessage((IWorkbenchSite)editor.getSite(), CHMessages.CallHierarchyUI_openFailureMessage);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }

                public boolean belongsTo(Object family) {
                    return family == CallHierarchyUI.class;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ICElement[] findDefinitions(ICProject project, IEditorInput editorInput, ITextSelection sel) throws CoreException {
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 67);
            index.acquireReadLock();
            try {
                ICElementHandle elem;
                IASTName name = IndexUI.getSelectedName(editorInput, sel);
                if (name == null) return NO_ELEMENTS;
                IBinding binding = name.resolveBinding();
                if (!CallHierarchyUI.isRelevantForCallHierarchy(binding)) {
                    IASTName parent = name;
                    while (parent != null) {
                        if (parent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                            IASTImplicitName[] implicit;
                            ICPPASTFunctionCallExpression fcall = (ICPPASTFunctionCallExpression)parent.getParent();
                            if (fcall == null || (implicit = fcall.getImplicitNames()).length <= 0) break;
                            binding = implicit[0].resolveBinding();
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
                if (!CallHierarchyUI.isRelevantForCallHierarchy(binding)) return NO_ELEMENTS;
                if (name.isDefinition()) {
                    ICElementHandle elem2 = IndexUI.getCElementForName(project, index, name);
                    if (elem2 != null) {
                        ICElement[] iCElementArray = new ICElement[]{elem2};
                        return iCElementArray;
                    }
                    ICElement[] iCElementArray = NO_ELEMENTS;
                    return iCElementArray;
                }
                ICElementHandle[] elems = IndexUI.findAllDefinitions(index, binding);
                if (elems.length != 0) {
                    ICElementHandle[] iCElementHandleArray = elems;
                    return iCElementHandleArray;
                }
                if (name.isDeclaration()) {
                    elem = IndexUI.getCElementForName(project, index, name);
                    if (elem != null) {
                        ICElement[] iCElementArray = new ICElement[]{elem};
                        return iCElementArray;
                    }
                    ICElement[] iCElementArray = NO_ELEMENTS;
                    return iCElementArray;
                }
                elem = IndexUI.findAnyDeclaration(index, project, binding);
                if (elem != null) {
                    ICElement[] iCElementArray = new ICElement[]{elem};
                    return iCElementArray;
                }
                if (binding instanceof ICPPSpecialization) {
                    ICElement[] iCElementArray = CallHierarchyUI.findSpecializationDeclaration(binding, project, index);
                    return iCElementArray;
                }
                ICElement[] iCElementArray = NO_ELEMENTS;
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return NO_ELEMENTS;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return NO_ELEMENTS;
    }

    private static ICElement[] findSpecializationDeclaration(IBinding binding, ICProject project, IIndex index) throws CoreException {
        while (binding instanceof ICPPSpecialization) {
            ICElementHandle elem;
            IBinding original = ((ICPPSpecialization)binding).getSpecializedBinding();
            ICElementHandle[] elems = IndexUI.findAllDefinitions(index, original);
            if (elems.length == 0 && (elem = IndexUI.findAnyDeclaration(index, project, original)) != null) {
                elems = new ICElementHandle[]{elem};
            }
            if (elems.length > 0) {
                return elems;
            }
            binding = original;
        }
        return NO_ELEMENTS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ICElement[] findDefinitions(ICElement input) {
        try {
            ITranslationUnit tu = CModelUtil.getTranslationUnit(input);
            if (tu == null) return new ICElement[]{input};
            ICProject project = tu.getCProject();
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 67);
            index.acquireReadLock();
            try {
                ICElementHandle[] result;
                IIndexBinding binding;
                if (CallHierarchyUI.needToFindDefinition(input) && (binding = IndexUI.elementToBinding(index, input)) != null && (result = IndexUI.findAllDefinitions(index, (IBinding)binding)).length > 0) {
                    ICElementHandle[] iCElementHandleArray = result;
                    return iCElementHandleArray;
                }
                IIndexName name = IndexUI.elementToName(index, input);
                if (name == null) return new ICElement[]{input};
                ICElementHandle handle = IndexUI.getCElementForName(tu, index, name);
                ICElement[] iCElementArray = new ICElement[]{handle};
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return new ICElement[]{input};
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return new ICElement[]{input};
    }

    private static boolean needToFindDefinition(ICElement elem) {
        switch (elem.getElementType()) {
            case 71: 
            case 73: 
            case 88: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRelevantForCallHierarchy(IBinding binding) {
        if (binding instanceof ICExternalBinding || binding instanceof IEnumerator || binding instanceof IFunction) {
            return true;
        }
        if (binding instanceof IVariable) {
            try {
                IScope scope = binding.getScope();
                if (scope != null && scope.getKind() == EScopeKind.eLocal) {
                    return false;
                }
            }
            catch (DOMException dOMException) {}
            return true;
        }
        return false;
    }

    public static boolean isRelevantForCallHierarchy(ICElement elem) {
        if (elem == null) {
            return false;
        }
        switch (elem.getElementType()) {
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 81: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    static void callHierarchyViewActivated(CHViewPart view) {
        fLRUCallHierarchyViews.remove((Object)view);
        fLRUCallHierarchyViews.add(0, view);
    }

    static void callHierarchyViewClosed(CHViewPart view) {
        fLRUCallHierarchyViews.remove((Object)view);
    }

    static void clearHistory() {
        CallHierarchyUI.setHistoryEntries(ICElement.EMPTY_ARRAY);
        for (CHViewPart part : fLRUCallHierarchyViews) {
            part.setInput(null);
        }
    }

    private static CHViewPart findLRUCallHierarchyViewPart(IWorkbenchPage page) {
        boolean viewFoundInPage = false;
        for (CHViewPart view : fLRUCallHierarchyViews) {
            if (!page.equals(view.getSite().getPage())) continue;
            if (!view.isPinned()) {
                return view;
            }
            viewFoundInPage = true;
        }
        if (!viewFoundInPage) {
            IViewReference[] viewReferences;
            IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                CHViewPart view;
                IViewReference curr = iViewReferenceArray[n2];
                if ("org.eclipse.cdt.ui.callHierarchy".equals(curr.getId()) && page.equals(curr.getPage()) && (view = (CHViewPart)curr.getView(true)) != null && !view.isPinned()) {
                    return view;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ICElement[] getHistoryEntries() {
        return fHistoryEntries.toArray(new ICElement[fHistoryEntries.size()]);
    }

    public static void setHistoryEntries(ICElement[] remaining) {
        fHistoryEntries.clear();
        fHistoryEntries.addAll(Arrays.asList(remaining));
    }

    public static void updateHistory(ICElement input) {
        if (input != null) {
            fHistoryEntries.remove(input);
            fHistoryEntries.add(0, input);
            if (fHistoryEntries.size() > 10) {
                fHistoryEntries.remove(9);
            }
        }
    }
}

