/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.MessagesForRegisterVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableLabelFont;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.StaleDataLabelBackground;
import org.eclipse.cdt.dsf.ui.viewmodel.update.StaleDataLabelForeground;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

public class RegisterGroupVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider,
IElementMementoProvider,
IElementPropertiesProvider {
    private static final String PROP_REGISTER_GROUP_DESCRIPTION = "register_group_description";
    private final SyncRegisterDataAccess fSyncRegisterDataAccess;
    private IWatchExpressionFactoryAdapter2 fRegisterGroupExpressionFactory = null;
    private WatchExpressionCellModifier fWatchExpressionCellModifier = new WatchExpressionCellModifier();
    private IElementLabelProvider fLabelProvider = this.createLabelProvider();
    private final String MEMENTO_NAME = "GROUP_MEMENTO_NAME";

    public RegisterGroupVMNode(AbstractDMVMProvider provider, DsfSession session, SyncRegisterDataAccess syncDataAccess) {
        super(provider, session, IRegisters.IRegisterGroupDMContext.class);
        this.fSyncRegisterDataAccess = syncDataAccess;
    }

    public String toString() {
        return "RegisterGroupVMNode(" + this.getSession().getId() + ")";
    }

    public SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    public IWatchExpressionFactoryAdapter2 getWatchExpressionFactory() {
        if (this.fRegisterGroupExpressionFactory == null) {
            this.fRegisterGroupExpressionFactory = new RegisterGroupExpressionFactory();
        }
        return this.fRegisterGroupExpressionFactory;
    }

    @Override
    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        if (regService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        regService.getRegisterGroups(this.createCompositeDMVMContext((IViewerUpdate)update), (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    update.done();
                    return;
                }
                RegisterGroupVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    @Override
    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new RegisterGroupVMC(dmc);
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterGroupVMNode_Name_column__text_format, new String[]{"name"}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_REGISTER_GROUP")), new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__DESCRIPTION", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterGroupVMNode_Description_column__text_format, new String[]{PROP_REGISTER_GROUP_DESCRIPTION}), new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterGroupVMNode_Expression_column__text_format, new String[]{"element_expression"}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_REGISTER_GROUP")), new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForRegisterVM.RegisterGroupVMNode_No_columns__text_format, new String[]{"name", PROP_REGISTER_GROUP_DESCRIPTION}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_REGISTER_GROUP")), new StaleDataLabelBackground(), new VariableLabelFont()}));
        return provider;
    }

    public void update(ILabelUpdate[] updates) {
        this.fLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        RegisterGroupVMNode.this.updatePropertiesInSessionThread(updates);
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException v0) {
                var5_2 = updates;
                var4_3 = updates.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                update = var5_2[var3_4];
                this.handleFailedUpdate(update);
                ++var3_4;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IRegisters service = (IRegisters)this.getServicesTracker().getService(IRegisters.class, null);
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            IExpression expression = (IExpression)DebugPlugin.getAdapter((Object)update.getElement(), IExpression.class);
            if (expression != null) {
                update.setProperty("element_expression", expression.getExpressionText());
            }
            IRegisters.IRegisterGroupDMContext dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRegisters.IRegisterGroupDMContext.class);
            IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
            if (dmc == null || regService == null) {
                this.handleFailedUpdate(update);
                return;
            }
            service.getRegisterGroupData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                @Override
                protected void handleSuccess() {
                    RegisterGroupVMNode.this.fillRegisterGroupDataProperties(update, (IRegisters.IRegisterGroupDMData)this.getData());
                    update.done();
                }
            });
            ++n2;
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void fillRegisterGroupDataProperties(IPropertiesUpdate update, IRegisters.IRegisterGroupDMData data) {
        update.setProperty("name", data.getName());
        update.setProperty(PROP_REGISTER_GROUP_DESCRIPTION, data.getDescription());
        IExpression expression = (IExpression)DebugPlugin.getAdapter((Object)update.getElement(), IExpression.class);
        if (expression == null) {
            update.setProperty("element_expression", data.getName());
        }
    }

    @Override
    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IGroupsChangedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IGroupChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    @Override
    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (e instanceof IRegisters.IGroupsChangedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (e instanceof IRegisters.IGroupChangedDMEvent) {
            parentDelta.addNode(this.createVMContext(((IRegisters.IGroupChangedDMEvent)e).getDMContext()), 2048);
        }
        rm.done();
    }

    @Override
    public boolean canParseExpression(IExpression expression) {
        return this.parseExpressionForGroupName(expression.getExpressionText()) != null;
    }

    private String parseExpressionForGroupName(String expression) {
        if (expression.startsWith("GRP(")) {
            int startIdx = "GRP(".length();
            int endIdx = expression.indexOf(41, startIdx);
            if (startIdx == -1 || endIdx == -1) {
                return null;
            }
            String groupName = expression.substring(startIdx, endIdx);
            return groupName.trim();
        }
        return null;
    }

    @Override
    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent || event instanceof IRegisters.IGroupsChangedDMEvent) {
            return 1024;
        }
        if (event instanceof IRegisters.IGroupChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (event instanceof IRegisters.IGroupsChangedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    @Override
    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IGroupChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        rm.done();
    }

    @Override
    protected void testElementForExpression(Object element, IExpression expression, final DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof IDMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final IRegisters.IRegisterGroupDMContext dmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterGroupDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final String groupName = this.parseExpressionForGroupName(expression.getExpressionText());
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters registersService = (IRegisters)RegisterGroupVMNode.this.getServicesTracker().getService(IRegisters.class);
                    if (registersService != null) {
                        registersService.getRegisterGroupData(dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                rm.setData((Object)((IRegisters.IRegisterGroupDMData)this.getData()).getName().equals(groupName));
                                rm.done();
                            }
                        });
                    } else {
                        rm.setStatus((IStatus)new Status(2, "org.eclipse.cdt.dsf.ui", 10001, "Register service not available", null));
                        rm.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rm.setStatus((IStatus)new Status(2, "org.eclipse.cdt.dsf.ui", 10001, "DSF session shut down", null));
            rm.done();
        }
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof RegisterGroupVMC) {
            ((RegisterGroupVMC)element).setExpression(expression);
        }
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return this.fWatchExpressionCellModifier;
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            final IElementCompareRequest request = iElementCompareRequestArray[n2];
            final IRegisters.IRegisterGroupDMContext regDmc = this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IRegisterGroupDMContext.class);
            final String mementoName = request.getMemento().getString("GROUP_MEMENTO_NAME");
            if (regDmc == null || mementoName == null) {
                request.done();
            } else {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IRegisters regService = (IRegisters)RegisterGroupVMNode.this.getServicesTracker().getService(IRegisters.class);
                            if (regService != null) {
                                regService.getRegisterGroupData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)regService.getExecutor(), null){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            request.setEqual(mementoName.equals("Group." + ((IRegisters.IRegisterGroupDMData)this.getData()).getName()));
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            }
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            final IElementMementoRequest request = iElementMementoRequestArray[n2];
            final IRegisters.IRegisterGroupDMContext regDmc = this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IRegisterGroupDMContext.class);
            if (regDmc == null) {
                request.done();
            } else {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IRegisters regService = (IRegisters)RegisterGroupVMNode.this.getServicesTracker().getService(IRegisters.class);
                            if (regService != null) {
                                regService.getRegisterGroupData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)regService.getExecutor(), null){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            request.getMemento().putString("GROUP_MEMENTO_NAME", "Group." + ((IRegisters.IRegisterGroupDMData)this.getData()).getName());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            }
            ++n2;
        }
    }

    protected class RegisterGroupExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected RegisterGroupExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof RegisterGroupVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            IRegisters.IRegisterGroupDMData groupData = RegisterGroupVMNode.this.getSyncRegisterDataAccess().getRegisterGroupDMData(element);
            if (groupData != null) {
                StringBuffer exprBuf = new StringBuffer();
                exprBuf.append("GRP( ");
                exprBuf.append(groupData.getName());
                exprBuf.append(" )");
                return exprBuf.toString();
            }
            return null;
        }
    }

    protected class RegisterGroupVMC
    extends AbstractDMVMNode.DMVMContext {
        private IExpression fExpression;

        public RegisterGroupVMC(IDMContext dmc) {
            super(dmc);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        @Override
        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return RegisterGroupVMNode.this.getWatchExpressionFactory();
            }
            return super.getAdapter(adapter);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof RegisterGroupVMC && super.equals(other)) {
                RegisterGroupVMC otherGroup = (RegisterGroupVMC)other;
                return otherGroup.fExpression == null && this.fExpression == null || otherGroup.fExpression != null && otherGroup.fExpression.equals(this.fExpression);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }
    }
}

