/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.VMHandlerUtils;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.MessagesForNumberFormat;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class NumberFormatsContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    protected static final List<String> FORMATS = new LinkedList<String>();
    protected IServiceLocator fServiceLocator;
    private static IContributionItem[] NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;

    static {
        FORMATS.add("NATURAL.Format");
        FORMATS.add("HEX.Format");
        FORMATS.add("DECIMAL.Format");
        FORMATS.add("OCTAL.Format");
        FORMATS.add("BINARY.Format");
        FORMATS.add("STRING.Format");
        NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS = new IContributionItem[]{new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 0);
                item.setEnabled(false);
                item.setText(MessagesForNumberFormat.NumberFormatContribution_EmptyFormatsList_label);
            }

            public boolean isEnabled() {
                return false;
            }
        }};
    }

    protected IContributionItem[] getContributionItems() {
        IVMProvider provider = VMHandlerUtils.getActiveVMProvider(this.fServiceLocator);
        if (provider == null) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        IPresentationContext context = provider.getPresentationContext();
        Object activeId = context.getProperty("CurrentNumericStyle");
        if (activeId == null) {
            activeId = "NATURAL.Format";
        }
        ArrayList<SelectNumberFormatAction> actions = new ArrayList<SelectNumberFormatAction>(FORMATS.size());
        for (String formatId : FORMATS) {
            SelectNumberFormatAction action = new SelectNumberFormatAction(context, formatId);
            if (formatId.equals(activeId)) {
                action.setChecked(true);
            }
            actions.add(action);
        }
        if (actions.isEmpty()) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        IContributionItem[] items = new IContributionItem[actions.size()];
        int i = 0;
        while (i < actions.size()) {
            items[i] = new ActionContributionItem((IAction)actions.get(i));
            ++i;
        }
        return items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    private class SelectNumberFormatAction
    extends Action {
        private final IPresentationContext fContext;
        private final String fFormatId;

        SelectNumberFormatAction(IPresentationContext context, String formatId) {
            super(FormattedValueVMUtil.getFormatLabel(formatId), 8);
            this.fContext = context;
            this.fFormatId = formatId;
        }

        public void run() {
            if (this.isChecked()) {
                this.fContext.setProperty("CurrentNumericStyle", (Object)this.fFormatId);
            }
        }
    }
}

