/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard.samples;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.util.BasicUtil;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import com.nvidia.cuda.ide.wizard.samples.SamplesCategory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;

public final class SamplesModel {
    public static final String PROP_SELECTED_SAMPLE = "selectedSample";
    private final SamplesCategory allSamples = new SamplesCategory(this);
    private final Collection<SamplesCategory> categories = new WritableSet(new HashSet(), SamplesCategory.class);
    private SamplesCategory category = null;
    private String path;
    private final Collection<PropertyChangeEvent> pendingEvents = new LinkedList<PropertyChangeEvent>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ProjectSample sample;
    private final Collection<ProjectSample> samples = new HashSet<ProjectSample>();

    private static File getDescriptionFile(File location) {
        File file = new File(location, "NsightEclipse.xml");
        if (file.isFile()) {
            return file;
        }
        file = new File(location, "info.xml");
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String propertyName, Object old, Object current) {
        Collection<PropertyChangeEvent> collection = this.pendingEvents;
        synchronized (collection) {
            this.pendingEvents.add(new PropertyChangeEvent(this, propertyName, old, current));
            if (this.pendingEvents.size() == 1) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SamplesModel.this.sendEvents();
                    }
                });
            }
        }
    }

    public IObservableSet getCategories() {
        return (IObservableSet)this.categories;
    }

    public SamplesCategory getCategory() {
        if (this.category == null) {
            this.setSelectedSample(null);
        } else {
            final Collection<ProjectSample> s = this.category.getSamples();
            if (this.sample == null || !s.contains(this.sample)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SamplesModel.this.setSelectedSample(s.isEmpty() ? null : (ProjectSample)s.iterator().next());
                    }
                });
            }
        }
        return this.category;
    }

    public String getPath() {
        return this.path;
    }

    public synchronized Collection<ProjectSample> getSamples() {
        return this.samples;
    }

    public Collection<ProjectSample> getSamples(File file) {
        return this.readSamples(file, new LinkedList<SamplesCategory>(), 0);
    }

    public ProjectSample getSelectedSample() {
        return this.sample;
    }

    private boolean isSupported(ProjectSample s) {
        return s.isNsightCompatible() && s.compatible(Platform.getOS(), Platform.getOSArch());
    }

    private Collection<ProjectSample> readSamples(File location, Collection<SamplesCategory> newCategories, int depth) {
        File root = this.getSamplesRoot(location, 0);
        if (root == null) {
            return Collections.emptySet();
        }
        HashSet<ProjectSample> newSamples = new HashSet<ProjectSample>();
        Object[] categories = root.listFiles(new DirectoriesOnly());
        if (BasicUtil.isNullOrEmpty(categories)) {
            return Collections.emptyList();
        }
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            Object[] samples = ((File)category).listFiles(new DirectoriesOnly());
            if (!BasicUtil.isNullOrEmpty(samples)) {
                Object[] objectArray2 = samples;
                int n3 = samples.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object sample = objectArray2[n4];
                    File description = SamplesModel.getDescriptionFile((File)sample);
                    if (description != null) {
                        try {
                            ProjectSample s = new ProjectSample(this, description);
                            if (this.isSupported(s)) {
                                newSamples.add(s);
                                newCategories.addAll(Arrays.asList(s.getCategory()));
                            }
                        }
                        catch (CoreException e) {
                            Activator.log((Exception)((Object)e));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return newSamples;
    }

    private File getSamplesRoot(File location, int counter) {
        if (location == null || !location.isDirectory() || counter > 20) {
            return null;
        }
        if (this.isSamplesRoot(location)) {
            return location;
        }
        File c = new File(location, "C");
        if (c.isDirectory() && this.isSamplesRoot(c)) {
            return c;
        }
        return this.getSamplesRoot(location.getParentFile(), counter + 1);
    }

    private boolean isSamplesRoot(File c) {
        Object[] files = c.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().matches("\\d_.*");
            }
        });
        if (!BasicUtil.isNullOrEmpty(files)) {
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (this.isSampleCategory((File)file)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isSampleCategory(File file) {
        Object[] files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && SamplesModel.getDescriptionFile(pathname) != null;
            }
        });
        return !BasicUtil.isNullOrEmpty(files);
    }

    private synchronized void readSamples(String path) {
        File location = new File(path);
        if (location.isDirectory()) {
            final HashSet<SamplesCategory> newCategories = new HashSet<SamplesCategory>();
            Collection<ProjectSample> newSamples = this.readSamples(location, newCategories, 0);
            this.samples.retainAll(newSamples);
            this.samples.addAll(newSamples);
            if (!newCategories.isEmpty()) {
                newCategories.add(this.allSamples);
            }
            for (SamplesCategory category : newCategories) {
                category.refresh();
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SamplesModel.this.categories.retainAll(newCategories);
                    SamplesModel.this.categories.addAll(newCategories);
                    if (!newCategories.contains(SamplesModel.this.category)) {
                        SamplesModel.this.setCategory(newCategories.isEmpty() ? null : SamplesModel.this.allSamples);
                    }
                }
            });
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvents() {
        LinkedList<PropertyChangeEvent> events;
        Collection<PropertyChangeEvent> collection = this.pendingEvents;
        synchronized (collection) {
            events = new LinkedList<PropertyChangeEvent>(this.pendingEvents);
            this.pendingEvents.clear();
        }
        for (PropertyChangeEvent event : events) {
            this.propertyChangeSupport.firePropertyChange(event);
        }
    }

    public void setCategory(SamplesCategory current) {
        SamplesCategory old = this.category;
        if (old == null && current != null || old != null && !old.equals(current)) {
            this.category = current;
            this.firePropertyChange("category", old, current);
        }
    }

    public void setPath(final String path) {
        String old = this.path;
        if (old == null && path != null || !old.equals(path)) {
            this.path = path;
            new Thread("Samples Reader"){

                @Override
                public void run() {
                    SamplesModel.this.readSamples(path);
                }
            }.start();
            this.firePropertyChange("path", old, path);
        }
    }

    public void setSelectedSample(ProjectSample projectSample) {
        if (this.sample == null && projectSample != null || this.sample != null && !this.sample.equals(projectSample)) {
            ProjectSample oldSelected = this.sample;
            this.sample = projectSample;
            this.firePropertyChange(PROP_SELECTED_SAMPLE, oldSelected, projectSample);
        }
    }

    private final class DirectoriesOnly
    implements FileFilter {
        private DirectoriesOnly() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

