/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard.samples;

import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import com.nvidia.cuda.ide.wizard.samples.SamplesModel;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public final class HasSamplesValidator
implements IValidator {
    private final SamplesModel model;

    public HasSamplesValidator(SamplesModel model) {
        this.model = model;
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            String path = (String)value;
            if (path == null || path.trim().length() == 0) {
                return ValidationStatus.error((String)"Samples install location is empty");
            }
            File file = new File(path);
            if (!file.exists()) {
                return ValidationStatus.error((String)String.format("Folder %s does not exist", file.getAbsolutePath()));
            }
            Collection<ProjectSample> samples = this.model.getSamples(file);
            if (samples.isEmpty()) {
                return ValidationStatus.error((String)String.format("No CUDA SDK sample projects was found in %s", file.getAbsolutePath()));
            }
            return ValidationStatus.ok();
        }
        return ValidationStatus.error((String)"Incompatible value format");
    }
}

