/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.toolkit;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.project.BuildUtils;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;

public final class CudaToolkitVariableResolver
implements IDynamicVariableResolver {
    protected static ICudaToolkit getCUDAToolkitById(final String id) {
        try {
            return (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                    return id != null && service.isInitialized() ? service.getToolkit(id) : service.getDefaultToolkit();
                }
            });
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    protected static ICudaToolkit getCUDAToolkitByName(final String name) {
        try {
            return (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                    return service.getToolkitByName(name);
                }
            });
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    protected static String getProjectConnectionName(IProject project) {
        SyncConfig config;
        SyncConfig syncConfig = config = project != null ? SyncConfigManager.getActive((IProject)project) : null;
        if (config == null || SyncConfigManager.isLocal((SyncConfig)config)) {
            return null;
        }
        return config.getConnectionName();
    }

    protected static IProject getProjectByName(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return projectName != null ? root.getProject(projectName) : null;
    }

    protected static String getProjectConnectionName(String projectName) {
        IProject project = CudaToolkitVariableResolver.getProjectByName(projectName);
        return CudaToolkitVariableResolver.getProjectConnectionName(project);
    }

    protected static ICudaToolkit getToolkitByProjectName(String projectName) {
        String connectionName = CudaToolkitVariableResolver.getProjectConnectionName(projectName);
        if (connectionName != null) {
            return CudaToolkitVariableResolver.getCUDAToolkitById(connectionName);
        }
        IProject prj = CudaToolkitVariableResolver.getProjectByName(projectName);
        String tcName = BuildUtils.getProjectToolchainName(prj);
        return tcName != null ? CudaToolkitVariableResolver.getCUDAToolkitByName(tcName) : null;
    }

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        if ("cuda_bin".equals(variable.getName())) {
            ICudaToolkit toolkit = CudaToolkitVariableResolver.getCUDAToolkitById(argument);
            return toolkit != null ? toolkit.getBinDirectory() : null;
        }
        if ("cuda_tk_bin".equals(variable.getName())) {
            IProject prj = CudaToolkitVariableResolver.getProjectByName(argument);
            String tcName = BuildUtils.getProjectToolchainName(prj);
            ICudaToolkit toolkit = CudaToolkitVariableResolver.getCUDAToolkitByName(tcName);
            return toolkit != null ? toolkit.getBinDirectory() : null;
        }
        if ("cuda_samples_dir".equals(variable.getName())) {
            ICudaToolkit toolkit = CudaToolkitVariableResolver.getToolkitByProjectName(argument);
            String bindir = toolkit != null ? toolkit.getBinDirectory() : null;
            try {
                File bindirParentFile = new File(bindir).getParentFile();
                return new File(bindirParentFile, "samples").getCanonicalPath();
            }
            catch (Exception exception) {
                return null;
            }
        }
        if ("cuda_samples_common_lib_dir".equals(variable.getName())) {
            ICudaToolkit toolkit = CudaToolkitVariableResolver.getToolkitByProjectName(argument);
            String bindir = toolkit != null ? toolkit.getBinDirectory() : null;
            try {
                File bindirParentFile = new File(bindir).getParentFile();
                return String.valueOf(new File(bindirParentFile, "samples/common/lib").getCanonicalPath()) + "/$(OS_SUFFIX)";
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

