/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.samples;

import com.nvidia.cuda.ide.samples.ImportCUDASample;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MacOSSamplesTestStartup
implements IStartup {
    private static final Pattern OPEN_FILE_ARG_PATTERN = Pattern.compile("-nsight\\.mac\\.openfile=\"?(.*)\"?");

    public void earlyStartup() {
        try {
            if (ImportCUDASample.isTestingSamplesImport() && "macosx".equals(Platform.getOS())) {
                this.executeTest();
            }
        }
        catch (Throwable throwable) {}
    }

    private void executeTest() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows.length > 0) {
            System.out.println("Workbench window found and executing test");
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if ("macosx".equals(Platform.getOS())) {
                        MacOSSamplesTestStartup.this.executeImportSampleTest();
                    }
                }
            });
            return;
        }
        IWindowListener listener = new IWindowListener(){

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
                workbench.removeWindowListener((IWindowListener)this);
                System.out.println("Received window activated event");
                MacOSSamplesTestStartup.this.executeImportSampleTest();
            }
        };
        workbench.addWindowListener(listener);
        System.out.println("Registered listener to execute the samples import test");
    }

    private void executeImportSampleTest() {
        String[] args;
        String[] stringArray = args = Platform.getCommandLineArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            Matcher matcher = OPEN_FILE_ARG_PATTERN.matcher(arg);
            if (matcher.matches()) {
                try {
                    File file = new File(matcher.group(1)).getCanonicalFile();
                    if (file.isFile()) {
                        new ImportCUDASample().open((IPath)new Path(file.getPath()));
                    } else {
                        System.out.println("Sample file location in the test is not valid: " + file.getAbsolutePath());
                    }
                }
                catch (IOException iOException) {}
            }
            ++n2;
        }
    }
}

