/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.tools;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.build.project.BuildUtils;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCommands;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class NvccDependencyCalculatorCommands
implements IManagedDependencyCommands {
    private final IBuildObject buildContext;
    private final ICConfigurationDescription configuration;
    private final IResource resource;
    private final IPath source;
    private final ITool tool;
    private final IPath topBuildDirectory;

    public NvccDependencyCalculatorCommands(IPath source, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this(source, null, buildContext, tool, topBuildDirectory);
    }

    public NvccDependencyCalculatorCommands(IPath source, IResource resource, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this.source = source;
        this.resource = resource;
        this.buildContext = buildContext;
        this.tool = tool;
        this.topBuildDirectory = topBuildDirectory;
        if (buildContext instanceof IConfiguration) {
            IConfiguration config = (IConfiguration)buildContext;
            this.configuration = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config);
        } else {
            IResourceInfo rcInfo = (IResourceInfo)buildContext;
            this.configuration = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)rcInfo.getParent());
        }
    }

    public boolean areCommandsGeneric() {
        return true;
    }

    public IBuildObject getBuildContext() {
        return this.buildContext;
    }

    public String[] getDependencyCommandOptions() {
        return new String[0];
    }

    public IPath[] getDependencyFiles() {
        IPath depFilePath = this.source.removeFileExtension().addFileExtension("d");
        if (!depFilePath.isAbsolute() && this.topBuildDirectory.isPrefixOf(depFilePath)) {
            depFilePath = depFilePath.removeFirstSegments(1);
        }
        IPath[] paths = new IPath[]{depFilePath};
        return paths;
    }

    public String[] getPostToolDependencyCommands() {
        return null;
    }

    public String[] getPreToolDependencyCommands() {
        IPath path = this.getDependencyFiles()[0].removeLastSegments(1);
        try {
            String commandLine = this.tool.getToolCommandFlagsString(null, null).replace("--compile", "").replace("--device-c", "");
            String command = BuildUtils.getNvccPath(this.tool);
            String archs = CudaProjectUtil.getArchitectureOptions(this.configuration, this.resource);
            Cpu cpu = BuildUtils.getCpu(this.tool);
            return new String[]{String.format("\t%s %s %s %s -odir \"%s\" -M -o \"$(@:%%.o=%%.d)\" \"$<\"", command, BuildUtils.addCcbinSwitch(commandLine, cpu), archs, CoreUtil.concat((String[])cpu.getNvccFlags()), path.isEmpty() ? "." : path.toOSString())};
        }
        catch (BuildException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    public IPath getSource() {
        return this.source;
    }

    public ITool getTool() {
        return this.tool;
    }

    public IPath getTopBuildDirectory() {
        return this.topBuildDirectory;
    }
}

