/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.build.project.ICubinModule;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.ProjectMetaManager;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import com.nvidia.cuda.ide.cdt.make.CdtMakefileGenerator;
import com.nvidia.cuda.ide.util.IdeUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.swt.widgets.Shell;

public class NvccMakefileGenerator
extends CdtMakefileGenerator {
    private static final Pattern ARCHS_PATTERN;
    public static final String C_OUTPUT = " -x c -o";
    public static final String CPP_OUTPUT = " -x c++ -o";
    public static final String CU_OUTPUT = " -x cu -o";
    private static final String LOCAL_SYSTEM = "Local";
    private static final String NSIGHTBUILD_FILE = "nsightbuilddata";
    private static final String VAR_CUBINS = "CUBINS";
    private String dependencies;
    private boolean inExecutable = true;
    private String module;
    private String outputSwitch;

    static {
        StringBuilder builder = new StringBuilder("(.*)@(");
        builder.ensureCapacity((Cpu.values().length + 1) * 5);
        boolean first = true;
        Cpu[] cpuArray = Cpu.values();
        int n = cpuArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cpu cpu = cpuArray[n2];
            if (first) {
                first = false;
            } else {
                builder.append("|");
            }
            builder.append(cpu.name());
            ++n2;
        }
        builder.append(")");
        ARCHS_PATTERN = Pattern.compile(builder.toString());
    }

    private static void createPath(IContainer folder) throws CoreException {
        if (folder == null || folder.getType() == 4) {
            return;
        }
        if (!folder.exists()) {
            NvccMakefileGenerator.createPath(folder.getParent());
            if (folder.getType() == 2) {
                ((IFolder)folder).create(false, false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private static Tuple<String, Cpu, Integer> getActiveTarget(IProject project) {
        Cpu cpu;
        String system;
        SyncConfig active = SyncConfigManager.getActive((IProject)project);
        if (active == null) {
            system = LOCAL_SYSTEM;
            cpu = Cpu.getLocalTargetCpu(project);
        } else {
            system = active.getName();
            cpu = Cpu.getRemoteTargetCpu(active);
        }
        return Tuple.triplet((Object)system, (Object)((Object)cpu), (Object)0);
    }

    private static String getModuleObjectsVar(ICubinModule module) {
        IPath path = module.getPath();
        String string = path.toOSString();
        StringBuffer b = new StringBuffer();
        int original = 0;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c < '\u0080' && Character.isDigit(c) | Character.isLetter(c)) {
                ++original;
                b.append(Character.toUpperCase(c));
            } else {
                b.append('_');
            }
            ++i;
        }
        if (100 * string.length() / original > 50) {
            return String.format("%s_OBJS", b.toString());
        }
        return String.format("CUDAMODULE_%H_OBJS", module);
    }

    private static IContainer getOutputFolder(IConfiguration cfg) {
        CBuildData buildData = cfg.getBuildData();
        Object[] outputDirectories = buildData.getOutputDirectories();
        if (!CoreUtil.isNullOrEmpty((Object[])outputDirectories)) {
            Object output = outputDirectories[0];
            IPath fullPath = output.getFullPath();
            if (fullPath != null && fullPath.segmentCount() > 0) {
                IProject project = cfg.getOwner().getProject();
                return project.getFolder(fullPath);
            }
            return null;
        }
        return null;
    }

    private static boolean isNvccCompiled(IResourceInfo rcInfo) {
        Object[] tools = rcInfo.getTools();
        if (!CoreUtil.isNullOrEmpty((Object[])tools)) {
            Object[] objectArray = tools;
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                Object tool = objectArray[n2];
                if (CudaProjectUtil.isToolWithId((ITool)tool, "nvcc.compiler")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static Tuple<String, Cpu, Integer> parseConfig(String string) {
        if (CoreUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        Matcher matcher = ARCHS_PATTERN.matcher(string.trim());
        if (matcher.matches()) {
            return Tuple.triplet((Object)matcher.group(1).trim(), (Object)((Object)Cpu.valueOf(matcher.group(2).trim())), (Object)0);
        }
        return Tuple.triplet((Object)string.trim(), null, (Object)0);
    }

    protected static boolean promptToCleanAll(Tuple<String, Cpu, Integer> current, Tuple<String, Cpu, Integer> past) {
        String message;
        if (!CoreUtil.equals((Object)((String)current.getObject1()), (Object)((String)past.getObject1()))) {
            message = String.format("This project was build for a %s target system.", past.getObject1());
        } else {
            Cpu cpu = (Cpu)((Object)past.getObject2());
            String architecture = cpu == null ? "unknown" : cpu.toString();
            message = String.format("This project was build for %s CPU architecture.", architecture);
        }
        return MessageDialog.openQuestion((Shell)SWTUtil.getShell(), (String)"Nsight Eclipse Edition", (String)String.format("%s\nDo you want to remove all files in destination folder before building?", message));
    }

    private static boolean promptToCleanBuild(final Tuple<String, Cpu, Integer> current, final Tuple<String, Cpu, Integer> past) {
        return (Boolean)SWTUtil.callChecked((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return NvccMakefileGenerator.promptToCleanAll((Tuple<String, Cpu, Integer>)current, (Tuple<String, Cpu, Integer>)past);
            }
        });
    }

    private static Collection<Tuple<String, Cpu, Integer>> readSupportedTargets(IContainer folder) throws CoreException, IOException {
        if (folder.exists() && folder.members().length > 1) {
            IFile file = folder.getFile((IPath)new Path(NSIGHTBUILD_FILE));
            if (file.exists()) {
                return NvccMakefileGenerator.readTargets(file);
            }
            return Collections.singleton(Tuple.triplet((Object)LOCAL_SYSTEM, (Object)((Object)Cpu.Native), (Object)0));
        }
        return null;
    }

    private static Collection<Tuple<String, Cpu, Integer>> readTargets(IFile file) throws UnsupportedEncodingException, CoreException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));
        try {
            LinkedList<Tuple<String, Cpu, Integer>> list = new LinkedList<Tuple<String, Cpu, Integer>>();
            String name = reader.readLine();
            while (name != null) {
                Tuple<String, Cpu, Integer> c = NvccMakefileGenerator.parseConfig(name);
                if (c != null) {
                    list.add(c);
                }
                name = reader.readLine();
            }
            LinkedList<Tuple<String, Cpu, Integer>> linkedList = list;
            return linkedList;
        }
        finally {
            reader.close();
        }
    }

    private static void testTargetsCompatibility(IConfiguration cfg) throws CoreException, IOException {
        IContainer folder = NvccMakefileGenerator.getOutputFolder(cfg);
        if (folder != null) {
            Tuple<String, Cpu, Integer> current = NvccMakefileGenerator.getActiveTarget(cfg.getOwner().getProject());
            Collection<Tuple<String, Cpu, Integer>> previous = NvccMakefileGenerator.readSupportedTargets(folder);
            LinkedList<Tuple<String, Cpu, Integer>> targets = new LinkedList<Tuple<String, Cpu, Integer>>(Collections.singleton(current));
            if (previous != null) {
                if (!previous.contains(current) && NvccMakefileGenerator.promptToCleanBuild(current, (Tuple<String, Cpu, Integer>)((Tuple)CoreUtil.first(previous)))) {
                    IResource[] iResourceArray = folder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        ++n2;
                    }
                } else {
                    targets.addAll(previous);
                }
            }
            NvccMakefileGenerator.writeConfig(folder, targets);
        }
    }

    private static void writeConfig(IContainer folder, Collection<Tuple<String, Cpu, Integer>> targets) throws CoreException {
        StringBuilder builder = new StringBuilder();
        for (Tuple<String, Cpu, Integer> tuple : targets) {
            builder.append(String.format("%s@%s\n", tuple.getObject1(), ((Cpu)((Object)tuple.getObject2())).name()));
        }
        NvccMakefileGenerator.writeTargetsToFile(folder, builder);
    }

    private static void writeTargetsToFile(IContainer folder, StringBuilder builder) throws CoreException {
        NvccMakefileGenerator.createPath(folder);
        IFile file = folder.getFile((IPath)new Path(NSIGHTBUILD_FILE));
        String charset = file.getCharset();
        try {
            ByteArrayInputStream buffer = new ByteArrayInputStream(builder.toString().getBytes(charset));
            if (file.exists()) {
                file.setContents((InputStream)buffer, 1, (IProgressMonitor)new NullProgressMonitor());
            } else {
                IdeUtil.createParents((IResource)file, (IProgressMonitor)new NullProgressMonitor());
                file.create((InputStream)buffer, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void addCubinRules(String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, boolean generatedSource, Vector<IPath> generatedDepFiles, Vector<IPath> enumeratedOutputs, LinkedHashMap<String, String> buildVarToRuleStringMap, Collection<ICubinModule> wholeModules) {
        if (!wholeModules.isEmpty()) {
            this.addVariableIfMissing(buildVarToRuleStringMap, VAR_CUBINS);
        }
        for (ICubinModule module : wholeModules) {
            String[] ph;
            String[] virt;
            this.module = NvccMakefileGenerator.escapeWhitespaces((String)module.getPath().toOSString());
            StringBuilder builder = new StringBuilder();
            String[] stringArray = virt = Architecture.convertToCommandLineOptions(false, module.getVirtualArchitectures());
            int n = virt.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                builder.append(' ').append(option);
                ++n2;
            }
            String[] stringArray2 = ph = Architecture.convertToCommandLineOptions(true, module.getPhysicalArchitectures());
            int n3 = ph.length;
            n = 0;
            while (n < n3) {
                String option = stringArray2[n];
                builder.append(' ').append(option);
                ++n;
            }
            builder.append(" -").append(module.getType().name()).append(CU_OUTPUT);
            this.addMacroAdditionFiles(buildVarToRuleStringMap, VAR_CUBINS, new Vector<String>(Collections.singleton(this.module)));
            this.outputSwitch = builder.toString();
            super.addRuleForSource(relativePath, buffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, enumeratedOutputs, buildVarToRuleStringMap);
        }
    }

    private StringBuilder addModuleLinkRule(ITool tool, ICubinModule module) throws BuildMacroException {
        String varName = "$(" + NvccMakefileGenerator.getModuleObjectsVar(module) + ')';
        StringBuilder buffer = new StringBuilder(this.getBuildRule(NvccMakefileGenerator.escapeWhitespaces((String)module.getPath().toString()), varName));
        buffer.append(NEWLINE).append("\t").append("@");
        buffer.append(NvccMakefileGenerator.escapedEcho((String)(String.valueOf(MESSAGE_START_FILE) + " " + "$@")));
        buffer.append("\t").append("@");
        buffer.append(NvccMakefileGenerator.escapedEcho((String)tool.getAnnouncement()));
        String command = tool.getToolCommand();
        String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(command, "", " ", 1, (Object)new FileContextData(null, null, null, (IBuildObject)tool));
        resolvedCommand = resolvedCommand.trim();
        if (resolvedCommand.length() > 0) {
            command = resolvedCommand;
        }
        String buildCmd = this.createLinkerCommandLine(module, command, varName);
        try {
            String resolvedCommand2 = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, "", " ", 1, (Object)new FileContextData(null, null, null, (IBuildObject)tool));
            resolvedCommand2 = resolvedCommand2.trim();
            if (resolvedCommand2.length() > 0) {
                buildCmd = resolvedCommand2;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        buffer.append("\t" + buildCmd);
        buffer.append(NEWLINE);
        buffer.append("\t@" + NvccMakefileGenerator.escapedEcho((String)(String.valueOf(MESSAGE_FINISH_FILE) + " " + "$@")));
        buffer.append("\t@" + ECHO_BLANK_LINE);
        buffer.append(NEWLINE);
        return buffer;
    }

    private void addRDCObjectRule(String objectName, String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, boolean generatedSource, Vector<IPath> generatedDepFiles, Vector<IPath> enumeratedOutputs, LinkedHashMap<String, String> buildVarToRuleStringMap, Collection<ICubinModule> modules, IFile file, ICudaModule executable) {
        int moduleArchs = 0;
        for (ICubinModule module : modules) {
            int archs = module.getPhysicalArchitectures();
            if (archs == 0) {
                moduleArchs = Architecture.get(2, 0).getBit();
                continue;
            }
            moduleArchs |= archs;
        }
        if (!(executable.includes(file) && executable.isDeviceLinkingEnabled() || moduleArchs == 0)) {
            String[] options;
            StringBuilder outputString = new StringBuilder();
            this.module = NvccMakefileGenerator.escapeWhitespaces((String)objectName);
            String[] stringArray = options = Architecture.convertToCommandLineOptions(true, moduleArchs);
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                outputString.append(option).append(' ');
                ++n2;
            }
            outputString.append(" --device-c").append(CU_OUTPUT);
            this.outputSwitch = outputString.toString();
            super.addRuleForSource(relativePath, buffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, enumeratedOutputs, buildVarToRuleStringMap);
        }
    }

    protected void addRuleForSource(String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, boolean generatedSource, Vector<IPath> generatedDepFiles, Vector<IPath> enumeratedOutputs, LinkedHashMap<String, String> buildVarToRuleStringMap) {
        if (rcInfo instanceof IFileInfo) {
            try {
                if (NvccMakefileGenerator.isNvccCompiled(rcInfo)) {
                    this.outputSwitch = this.getOutputFlag(resource, ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)rcInfo.getParent()));
                    if (this.generateRulesForFile(relativePath, buffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, enumeratedOutputs, buildVarToRuleStringMap)) {
                        this.fixDeps(generatedDepFiles);
                        return;
                    }
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        super.addRuleForSource(relativePath, buffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, enumeratedOutputs, buildVarToRuleStringMap);
        this.fixDeps(generatedDepFiles);
    }

    protected boolean addRuleForTool(ITool tool, StringBuffer buffer, boolean bTargetTool, String targetName, String targetExt, List<String> outputVarsAdditionsList, Vector<String> managedProjectOutputs, boolean bEmitPostBuildStepCall) {
        if (bTargetTool) {
            try {
                ICubinModule[] modules;
                ICudaProjectConfiguration cpc = this.readConfiguration(tool);
                ICubinModule[] iCubinModuleArray = modules = cpc.getModules();
                int n = modules.length;
                int n2 = 0;
                while (n2 < n) {
                    ICubinModule module = iCubinModuleArray[n2];
                    if (module.isDeviceLinkingEnabled()) {
                        outputVarsAdditionsList.add(VAR_CUBINS);
                        this.addVariableIfMissing(this.getTopBuildOutputVars(), VAR_CUBINS);
                        this.addMacroAdditionFiles(this.getTopBuildOutputVars(), VAR_CUBINS, new Vector<String>(Collections.singleton(NvccMakefileGenerator.escapeWhitespaces((String)module.getPath().toString()))));
                        buffer.append((CharSequence)this.addModuleLinkRule(tool, module));
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        return super.addRuleForTool(tool, buffer, bTargetTool, targetName, targetExt, outputVarsAdditionsList, managedProjectOutputs, bEmitPostBuildStepCall);
    }

    protected void addToBuildVar(LinkedHashMap<String, String> buildVarToRuleStringMap, String ext, String varName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        if (this.inExecutable) {
            super.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
        }
    }

    private void addToRDCObjects(String objectFile, LinkedHashMap<String, String> buildVarToRuleStringMap, ICubinModule module) {
        String variable = NvccMakefileGenerator.getModuleObjectsVar(module);
        this.addVariableIfMissing(buildVarToRuleStringMap, variable);
        this.addMacroAdditionFile(buildVarToRuleStringMap, variable, objectFile);
    }

    private void addVariableIfMissing(LinkedHashMap<String, String> outputVars, String variable) {
        if (!outputVars.containsKey(variable)) {
            this.getBuildOutputVars().put(variable, Collections.emptyList());
            outputVars.put(variable, String.valueOf(variable) + " " + "+=" + " " + "\\\n");
        }
    }

    protected Vector<String> calculateSecondaryOutputs(IOutputType[] secondaryOutputs) {
        if (secondaryOutputs != null && secondaryOutputs.length > 0) {
            if (secondaryOutputs.length == 1) {
                if (secondaryOutputs[0] == null) {
                    return new Vector<String>(Collections.singleton(VAR_CUBINS));
                }
            } else {
                boolean addCubins = false;
                ArrayList<IOutputType> types = new ArrayList<IOutputType>(secondaryOutputs.length - 1);
                IOutputType[] iOutputTypeArray = secondaryOutputs;
                int n = secondaryOutputs.length;
                int n2 = 0;
                while (n2 < n) {
                    IOutputType type = iOutputTypeArray[n2];
                    if (secondaryOutputs[0] == null) {
                        addCubins = true;
                    } else {
                        types.add(type);
                    }
                    ++n2;
                }
                if (addCubins) {
                    Vector outputs = super.calculateSecondaryOutputs(types.toArray(new IOutputType[types.size()]));
                    outputs.add(VAR_CUBINS);
                    return outputs;
                }
            }
        }
        return super.calculateSecondaryOutputs(secondaryOutputs);
    }

    private String createLinkerCommandLine(ICubinModule module, String command, String argsVar) {
        String[] options;
        StringBuilder buffer = new StringBuilder();
        buffer.append(command).append(" ");
        int archs = module.getPhysicalArchitectures();
        int arch = archs == 0 ? archs : Architecture.get(2, 0).getBit();
        String[] stringArray = options = Architecture.convertToCommandLineOptions(true, arch);
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            buffer.append(' ').append(string);
            ++n2;
        }
        buffer.append(" --relocatable-device-code=true -").append(module.getType().name());
        buffer.append(" -o \"").append("$@").append("\"").append(" ");
        buffer.append(argsVar);
        return buffer.toString();
    }

    private void fixDeps(Vector<IPath> generatedDepFiles) {
        HashSet<IPath> deps = new HashSet<IPath>(generatedDepFiles);
        generatedDepFiles.clear();
        generatedDepFiles.addAll(deps);
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        try {
            NvccMakefileGenerator.testTargetsCompatibility(this.getConfig());
        }
        catch (IOException e) {
            throw CoreUtil.coreException((Throwable)e, (String)"Unable to read Nsight build settings file", (Object[])new Object[0]);
        }
        return super.generateMakefiles(delta);
    }

    private boolean generateRulesForFile(String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceInfo rcInfo, boolean generatedSource, Vector<IPath> generatedDepFiles, Vector<IPath> enumeratedOutputs, LinkedHashMap<String, String> buildVarToRuleStringMap) throws CoreException {
        IFile file;
        ICConfigurationDescription config = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)rcInfo.getParent());
        ICudaProjectConfiguration configuration = ProjectMetaManager.load(config);
        ICubinModule[] modules = configuration.getModules(file = (IFile)resource);
        if (modules.length != 0) {
            HashSet<ICubinModule> wholeModules = new HashSet<ICubinModule>();
            HashSet<ICubinModule> rdcModules = new HashSet<ICubinModule>();
            ICudaModule executable = configuration.getExecutable();
            IPath base = new Path(relativePath).append(file.getName()).removeFileExtension();
            String extension = executable.isDeviceLinkingEnabled() || !executable.includes(file) ? "o" : "device.o";
            String objectName = base.addFileExtension(extension).toString();
            ICubinModule[] iCubinModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                ICubinModule module = iCubinModuleArray[n2];
                if (module.isDeviceLinkingEnabled()) {
                    this.addToRDCObjects(objectName, buildVarToRuleStringMap, module);
                    rdcModules.add(module);
                } else {
                    wholeModules.add(module);
                }
                ++n2;
            }
            this.inExecutable = executable.includes(file);
            if (this.inExecutable) {
                try {
                    super.addRuleForSource(relativePath, buffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, enumeratedOutputs, buildVarToRuleStringMap);
                }
                finally {
                    this.inExecutable = true;
                }
            }
            if (!rdcModules.isEmpty()) {
                this.addRDCObjectRule(objectName, relativePath, buffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, enumeratedOutputs, buildVarToRuleStringMap, rdcModules, file, executable);
            }
            if (!wholeModules.isEmpty()) {
                this.addCubinRules(relativePath, buffer, resource, sourceLocation, rcInfo, generatedSource, generatedDepFiles, enumeratedOutputs, buildVarToRuleStringMap, wholeModules);
            }
            return true;
        }
        return false;
    }

    protected IManagedCommandLineInfo generateToolCommandLineInfo(ITool tool, String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        String flag;
        if (CudaProjectUtil.isToolWithId(tool, "nvcc.compiler")) {
            IConfiguration configuration = ((IToolChain)tool.getParent()).getParent();
            IProject project = (IProject)configuration.getManagedProject().getOwner();
            IFile[] files = project.getWorkspace().getRoot().findFilesForLocationURI(inputLocation.toFile().toURI());
            IFile file = null;
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (f.getProject().equals((Object)project)) {
                    file = f;
                    break;
                }
                ++n2;
            }
            flag = file != null ? this.getOutputFlag((IResource)file, ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)configuration)) : outputFlag;
        } else {
            flag = outputFlag;
        }
        return super.generateToolCommandLineInfo(tool, sourceExtension, flags, flag, outputPrefix, outputName, inputResources, inputLocation, outputLocation);
    }

    protected String getBuildRule(String buildRule, String deps) {
        this.dependencies = deps;
        if (this.module != null) {
            String m = this.module;
            this.module = null;
            return super.getBuildRule(m, this.dependencies);
        }
        return super.getBuildRule(buildRule, deps);
    }

    protected IManagedCommandLineInfo getCommandLine(ITool tool, String otherPrimaryOutputs, String cmd, String[] inputStrings, String[] flags, String outflag, String outputPrefix, IPath inputLocation) {
        if (CudaProjectUtil.isToolWithId(tool, "nvcc.compiler")) {
            if (inputLocation != null) {
                IConfiguration configuration = ((IToolChain)tool.getParent()).getParent();
                ICConfigurationDescription description = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)configuration);
                IProject project = (IProject)configuration.getManagedProject().getOwner();
                IResource resource = project.findMember(inputLocation);
                outflag = this.getOutputFlag(resource, description);
            } else if (this.outputSwitch != null) {
                outflag = this.outputSwitch;
                this.outputSwitch = null;
            }
        }
        return super.getCommandLine(tool, otherPrimaryOutputs, cmd, inputStrings, flags, outflag, outputPrefix, inputLocation);
    }

    private String getOutputFlag(IResource resource, ICConfigurationDescription description) {
        block5: {
            if (resource != null && resource.getType() == 1) {
                String id;
                block6: {
                    ILanguage language = LanguageManager.getInstance().getLanguageForFile((IFile)resource, description);
                    if (language == null) break block5;
                    id = language.getId();
                    if (!"org.eclipse.cdt.core.gcc".equals(id)) break block6;
                    return C_OUTPUT;
                }
                try {
                    if ("org.eclipse.cdt.core.g++".equals(id)) {
                        return CPP_OUTPUT;
                    }
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
        }
        return CU_OUTPUT;
    }

    private ICudaProjectConfiguration readConfiguration(ITool tool) throws CoreException {
        IConfiguration configuration;
        IBuildObject parent = tool.getParent();
        if (parent instanceof IConfiguration) {
            configuration = (IConfiguration)parent;
        } else if (parent instanceof IToolChain) {
            configuration = ((IToolChain)parent).getParent();
        } else if (parent instanceof IResourceInfo) {
            configuration = ((IResourceInfo)parent).getParent();
        } else {
            throw new IllegalArgumentException(parent.getClass().getName());
        }
        return ProjectMetaManager.load(ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)configuration));
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        IConfiguration c;
        IContainer folder;
        MultiStatus status = super.regenerateMakefiles();
        if ((status == null || status.isOK()) && (folder = NvccMakefileGenerator.getOutputFolder(c = this.getConfig())) != null) {
            Tuple<String, Cpu, Integer> target = NvccMakefileGenerator.getActiveTarget(c.getManagedProject().getOwner().getProject());
            NvccMakefileGenerator.writeConfig(folder, Collections.singleton(target));
        }
        return status;
    }
}

