/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.Gradient;

public class LinearGradient
implements Gradient {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private boolean isRelativeToFigureBounds = true;
    private double[] stopOffsets;
    private Color[] stopColors;
    private double[] stopOpacities;
    private AffineTransform transform;
    private int spreadMethod;

    public LinearGradient() {
    }

    public LinearGradient(double d, double d2, double d3, double d4, double[] dArray, Color[] colorArray, double[] dArray2, boolean bl, AffineTransform affineTransform) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.stopOffsets = dArray;
        this.stopColors = colorArray;
        this.stopOpacities = dArray2;
        this.isRelativeToFigureBounds = bl;
        this.transform = affineTransform;
    }

    public void setGradientVector(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public void setStops(double[] dArray, Color[] colorArray, double[] dArray2) {
        this.stopOffsets = dArray;
        this.stopColors = colorArray;
        this.stopOpacities = dArray2;
    }

    public void setRelativeToFigureBounds(boolean bl) {
        this.isRelativeToFigureBounds = bl;
    }

    @Override
    public boolean isRelativeToFigureBounds() {
        return this.isRelativeToFigureBounds;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public double[] getStopOffsets() {
        return (double[])this.stopOffsets.clone();
    }

    public Color[] getStopColors() {
        return (Color[])this.stopColors.clone();
    }

    public double[] getStopOpacities() {
        return (double[])this.stopOpacities.clone();
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public Paint getPaint(Figure figure, double d) {
        Object object;
        if (this.stopColors.length == 0) {
            return new Color(0, true);
        }
        Color[] colorArray = new Color[this.stopColors.length];
        float[] fArray = new float[this.stopColors.length];
        float f = 0.0f;
        for (int i = 0; i < this.stopColors.length; ++i) {
            fArray[i] = Math.min(1.0f, Math.max(f, (float)this.stopOffsets[i]));
            colorArray[i] = new Color(this.stopColors[i].getRGB() & 0xFFFFFF | (int)(d * this.stopOpacities[i] * 255.0) << 24, true);
            f = fArray[i];
        }
        Point2D.Double double_ = new Point2D.Double(this.x1, this.y1);
        Point2D.Double double_2 = new Point2D.Double(this.x2, this.y2);
        AffineTransform affineTransform = this.transform;
        if (this.isRelativeToFigureBounds) {
            affineTransform = (AffineTransform)affineTransform.clone();
            object = figure.getBounds();
            affineTransform.translate(((Rectangle2D.Double)object).x, ((Rectangle2D.Double)object).y);
            affineTransform.scale(((Rectangle2D.Double)object).width, ((Rectangle2D.Double)object).height);
        }
        if (this.stopColors.length == 1 || affineTransform.getDeterminant() == 0.0) {
            return colorArray[0];
        }
        object = new LinearGradientPaint(double_, double_2, fArray, colorArray, LinearGradientPaint.NO_CYCLE, LinearGradientPaint.SRGB, affineTransform);
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LinearGradient@");
        stringBuilder.append(this.hashCode());
        stringBuilder.append('(');
        for (int i = 0; i < this.stopOffsets.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.stopOffsets[i]);
            stringBuilder.append('=');
            stringBuilder.append(this.stopOpacities[i]);
            stringBuilder.append(' ');
            stringBuilder.append(Integer.toHexString(this.stopColors[i].getRGB()));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.transform == null) {
            this.transform = (AffineTransform)affineTransform.clone();
        } else {
            this.transform.preConcatenate(affineTransform);
        }
    }

    @Override
    public Object clone() {
        try {
            LinearGradient linearGradient = (LinearGradient)super.clone();
            linearGradient.stopOffsets = (double[])this.stopOffsets.clone();
            linearGradient.stopColors = (Color[])this.stopColors.clone();
            linearGradient.stopOpacities = (double[])this.stopOpacities.clone();
            linearGradient.transform = (AffineTransform)this.transform.clone();
            return linearGradient;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError();
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
    }

    @Override
    public void makeRelativeToFigureBounds(Figure figure) {
        if (!this.isRelativeToFigureBounds) {
            this.isRelativeToFigureBounds = true;
            Rectangle2D.Double double_ = figure.getBounds();
            this.x1 = (this.x1 - double_.x) / double_.width;
            this.y1 = (this.y1 - double_.y) / double_.height;
            this.x2 = (this.x2 - double_.x) / double_.width;
            this.y2 = (this.y2 - double_.y) / double_.height;
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x1);
        l += Double.doubleToLongBits(this.y1) * 31L;
        l += Double.doubleToLongBits(this.x2) * 35L;
        l += Double.doubleToLongBits(this.y2) * 39L;
        l += (long)(this.stopColors[0].hashCode() * 43);
        return (int)(l += (long)(this.stopColors[this.stopColors.length - 1].hashCode() * 47)) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof LinearGradient) {
            return this.equals((LinearGradient)object);
        }
        return false;
    }

    public boolean equals(LinearGradient linearGradient) {
        return this.x1 == linearGradient.x1 && this.y1 == linearGradient.y1 && this.x2 == linearGradient.x2 && this.y2 == linearGradient.y2 && this.isRelativeToFigureBounds == linearGradient.isRelativeToFigureBounds && Arrays.equals(this.stopOffsets, linearGradient.stopOffsets) && Arrays.equals(this.stopOpacities, linearGradient.stopOpacities) && Arrays.equals(this.stopColors, linearGradient.stopColors) && this.transform.equals(linearGradient.transform);
    }
}

