/*
 * Copyright (C) 2021 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef __PAN_BLITTER_H
#define __PAN_BLITTER_H

#include "util/format/u_format.h"
#include "pan_desc.h"
#include "pan_pool.h"
#include "pan_texture.h"
#include "pan_util.h"

struct pan_blend_shader_cache;
struct pan_fb_info;
struct pan_jc;
struct pan_pool;

struct pan_blitter_cache {
   unsigned gpu_id;
   struct {
      struct pan_pool *pool;
      struct hash_table *blit;
      struct hash_table *blend;
      pthread_mutex_t lock;
   } shaders;
   struct {
      struct pan_pool *pool;
      struct hash_table *rsds;
      pthread_mutex_t lock;
   } rsds;
   struct pan_blend_shader_cache *blend_shader_cache;
};

struct pan_blit_info {
   struct {
      struct {
         const struct pan_image *image;
         enum pipe_format format;
      } planes[MAX_IMAGE_PLANES];
      unsigned level;
      struct {
         int32_t x, y, z;
         unsigned layer;
      } start, end;
   } src, dst;
   struct {
      bool enable;
      uint16_t minx, miny, maxx, maxy;
   } scissor;
   bool nearest;
};

struct pan_blit_context {
   mali_ptr rsd, vpd;
   mali_ptr textures;
   mali_ptr samplers;
   mali_ptr position;
   struct {
      enum mali_texture_dimension dim;
      struct {
         float x, y;
      } start, end;
      union {
         unsigned layer_offset;
         float z_offset;
      };
   } src;
   struct {
      int32_t layer_offset;
      int32_t cur_layer;
      int32_t last_layer;
   } dst;
   float z_scale;
};

#ifdef PAN_ARCH
void GENX(pan_blitter_cache_init)(struct pan_blitter_cache *cache,
                                  unsigned gpu_id,
                                  struct pan_blend_shader_cache *blend_shader_cache,
                                  struct pan_pool *bin_pool,
                                  struct pan_pool *desc_pool);

void GENX(pan_blitter_cache_cleanup)(struct pan_blitter_cache *cache);

unsigned GENX(pan_preload_fb)(struct pan_blitter_cache *cache,
                              struct pan_pool *desc_pool,
                              struct pan_fb_info *fb, unsigned layer_idx,
                              mali_ptr tsd, struct panfrost_ptr *jobs);
#endif

#endif
